/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imapserver.netty;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.frame.LineBasedFrameDecoder;

public class SwitchableLineBasedFrameDecoder
extends LineBasedFrameDecoder {
    private static final Boolean FAIL_FAST = true;
    private volatile boolean framingEnabled = true;

    public SwitchableLineBasedFrameDecoder(int maxFrameLength, boolean stripDelimiter) {
        super(maxFrameLength, stripDelimiter, FAIL_FAST == false);
    }

    public synchronized void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        if (this.framingEnabled) {
            super.messageReceived(ctx, e);
        } else {
            ctx.sendUpstream((ChannelEvent)e);
        }
    }

    public synchronized void enableFraming() {
        this.framingEnabled = true;
    }

    public synchronized void disableFraming(ChannelHandlerContext ctx) {
        this.framingEnabled = false;
        if (this.cumulation != null && this.cumulation.readable()) {
            ChannelBuffer spareBytes = this.cumulation.readBytes(this.cumulation.readableBytes());
            Channels.fireMessageReceived((ChannelHandlerContext)ctx, (Object)spareBytes);
        }
    }
}

