/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imapserver.netty;

import java.io.IOException;
import java.io.InputStream;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.decode.DecodingException;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.utils.EolInputStream;
import org.apache.james.imap.utils.FixedLengthInputStream;
import org.apache.james.imapserver.netty.AbstractNettyImapRequestLineReader;
import org.jboss.netty.channel.Channel;

public class NettyStreamImapRequestLineReader
extends AbstractNettyImapRequestLineReader {
    private final InputStream in;

    public NettyStreamImapRequestLineReader(Channel channel, InputStream in, boolean retry) {
        super(channel, retry);
        this.in = in;
    }

    public char nextChar() throws DecodingException {
        if (!this.nextSeen) {
            int next;
            try {
                next = this.in.read();
            }
            catch (IOException e) {
                throw new DecodingException(HumanReadableText.SOCKET_IO_FAILURE, "Error reading from stream.", (Throwable)e);
            }
            if (next == -1) {
                throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unexpected end of stream.");
            }
            this.nextSeen = true;
            this.nextChar = (char)next;
        }
        return this.nextChar;
    }

    public InputStream read(int size, boolean extraCRLF) throws DecodingException {
        this.nextSeen = false;
        this.nextChar = '\u0000';
        FixedLengthInputStream fin = new FixedLengthInputStream(this.in, (long)size);
        if (extraCRLF) {
            return new EolInputStream((ImapRequestLineReader)this, (InputStream)fin);
        }
        return fin;
    }

    public void dispose() throws IOException {
        this.in.close();
    }
}

