/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imapserver.netty;

import java.io.InputStream;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.decode.DecodingException;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.utils.EolInputStream;
import org.apache.james.imapserver.netty.AbstractNettyImapRequestLineReader;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferInputStream;
import org.jboss.netty.channel.Channel;

public class NettyImapRequestLineReader
extends AbstractNettyImapRequestLineReader {
    private final ChannelBuffer buffer;
    private int read = 0;
    private final int maxLiteralSize;

    public NettyImapRequestLineReader(Channel channel, ChannelBuffer buffer, boolean retry, int maxLiteralSize) {
        super(channel, retry);
        this.buffer = buffer;
        this.maxLiteralSize = maxLiteralSize;
    }

    public char nextChar() throws DecodingException {
        if (!this.nextSeen) {
            byte next;
            if (this.buffer.readable()) {
                next = this.buffer.readByte();
                ++this.read;
            } else {
                throw new NotEnoughDataException();
            }
            this.nextSeen = true;
            this.nextChar = (char)next;
        }
        return this.nextChar;
    }

    public InputStream read(int size, boolean extraCRLF) throws DecodingException {
        int crlf = 0;
        if (extraCRLF) {
            crlf = 2;
        }
        if (this.maxLiteralSize > 0 && this.maxLiteralSize > size) {
            throw new DecodingException(HumanReadableText.FAILED, "Specified literal is greater then the allowed size");
        }
        if (size + crlf > this.buffer.readableBytes()) {
            throw new NotEnoughDataException(size + this.read + crlf);
        }
        this.nextSeen = false;
        this.nextChar = '\u0000';
        BoundedInputStream in = new BoundedInputStream((InputStream)new ChannelBufferInputStream(this.buffer), (long)size);
        if (extraCRLF) {
            return new EolInputStream((ImapRequestLineReader)this, (InputStream)in);
        }
        return in;
    }

    public static final class NotEnoughDataException
    extends RuntimeException {
        public static final int UNKNOWN_SIZE = -1;
        private final int size;

        public NotEnoughDataException(int size) {
            this.size = size;
        }

        public NotEnoughDataException() {
            this(-1);
        }

        public int getNeededSize() {
            return this.size;
        }
    }
}

