/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imapserver.netty;

import java.io.Closeable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Optional;
import org.apache.james.core.Username;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.util.MDCBuilder;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelLocal;

public class IMAPMDCContext {
    public static Closeable from(ChannelHandlerContext ctx, ChannelLocal<Object> attributes) {
        return MDCBuilder.create().addContext(IMAPMDCContext.from(attributes.get(ctx.getChannel()))).addContext("protocol", (Object)"IMAP").addContext("ip", (Object)IMAPMDCContext.retrieveIp(ctx)).addContext("host", (Object)IMAPMDCContext.retrieveHost(ctx)).build();
    }

    private static String retrieveIp(ChannelHandlerContext ctx) {
        SocketAddress remoteAddress = ctx.getChannel().getRemoteAddress();
        if (remoteAddress instanceof InetSocketAddress) {
            InetSocketAddress address = (InetSocketAddress)remoteAddress;
            return address.getAddress().getHostAddress();
        }
        return remoteAddress.toString();
    }

    private static String retrieveHost(ChannelHandlerContext ctx) {
        SocketAddress remoteAddress = ctx.getChannel().getRemoteAddress();
        if (remoteAddress instanceof InetSocketAddress) {
            InetSocketAddress address = (InetSocketAddress)remoteAddress;
            return address.getHostName();
        }
        return remoteAddress.toString();
    }

    private static MDCBuilder from(Object o) {
        if (o instanceof ImapSession) {
            ImapSession imapSession = (ImapSession)o;
            return MDCBuilder.create().addContext("user", Optional.ofNullable(imapSession.getUserName()).map(Username::asString)).addContext(IMAPMDCContext.from(Optional.ofNullable(imapSession.getSelected())));
        }
        return MDCBuilder.create();
    }

    private static MDCBuilder from(Optional<SelectedMailbox> selectedMailbox) {
        return selectedMailbox.map(value -> MDCBuilder.create().addContext("selectedMailbox", (Object)value.getMailboxId().serialize())).orElse(MDCBuilder.create());
    }
}

