/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.mail.model.openjpa;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import javax.mail.Flags;
import javax.mail.internet.SharedInputStream;
import javax.mail.util.SharedByteArrayInputStream;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Table;
import org.apache.commons.io.IOUtils;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.jpa.mail.model.JPAMailbox;
import org.apache.james.mailbox.jpa.mail.model.openjpa.AbstractJPAMailboxMessage;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.mail.model.impl.PropertyBuilder;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.persistence.Persistent;

@Entity(name="MailboxMessage")
@Table(name="JAMES_MAIL")
public class JPAStreamingMailboxMessage
extends AbstractJPAMailboxMessage
implements PersistenceCapable {
    @Persistent(optional=false, fetch=FetchType.LAZY)
    @Column(name="MAIL_BYTES", length=1048576000, nullable=false)
    private InputStream body;
    @Persistent(optional=false, fetch=FetchType.LAZY)
    @Column(name="HEADER_BYTES", length=0xA00000, nullable=false)
    private InputStream header;
    private final SharedInputStream content;
    private static int pcInheritedFieldCount = AbstractJPAMailboxMessage.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    static /* synthetic */ Class class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMailboxMessage;
    static /* synthetic */ Class class$Ljava$io$InputStream;
    static /* synthetic */ Class class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$JPAStreamingMailboxMessage;

    public JPAStreamingMailboxMessage(JPAMailbox mailbox, Date internalDate, int size, Flags flags, SharedInputStream content, int bodyStartOctet, PropertyBuilder propertyBuilder) throws MailboxException {
        super(mailbox, internalDate, flags, size, bodyStartOctet, propertyBuilder);
        this.content = content;
        try {
            this.header = this.getHeaderContent();
            this.body = this.getBodyContent();
        }
        catch (IOException e) {
            throw new MailboxException("Unable to parse message", (Throwable)e);
        }
    }

    public JPAStreamingMailboxMessage(JPAMailbox mailbox, MessageUid uid, ModSeq modSeq, MailboxMessage message) throws MailboxException {
        super(mailbox, uid, modSeq, message);
        try {
            this.content = new SharedByteArrayInputStream(IOUtils.toByteArray((InputStream)message.getFullContent()));
            this.header = this.getHeaderContent();
            this.body = this.getBodyContent();
        }
        catch (IOException e) {
            throw new MailboxException("Unable to parse message", (Throwable)e);
        }
    }

    public InputStream getBodyContent() throws IOException {
        return this.content.newStream((long)this.getBodyStartOctet(), -1L);
    }

    public InputStream getHeaderContent() throws IOException {
        int headerEnd = this.getBodyStartOctet() - 2;
        if (headerEnd < 0) {
            headerEnd = 0;
        }
        return this.content.newStream(0L, (long)headerEnd);
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 2;
    }

    public JPAStreamingMailboxMessage() {
    }

    static {
        Class clazz = class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMailboxMessage != null ? class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMailboxMessage : (class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMailboxMessage = JPAStreamingMailboxMessage.class$("org.apache.james.mailbox.jpa.mail.model.openjpa.AbstractJPAMailboxMessage"));
        pcPCSuperclass = clazz;
        pcFieldNames = new String[]{"body", "header"};
        Class[] classArray = new Class[2];
        Class clazz2 = class$Ljava$io$InputStream != null ? class$Ljava$io$InputStream : (class$Ljava$io$InputStream = JPAStreamingMailboxMessage.class$("java.io.InputStream"));
        classArray[0] = clazz2;
        classArray[1] = class$Ljava$io$InputStream != null ? class$Ljava$io$InputStream : (class$Ljava$io$InputStream = JPAStreamingMailboxMessage.class$("java.io.InputStream"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{5, 5};
        Class clazz3 = class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$JPAStreamingMailboxMessage != null ? class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$JPAStreamingMailboxMessage : (class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$JPAStreamingMailboxMessage = JPAStreamingMailboxMessage.class$("org.apache.james.mailbox.jpa.mail.model.openjpa.JPAStreamingMailboxMessage"));
        PCRegistry.register((Class)clazz3, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"MailboxMessage", (PersistenceCapable)new JPAStreamingMailboxMessage());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.body = null;
        this.header = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JPAStreamingMailboxMessage jPAStreamingMailboxMessage = new JPAStreamingMailboxMessage();
        if (bl) {
            jPAStreamingMailboxMessage.pcClearFields();
        }
        jPAStreamingMailboxMessage.pcStateManager = stateManager;
        jPAStreamingMailboxMessage.pcCopyKeyFieldsFromObjectId(object);
        return jPAStreamingMailboxMessage;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JPAStreamingMailboxMessage jPAStreamingMailboxMessage = new JPAStreamingMailboxMessage();
        if (bl) {
            jPAStreamingMailboxMessage.pcClearFields();
        }
        jPAStreamingMailboxMessage.pcStateManager = stateManager;
        return jPAStreamingMailboxMessage;
    }

    protected static int pcGetManagedFieldCount() {
        return 2 + AbstractJPAMailboxMessage.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.body = (InputStream)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.header = (InputStream)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.body);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.header);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(JPAStreamingMailboxMessage jPAStreamingMailboxMessage, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(jPAStreamingMailboxMessage, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.body = jPAStreamingMailboxMessage.body;
                return;
            }
            case 1: {
                this.header = jPAStreamingMailboxMessage.header;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        JPAStreamingMailboxMessage jPAStreamingMailboxMessage = (JPAStreamingMailboxMessage)object;
        if (jPAStreamingMailboxMessage.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(jPAStreamingMailboxMessage, nArray[n]);
            ++n;
        }
    }

    @Override
    public Class pcGetIDOwningClass() {
        Class clazz = class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$JPAStreamingMailboxMessage != null ? class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$JPAStreamingMailboxMessage : (class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$JPAStreamingMailboxMessage = JPAStreamingMailboxMessage.class$("org.apache.james.mailbox.jpa.mail.model.openjpa.JPAStreamingMailboxMessage"));
        return clazz;
    }

    private static final InputStream pcGetbody(JPAStreamingMailboxMessage jPAStreamingMailboxMessage) {
        if (jPAStreamingMailboxMessage.pcStateManager == null) {
            return jPAStreamingMailboxMessage.body;
        }
        int n = pcInheritedFieldCount + 0;
        jPAStreamingMailboxMessage.pcStateManager.accessingField(n);
        return jPAStreamingMailboxMessage.body;
    }

    private static final void pcSetbody(JPAStreamingMailboxMessage jPAStreamingMailboxMessage, InputStream inputStream) {
        if (jPAStreamingMailboxMessage.pcStateManager == null) {
            jPAStreamingMailboxMessage.body = inputStream;
            return;
        }
        jPAStreamingMailboxMessage.pcStateManager.settingObjectField((PersistenceCapable)jPAStreamingMailboxMessage, pcInheritedFieldCount + 0, (Object)jPAStreamingMailboxMessage.body, (Object)inputStream, 0);
    }

    private static final InputStream pcGetheader(JPAStreamingMailboxMessage jPAStreamingMailboxMessage) {
        if (jPAStreamingMailboxMessage.pcStateManager == null) {
            return jPAStreamingMailboxMessage.header;
        }
        int n = pcInheritedFieldCount + 1;
        jPAStreamingMailboxMessage.pcStateManager.accessingField(n);
        return jPAStreamingMailboxMessage.header;
    }

    private static final void pcSetheader(JPAStreamingMailboxMessage jPAStreamingMailboxMessage, InputStream inputStream) {
        if (jPAStreamingMailboxMessage.pcStateManager == null) {
            jPAStreamingMailboxMessage.header = inputStream;
            return;
        }
        jPAStreamingMailboxMessage.pcStateManager.settingObjectField((PersistenceCapable)jPAStreamingMailboxMessage, pcInheritedFieldCount + 1, (Object)jPAStreamingMailboxMessage.header, (Object)inputStream, 0);
    }
}

