/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.spring;

import javax.inject.Inject;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.SessionProvider;
import org.apache.james.mailbox.events.EventBus;
import org.apache.james.mailbox.events.MailboxListener;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.event.MailboxAnnotationListener;
import org.apache.james.mailbox.store.quota.ListeningCurrentQuotaUpdater;
import org.apache.james.mailbox.store.quota.QuotaUpdater;
import org.apache.james.mailbox.store.search.ListeningMessageSearchIndex;
import org.apache.james.mailbox.store.search.MessageSearchIndex;

public class MailboxInitializer {
    private final SessionProvider sessionProvider;
    private final EventBus eventBus;
    private final MessageSearchIndex messageSearchIndex;
    private final QuotaUpdater quotaUpdater;
    private final MailboxManager mailboxManager;
    private final MailboxSessionMapperFactory mapperFactory;

    @Inject
    public MailboxInitializer(SessionProvider sessionProvider, EventBus eventBus, MessageSearchIndex messageSearchIndex, QuotaUpdater quotaUpdater, MailboxManager mailboxManager, MailboxSessionMapperFactory mapperFactory) {
        this.sessionProvider = sessionProvider;
        this.eventBus = eventBus;
        this.messageSearchIndex = messageSearchIndex;
        this.quotaUpdater = quotaUpdater;
        this.mailboxManager = mailboxManager;
        this.mapperFactory = mapperFactory;
    }

    public void init() {
        if (this.messageSearchIndex instanceof ListeningMessageSearchIndex) {
            ListeningMessageSearchIndex index = (ListeningMessageSearchIndex)this.messageSearchIndex;
            this.eventBus.register((MailboxListener.GroupMailboxListener)index);
        }
        if (this.quotaUpdater instanceof ListeningCurrentQuotaUpdater) {
            ListeningCurrentQuotaUpdater listeningCurrentQuotaUpdater = (ListeningCurrentQuotaUpdater)this.quotaUpdater;
            this.eventBus.register((MailboxListener.GroupMailboxListener)listeningCurrentQuotaUpdater);
        }
        if (this.mailboxManager.getSupportedMailboxCapabilities().contains(MailboxManager.MailboxCapabilities.Annotation)) {
            this.eventBus.register((MailboxListener.GroupMailboxListener)new MailboxAnnotationListener(this.mapperFactory, this.sessionProvider));
        }
    }
}

