/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.lib;

import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.mail.internet.AddressException;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.util.OptionalUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingSource
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MappingSource.class);
    private static final String WILDCARD = "*";
    private final Optional<Domain> domain;
    private final Optional<Username> user;
    private final Optional<WildCard> wildcard;

    public static MappingSource fromDomain(Domain domain) {
        if (domain.asString().equals(WILDCARD)) {
            return MappingSource.wildCard();
        }
        return new MappingSource(Optional.of(domain), Optional.empty(), Optional.empty());
    }

    public static MappingSource fromMailAddress(MailAddress address) {
        return MappingSource.fromUser(Username.fromMailAddress((MailAddress)address));
    }

    public static MappingSource fromUser(String localPart, String domain) {
        return MappingSource.fromUser(localPart, Domain.of((String)domain));
    }

    public static MappingSource fromUser(String localPart, Domain domain) {
        Username username = Username.fromLocalPartWithDomain((String)localPart, (Domain)domain);
        return MappingSource.fromUser(username);
    }

    public static MappingSource fromUser(Username username) {
        if (username.getLocalPart().equals(WILDCARD)) {
            return MappingSource.fromDomain((Domain)username.getDomainPart().get());
        }
        return new MappingSource(Optional.empty(), Optional.of(username), Optional.empty());
    }

    public static MappingSource wildCard() {
        return new MappingSource(Optional.empty(), Optional.empty(), Optional.of(WildCard.WildCard));
    }

    public static MappingSource parse(String mappingSource) {
        switch (mappingSource) {
            case "*": {
                return MappingSource.wildCard();
            }
        }
        if (mappingSource.startsWith("*@")) {
            return MappingSource.fromDomain(Domain.of((String)mappingSource.substring(2)));
        }
        return MappingSource.fromUser(Username.of((String)mappingSource));
    }

    private MappingSource(Optional<Domain> domain, Optional<Username> user, Optional<WildCard> wildcard) {
        this.domain = domain;
        this.user = user;
        this.wildcard = wildcard;
    }

    public Optional<Username> asUsername() {
        return this.user;
    }

    public Optional<Domain> asDomain() {
        return this.domain;
    }

    public Optional<MailAddress> asMailAddress() {
        return this.user.flatMap(user -> {
            try {
                return Optional.of(user.asMailAddress());
            }
            catch (AddressException e) {
                LOGGER.warn("Ignoring failing MappingSource to MailAddress conversion for user {}", user, (Object)e);
                return Optional.empty();
            }
        });
    }

    public String asString() {
        return (String)OptionalUtils.orSuppliers((Supplier[])new Supplier[]{() -> this.wildcard.map(x -> WILDCARD), () -> this.user.map(Username::asString), () -> this.domain.map(Domain::asString)}).orElseThrow(IllegalStateException::new);
    }

    public String getFixedUser() {
        return this.user.map(Username::getLocalPart).orElse(WILDCARD);
    }

    public String getFixedDomain() {
        return this.availableDomain().map(Domain::asString).orElse(WILDCARD);
    }

    public Optional<Domain> availableDomain() {
        return OptionalUtils.or((Optional[])new Optional[]{this.user.flatMap(Username::getDomainPart), this.domain});
    }

    public final boolean equals(Object o) {
        if (o instanceof MappingSource) {
            MappingSource that = (MappingSource)o;
            return Objects.equals(this.domain, that.domain) && Objects.equals(this.user, that.user) && Objects.equals(this.wildcard, that.wildcard);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.domain, this.user, this.wildcard);
    }

    public String asMailAddressString() {
        return this.getFixedUser() + "@" + this.getFixedDomain();
    }

    private static enum WildCard {
        WildCard;

    }
}

