/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.maildir.user;

import com.github.steveash.guavate.Guavate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.james.core.Username;
import org.apache.james.mailbox.exception.SubscriptionException;
import org.apache.james.mailbox.maildir.MaildirStore;
import org.apache.james.mailbox.store.transaction.NonTransactionalMapper;
import org.apache.james.mailbox.store.user.SubscriptionMapper;
import org.apache.james.mailbox.store.user.model.Subscription;

public class MaildirSubscriptionMapper
extends NonTransactionalMapper
implements SubscriptionMapper {
    private static final String FILE_SUBSCRIPTION = "subscriptions";
    private final MaildirStore store;

    public MaildirSubscriptionMapper(MaildirStore store) {
        this.store = store;
    }

    public void delete(Subscription subscription) throws SubscriptionException {
        boolean changed;
        Set<String> subscriptionNames = this.readSubscriptionsForUser(subscription.getUser());
        Sets.SetView newSubscriptions = Sets.difference(subscriptionNames, (Set)ImmutableSet.of((Object)subscription.getMailbox()));
        boolean bl = changed = subscriptionNames.size() != newSubscriptions.size();
        if (changed) {
            try {
                this.writeSubscriptions(new File(this.store.userRoot(subscription.getUser())), (Set<String>)newSubscriptions);
            }
            catch (IOException e) {
                throw new SubscriptionException((Exception)e);
            }
        }
    }

    public List<Subscription> findSubscriptionsForUser(Username user) throws SubscriptionException {
        Set<String> subscriptionNames = this.readSubscriptionsForUser(user);
        return (List)subscriptionNames.stream().map(subscription -> new Subscription(user, subscription)).collect(Guavate.toImmutableList());
    }

    public void save(Subscription subscription) throws SubscriptionException {
        boolean changed;
        Set<String> subscriptionNames = this.readSubscriptionsForUser(subscription.getUser());
        ImmutableSet newSubscriptions = ImmutableSet.builder().addAll(subscriptionNames).add((Object)subscription.getMailbox()).build();
        boolean bl = changed = subscriptionNames.size() != newSubscriptions.size();
        if (changed) {
            try {
                this.writeSubscriptions(new File(this.store.userRoot(subscription.getUser())), (Set<String>)newSubscriptions);
            }
            catch (IOException e) {
                throw new SubscriptionException((Exception)e);
            }
        }
    }

    public void endRequest() {
    }

    private Set<String> readSubscriptionsForUser(Username user) throws SubscriptionException {
        File userRoot = new File(this.store.userRoot(user));
        try {
            return this.readSubscriptions(userRoot);
        }
        catch (IOException e) {
            throw new SubscriptionException((Exception)e);
        }
    }

    private Set<String> readSubscriptions(File mailboxFolder) throws IOException {
        File subscriptionFile = new File(mailboxFolder, FILE_SUBSCRIPTION);
        if (!subscriptionFile.exists()) {
            return ImmutableSet.of();
        }
        try (FileReader fileReader = new FileReader(subscriptionFile);){
            Set set;
            try (BufferedReader reader = new BufferedReader(fileReader);){
                set = (Set)reader.lines().filter(subscription -> !subscription.equals("")).collect(Guavate.toImmutableSet());
            }
            return set;
        }
    }

    private void writeSubscriptions(File mailboxFolder, Set<String> subscriptions) throws IOException {
        ArrayList<String> sortedSubscriptions = new ArrayList<String>(subscriptions);
        Collections.sort(sortedSubscriptions);
        if (!mailboxFolder.exists() && !mailboxFolder.mkdirs()) {
            throw new IOException("Could not create folder " + mailboxFolder);
        }
        File subscriptionFile = new File(mailboxFolder, FILE_SUBSCRIPTION);
        if (!subscriptionFile.exists() && !subscriptionFile.createNewFile()) {
            throw new IOException("Could not create file " + subscriptionFile);
        }
        try (FileWriter fileWriter = new FileWriter(subscriptionFile);
             PrintWriter writer = new PrintWriter(fileWriter);){
            sortedSubscriptions.forEach(writer::println);
        }
    }
}

