/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.maildir.mail;

import com.github.fge.lambdas.Throwing;
import com.github.steveash.guavate.Guavate;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import javax.mail.Flags;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.maildir.MaildirFolder;
import org.apache.james.mailbox.maildir.MaildirMessageName;
import org.apache.james.mailbox.maildir.MaildirStore;
import org.apache.james.mailbox.maildir.mail.model.MaildirMailboxMessage;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxCounters;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.mailbox.store.FlagsUpdateCalculator;
import org.apache.james.mailbox.store.mail.AbstractMessageMapper;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.ModSeqProvider;
import org.apache.james.mailbox.store.mail.UidProvider;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.mail.model.impl.SimpleMailboxMessage;
import org.apache.james.mailbox.store.mail.utils.ApplicableFlagCalculator;

public class MaildirMessageMapper
extends AbstractMessageMapper {
    private final MaildirStore maildirStore;
    private static final int BUF_SIZE = 2048;

    public MaildirMessageMapper(MailboxSession session, MaildirStore maildirStore) {
        super(session, (UidProvider)maildirStore, (ModSeqProvider)maildirStore);
        this.maildirStore = maildirStore;
    }

    public long countMessagesInMailbox(Mailbox mailbox) throws MailboxException {
        MaildirFolder folder = this.maildirStore.createMaildirFolder(mailbox);
        File newFolder = folder.getNewFolder();
        File curFolder = folder.getCurFolder();
        File[] newFiles = newFolder.listFiles();
        File[] curFiles = curFolder.listFiles();
        if (newFiles == null || curFiles == null) {
            throw new MailboxException("Unable to count messages in Mailbox " + mailbox, (Throwable)new IOException("Not a valid Maildir folder: " + this.maildirStore.getFolderName(mailbox)));
        }
        return newFiles.length + curFiles.length;
    }

    public long countUnseenMessagesInMailbox(Mailbox mailbox) throws MailboxException {
        MaildirFolder folder = this.maildirStore.createMaildirFolder(mailbox);
        File newFolder = folder.getNewFolder();
        File curFolder = folder.getCurFolder();
        String[] unseenMessages = curFolder.list(MaildirMessageName.FILTER_UNSEEN_MESSAGES);
        String[] newUnseenMessages = newFolder.list(MaildirMessageName.FILTER_UNSEEN_MESSAGES);
        if (newUnseenMessages == null || unseenMessages == null) {
            throw new MailboxException("Unable to count unseen messages in Mailbox " + mailbox, (Throwable)new IOException("Not a valid Maildir folder: " + this.maildirStore.getFolderName(mailbox)));
        }
        return newUnseenMessages.length + unseenMessages.length;
    }

    public void delete(Mailbox mailbox, MailboxMessage message) throws MailboxException {
        MaildirFolder folder = this.maildirStore.createMaildirFolder(mailbox);
        try {
            folder.delete(message.getUid());
        }
        catch (MailboxException e) {
            throw new MailboxException("Unable to delete MailboxMessage " + message + " in Mailbox " + mailbox, (Throwable)e);
        }
    }

    public Iterator<MailboxMessage> findInMailbox(Mailbox mailbox, MessageRange set, MessageMapper.FetchType fType, int max) throws MailboxException {
        List<MailboxMessage> results;
        MessageUid from = set.getUidFrom();
        MessageUid to = set.getUidTo();
        MessageRange.Type type = set.getType();
        switch (type) {
            default: {
                results = this.findMessagesInMailboxBetweenUIDs(mailbox, null, MessageUid.MIN_VALUE, null, max);
                break;
            }
            case FROM: {
                results = this.findMessagesInMailboxBetweenUIDs(mailbox, null, from, null, max);
                break;
            }
            case ONE: {
                results = this.findMessageInMailboxWithUID(mailbox, from);
                break;
            }
            case RANGE: {
                results = this.findMessagesInMailboxBetweenUIDs(mailbox, null, from, to, max);
            }
        }
        return results.iterator();
    }

    public List<MessageUid> findRecentMessageUidsInMailbox(Mailbox mailbox) throws MailboxException {
        MaildirFolder folder = this.maildirStore.createMaildirFolder(mailbox);
        SortedMap<MessageUid, MaildirMessageName> recentMessageNames = folder.getRecentMessages();
        return new ArrayList<MessageUid>(recentMessageNames.keySet());
    }

    public MessageUid findFirstUnseenMessageUid(Mailbox mailbox) throws MailboxException {
        List<MailboxMessage> result = this.findMessagesInMailbox(mailbox, MaildirMessageName.FILTER_UNSEEN_MESSAGES, 1);
        if (result.isEmpty()) {
            return null;
        }
        return result.get(0).getUid();
    }

    public List<MailboxCounters> getMailboxCounters(Collection<Mailbox> mailboxes) throws MailboxException {
        return (List)mailboxes.stream().map(Throwing.function(arg_0 -> ((MaildirMessageMapper)this).getMailboxCounters(arg_0)).sneakyThrow()).collect(Guavate.toImmutableList());
    }

    public Iterator<UpdatedFlags> updateFlags(Mailbox mailbox, FlagsUpdateCalculator flagsUpdateCalculator, MessageRange set) throws MailboxException {
        ArrayList<UpdatedFlags> updatedFlags = new ArrayList<UpdatedFlags>();
        MaildirFolder folder = this.maildirStore.createMaildirFolder(mailbox);
        Iterator<MailboxMessage> it = this.findInMailbox(mailbox, set, MessageMapper.FetchType.Metadata, -1);
        while (it.hasNext()) {
            MailboxMessage member = it.next();
            Flags originalFlags = member.createFlags();
            member.setFlags(flagsUpdateCalculator.buildNewFlags(originalFlags));
            Flags newFlags = member.createFlags();
            try {
                long modSeq;
                MaildirMessageName messageName = folder.getMessageNameByUid(member.getUid());
                if (messageName == null) continue;
                File messageFile = messageName.getFile();
                messageName.setFlags(member.createFlags());
                String newMessageName = messageName.getFullName();
                File newMessageFile = newFlags.contains(Flags.Flag.RECENT) ? new File(folder.getNewFolder(), newMessageName) : new File(folder.getCurFolder(), newMessageName);
                if (!newMessageFile.equals(messageFile)) {
                    FileUtils.moveFile((File)messageFile, (File)newMessageFile);
                    modSeq = newMessageFile.lastModified();
                } else {
                    modSeq = messageFile.lastModified();
                }
                member.setModSeq(ModSeq.of((long)modSeq));
                updatedFlags.add(UpdatedFlags.builder().uid(member.getUid()).modSeq(member.getModSeq()).newFlags(newFlags).oldFlags(originalFlags).build());
                MessageUid uid = member.getUid();
                folder.update(uid, newMessageName);
            }
            catch (IOException e) {
                throw new MailboxException("Failure while save MailboxMessage " + member + " in Mailbox " + mailbox, (Throwable)e);
            }
        }
        return updatedFlags.iterator();
    }

    public List<MessageUid> retrieveMessagesMarkedForDeletion(Mailbox mailbox, MessageRange messageRange) throws MailboxException {
        List<MailboxMessage> messages = this.findDeletedMessages(mailbox, messageRange);
        return this.getUidList(messages);
    }

    public Map<MessageUid, MessageMetaData> deleteMessages(Mailbox mailbox, List<MessageUid> uids) throws MailboxException {
        HashMap<MessageUid, MessageMetaData> data = new HashMap<MessageUid, MessageMetaData>();
        List ranges = MessageRange.toRanges(uids);
        for (MessageRange range : ranges) {
            List<MailboxMessage> messages = this.findDeletedMessages(mailbox, range);
            data.putAll(this.deleteDeletedMessages(mailbox, messages));
        }
        return data;
    }

    private List<MailboxMessage> findDeletedMessages(Mailbox mailbox, MessageRange messageRange) throws MailboxException {
        MessageUid from = messageRange.getUidFrom();
        MessageUid to = messageRange.getUidTo();
        switch (messageRange.getType()) {
            case ONE: {
                return this.findDeletedMessageInMailboxWithUID(mailbox, from);
            }
            case RANGE: {
                return this.findMessagesInMailboxBetweenUIDs(mailbox, MaildirMessageName.FILTER_DELETED_MESSAGES, from, to, -1);
            }
            case FROM: {
                return this.findMessagesInMailboxBetweenUIDs(mailbox, MaildirMessageName.FILTER_DELETED_MESSAGES, from, null, -1);
            }
            case ALL: {
                return this.findMessagesInMailbox(mailbox, MaildirMessageName.FILTER_DELETED_MESSAGES, -1);
            }
        }
        throw new RuntimeException("Cannot find deleted messages, range type " + messageRange.getType() + " doesn't exist");
    }

    private Map<MessageUid, MessageMetaData> deleteDeletedMessages(Mailbox mailbox, List<MailboxMessage> messages) throws MailboxException {
        return (Map)messages.stream().peek(Throwing.consumer(message -> this.delete(mailbox, (MailboxMessage)message)).sneakyThrow()).collect(Guavate.toImmutableMap(MailboxMessage::getUid, MailboxMessage::metaData));
    }

    private List<MessageUid> getUidList(List<MailboxMessage> messages) {
        return (List)messages.stream().map(MailboxMessage::getUid).collect(Guavate.toImmutableList());
    }

    public MessageMetaData move(Mailbox mailbox, MailboxMessage original) throws MailboxException {
        throw new UnsupportedOperationException("Not implemented - see https://issues.apache.org/jira/browse/IMAP-370");
    }

    protected MessageMetaData copy(Mailbox mailbox, MessageUid uid, ModSeq modSeq, MailboxMessage original) throws MailboxException {
        SimpleMailboxMessage theCopy = SimpleMailboxMessage.copyWithoutAttachments((MailboxId)mailbox.getMailboxId(), (MailboxMessage)original);
        Flags flags = theCopy.createFlags();
        flags.add(Flags.Flag.RECENT);
        theCopy.setFlags(flags);
        return this.save(mailbox, (MailboxMessage)theCopy);
    }

    protected MessageMetaData save(Mailbox mailbox, MailboxMessage message) throws MailboxException {
        MaildirFolder folder = this.maildirStore.createMaildirFolder(mailbox);
        MessageUid uid = MessageUid.MIN_VALUE;
        File tmpFolder = folder.getTmpFolder();
        MaildirMessageName messageName = MaildirMessageName.createUniqueName(folder, message.getFullContentOctets());
        File messageFile = new File(tmpFolder, messageName.getFullName());
        try {
            if (!messageFile.createNewFile()) {
                throw new IOException("Could not create file " + messageFile);
            }
            try (FileOutputStream fos = new FileOutputStream(messageFile);
                 InputStream input = message.getFullContent();){
                IOUtils.copy((InputStream)input, (OutputStream)fos, (int)2048);
            }
        }
        catch (IOException ioe) {
            throw new MailboxException("Failure while save MailboxMessage " + message + " in Mailbox " + mailbox, (Throwable)ioe);
        }
        File newMessageFile = null;
        if (message.isRecent()) {
            messageName.setFlags(message.createFlags());
            newMessageFile = new File(folder.getNewFolder(), messageName.getFullName());
        } else {
            messageName.setFlags(message.createFlags());
            newMessageFile = new File(folder.getCurFolder(), messageName.getFullName());
        }
        try {
            FileUtils.moveFile((File)messageFile, (File)newMessageFile);
        }
        catch (IOException e) {
            throw new MailboxException("Failure while save MailboxMessage " + message + " in Mailbox " + mailbox, (Throwable)e);
        }
        try {
            uid = folder.appendMessage(newMessageFile.getName());
            message.setUid(uid);
            message.setModSeq(ModSeq.of((long)newMessageFile.lastModified()));
            return message.metaData();
        }
        catch (MailboxException e) {
            throw new MailboxException("Failure while save MailboxMessage " + message + " in Mailbox " + mailbox, (Throwable)e);
        }
    }

    public Flags getApplicableFlag(Mailbox mailbox) throws MailboxException {
        int maxValue = -1;
        return new ApplicableFlagCalculator(this.findMessagesInMailboxBetweenUIDs(mailbox, null, MessageUid.MIN_VALUE, null, maxValue)).computeApplicableFlags();
    }

    public void endRequest() {
    }

    private List<MailboxMessage> findMessageInMailboxWithUID(Mailbox mailbox, MessageUid from) throws MailboxException {
        MaildirFolder folder = this.maildirStore.createMaildirFolder(mailbox);
        try {
            MaildirMessageName messageName = folder.getMessageNameByUid(from);
            ArrayList<MailboxMessage> messages = new ArrayList<MailboxMessage>();
            if (messageName != null && messageName.getFile().exists()) {
                messages.add((MailboxMessage)new MaildirMailboxMessage(mailbox, from, messageName));
            }
            return messages;
        }
        catch (IOException e) {
            throw new MailboxException("Failure while search for MailboxMessage with uid " + from + " in Mailbox " + mailbox, (Throwable)e);
        }
    }

    private List<MailboxMessage> findMessagesInMailboxBetweenUIDs(Mailbox mailbox, FilenameFilter filter, MessageUid from, MessageUid to, int max) throws MailboxException {
        MaildirFolder folder = this.maildirStore.createMaildirFolder(mailbox);
        int cur = 0;
        SortedMap<MessageUid, MaildirMessageName> uidMap = null;
        try {
            uidMap = filter != null ? folder.getUidMap(this.mailboxSession, filter, from, to) : folder.getUidMap(from, to);
            ArrayList<MailboxMessage> messages = new ArrayList<MailboxMessage>();
            for (Map.Entry<MessageUid, MaildirMessageName> entry : uidMap.entrySet()) {
                messages.add((MailboxMessage)new MaildirMailboxMessage(mailbox, entry.getKey(), entry.getValue()));
                if (max == -1 || ++cur < max) continue;
                break;
            }
            return messages;
        }
        catch (IOException e) {
            throw new MailboxException("Failure while search for Messages in Mailbox " + mailbox, (Throwable)e);
        }
    }

    private List<MailboxMessage> findMessagesInMailbox(Mailbox mailbox, FilenameFilter filter, int limit) throws MailboxException {
        MaildirFolder folder = this.maildirStore.createMaildirFolder(mailbox);
        try {
            SortedMap<MessageUid, MaildirMessageName> uidMap = folder.getUidMap(filter, limit);
            ArrayList<MailboxMessage> filtered = new ArrayList<MailboxMessage>(uidMap.size());
            for (Map.Entry<MessageUid, MaildirMessageName> entry : uidMap.entrySet()) {
                filtered.add((MailboxMessage)new MaildirMailboxMessage(mailbox, entry.getKey(), entry.getValue()));
            }
            return filtered;
        }
        catch (IOException e) {
            throw new MailboxException("Failure while search for Messages in Mailbox " + mailbox, (Throwable)e);
        }
    }

    private List<MailboxMessage> findDeletedMessageInMailboxWithUID(Mailbox mailbox, MessageUid uid) throws MailboxException {
        MaildirFolder folder = this.maildirStore.createMaildirFolder(mailbox);
        try {
            MaildirMessageName messageName = folder.getMessageNameByUid(uid);
            ArrayList<MailboxMessage> messages = new ArrayList<MailboxMessage>();
            if (MaildirMessageName.FILTER_DELETED_MESSAGES.accept(null, messageName.getFullName())) {
                messages.add((MailboxMessage)new MaildirMailboxMessage(mailbox, uid, messageName));
            }
            return messages;
        }
        catch (IOException e) {
            throw new MailboxException("Failure while search for Messages in Mailbox " + mailbox, (Throwable)e);
        }
    }

    protected void begin() throws MailboxException {
    }

    protected void commit() throws MailboxException {
    }

    protected void rollback() throws MailboxException {
    }
}

