/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.maildir.mail;

import com.github.steveash.guavate.Guavate;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.james.core.Username;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.acl.ACLDiff;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxExistsException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.maildir.MaildirFolder;
import org.apache.james.mailbox.maildir.MaildirId;
import org.apache.james.mailbox.maildir.MaildirMessageName;
import org.apache.james.mailbox.maildir.MaildirStore;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.UidValidity;
import org.apache.james.mailbox.model.search.MailboxNameExpression;
import org.apache.james.mailbox.model.search.MailboxQuery;
import org.apache.james.mailbox.model.search.PrefixedWildcard;
import org.apache.james.mailbox.store.MailboxExpressionBackwardCompatibility;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.transaction.NonTransactionalMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class MaildirMailboxMapper
extends NonTransactionalMapper
implements MailboxMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(MaildirMailboxMapper.class);
    private final MaildirStore maildirStore;
    private final MailboxSession session;

    public MaildirMailboxMapper(MaildirStore maildirStore, MailboxSession session) {
        this.maildirStore = maildirStore;
        this.session = session;
    }

    public void delete(Mailbox mailbox) throws MailboxException {
        String folderName = this.maildirStore.getFolderName(mailbox);
        File folder = new File(folderName);
        if (folder.isDirectory()) {
            if (mailbox.getName().equals("INBOX")) {
                this.delete(new File(folder, "cur"), new File(folder, "new"), new File(folder, "tmp"), new File(folder, "james-uidlist"), new File(folder, "james-uidvalidity"));
            } else {
                this.delete(folder);
            }
        } else {
            throw new MailboxNotFoundException(mailbox.generateAssociatedPath());
        }
    }

    private void delete(File ... files) {
        for (File file : files) {
            try {
                if (file.isDirectory()) {
                    FileUtils.deleteDirectory((File)file);
                    continue;
                }
                FileUtils.forceDelete((File)file);
            }
            catch (IOException e) {
                LOGGER.error("Error while deleting file {}", (Object)file, (Object)e);
            }
        }
    }

    public Mono<Mailbox> findMailboxByPath(MailboxPath mailboxPath) {
        try {
            return Mono.just((Object)this.maildirStore.loadMailbox(this.session, mailboxPath));
        }
        catch (MailboxException e) {
            return Mono.empty();
        }
    }

    public Mailbox findMailboxById(MailboxId id) throws MailboxException, MailboxNotFoundException {
        if (id == null) {
            throw new MailboxNotFoundException("null");
        }
        return this.list().stream().filter(mailbox -> mailbox.getMailboxId().equals(id)).findAny().orElseThrow(() -> new MailboxNotFoundException(id));
    }

    public List<Mailbox> findMailboxWithPathLike(MailboxQuery.UserBound query) throws MailboxException {
        String pathLike = MailboxExpressionBackwardCompatibility.getPathLike((MailboxQuery)query);
        Pattern searchPattern = Pattern.compile("[.]" + pathLike.replace(".", "\\.").replace("%", ".*"));
        FilenameFilter filter = MaildirMessageName.createRegexFilter(searchPattern);
        File root = this.maildirStore.getMailboxRootForUser(query.getFixedUser());
        File[] folders = root.listFiles(filter);
        ArrayList<Mailbox> mailboxList = new ArrayList<Mailbox>();
        for (File folder : folders) {
            if (!folder.isDirectory()) continue;
            Mailbox mailbox = this.maildirStore.loadMailbox(this.session, root, query.getFixedNamespace(), query.getFixedUser(), folder.getName());
            mailboxList.add(mailbox);
        }
        if (Pattern.matches(pathLike.replace("%", ".*"), "INBOX")) {
            Mailbox mailbox = this.maildirStore.loadMailbox(this.session, root, query.getFixedNamespace(), query.getFixedUser(), "");
            mailboxList.add(0, mailbox);
        }
        return (List)mailboxList.stream().filter(arg_0 -> ((MailboxQuery.UserBound)query).matches(arg_0)).collect(Guavate.toImmutableList());
    }

    public boolean hasChildren(Mailbox mailbox, char delimiter) throws MailboxException, MailboxNotFoundException {
        List<Mailbox> mailboxes = this.findMailboxWithPathLike(MailboxQuery.builder().userAndNamespaceFrom(mailbox.generateAssociatedPath()).expression((MailboxNameExpression)new PrefixedWildcard(mailbox.getName() + delimiter)).build().asUserBound());
        return mailboxes.size() > 0;
    }

    public Mailbox create(MailboxPath mailboxPath, UidValidity uidValidity) throws MailboxException {
        MaildirId maildirId = MaildirId.random();
        Mailbox mailbox = new Mailbox(mailboxPath, uidValidity, (MailboxId)maildirId);
        MaildirFolder folder = this.maildirStore.createMaildirFolder(mailbox);
        if (!folder.exists()) {
            boolean isCreated;
            boolean folderExist = folder.getRootFile().exists();
            if (!folderExist && !folder.getRootFile().mkdirs()) {
                throw new MailboxException("Failed to save Mailbox " + mailbox);
            }
            boolean bl = isCreated = folder.getCurFolder().mkdir() && folder.getNewFolder().mkdir() && folder.getTmpFolder().mkdir();
            if (!isCreated) {
                throw new MailboxException("Failed to save Mailbox " + mailbox, (Throwable)new IOException("Needed folder structure can not be created"));
            }
        }
        try {
            folder.setUidValidity(mailbox.getUidValidity());
            folder.setMailboxId(maildirId);
        }
        catch (IOException ioe) {
            throw new MailboxException("Failed to save Mailbox " + mailbox, (Throwable)ioe);
        }
        folder.setACL(mailbox.getACL());
        return mailbox;
    }

    public MailboxId rename(Mailbox mailbox) throws MailboxException {
        MaildirId maildirId = (MaildirId)mailbox.getMailboxId();
        Mailbox originalMailbox = this.findMailboxById(mailbox.getMailboxId());
        MaildirFolder folder = this.maildirStore.createMaildirFolder(mailbox);
        if (originalMailbox.getName() == null ? mailbox.getName() != null : !originalMailbox.getName().equals(mailbox.getName())) {
            if (folder.exists()) {
                throw new MailboxExistsException(mailbox.getName());
            }
            MaildirFolder originalFolder = this.maildirStore.createMaildirFolder(originalMailbox);
            if (originalMailbox.getName().equals("INBOX")) {
                try {
                    File inboxFolder = originalFolder.getRootFile();
                    File newFolder = folder.getRootFile();
                    FileUtils.forceMkdir((File)newFolder);
                    if (!originalFolder.getCurFolder().renameTo(folder.getCurFolder())) {
                        throw new IOException("Could not rename folder " + originalFolder.getCurFolder() + " to " + folder.getCurFolder());
                    }
                    if (!originalFolder.getMailboxIdFile().renameTo(folder.getMailboxIdFile())) {
                        throw new IOException("Could not rename folder " + originalFolder.getCurFolder() + " to " + folder.getCurFolder());
                    }
                    if (!originalFolder.getNewFolder().renameTo(folder.getNewFolder())) {
                        throw new IOException("Could not rename folder " + originalFolder.getNewFolder() + " to " + folder.getNewFolder());
                    }
                    if (!originalFolder.getTmpFolder().renameTo(folder.getTmpFolder())) {
                        throw new IOException("Could not rename folder " + originalFolder.getTmpFolder() + " to " + folder.getTmpFolder());
                    }
                    File oldUidListFile = new File(inboxFolder, "james-uidlist");
                    File newUidListFile = new File(newFolder, "james-uidlist");
                    if (!oldUidListFile.renameTo(newUidListFile)) {
                        throw new IOException("Could not rename file " + oldUidListFile + " to " + newUidListFile);
                    }
                    File oldValidityFile = new File(inboxFolder, "james-uidvalidity");
                    File newValidityFile = new File(newFolder, "james-uidvalidity");
                    if (!oldValidityFile.renameTo(newValidityFile)) {
                        throw new IOException("Could not rename file " + oldValidityFile + " to " + newValidityFile);
                    }
                    FileUtils.forceMkdir((File)originalFolder.getCurFolder());
                    FileUtils.forceMkdir((File)originalFolder.getNewFolder());
                    FileUtils.forceMkdir((File)originalFolder.getTmpFolder());
                    originalFolder.setMailboxId(MaildirId.random());
                }
                catch (IOException e) {
                    throw new MailboxException("Failed to save Mailbox " + mailbox, (Throwable)e);
                }
            } else if (!originalFolder.getRootFile().renameTo(folder.getRootFile())) {
                throw new MailboxException("Failed to save Mailbox " + mailbox, (Throwable)new IOException("Could not rename folder " + originalFolder));
            }
        }
        folder.setACL(mailbox.getACL());
        return maildirId;
    }

    public List<Mailbox> list() throws MailboxException {
        File maildirRoot = this.maildirStore.getMaildirRoot();
        ArrayList<Mailbox> mailboxList = new ArrayList<Mailbox>();
        if (this.maildirStore.getMaildirLocation().endsWith("/%domain/%user")) {
            File[] domains;
            for (File domain : domains = maildirRoot.listFiles()) {
                File[] users = domain.listFiles();
                this.visitUsersForMailboxList(domain, users, mailboxList);
            }
            return mailboxList;
        }
        File[] users = maildirRoot.listFiles();
        this.visitUsersForMailboxList(null, users, mailboxList);
        return mailboxList;
    }

    public void endRequest() {
    }

    private void visitUsersForMailboxList(File domain, File[] users, List<Mailbox> mailboxList) throws MailboxException {
        String userName = null;
        for (File user : users) {
            File[] mailboxes;
            userName = domain == null ? user.getName() : user.getName() + "@" + domain.getName();
            MailboxPath inboxMailboxPath = MailboxPath.forUser((Username)Username.of((String)userName), (String)"INBOX");
            try {
                mailboxList.add(this.maildirStore.loadMailbox(this.session, inboxMailboxPath));
            }
            catch (MailboxException mailboxException) {
                // empty catch block
            }
            for (File mailbox : mailboxes = user.listFiles(pathname -> pathname.getName().startsWith("."))) {
                MailboxPath mailboxPath = new MailboxPath("#private", Username.of((String)userName), mailbox.getName().substring(1));
                mailboxList.add(this.maildirStore.loadMailbox(this.session, mailboxPath));
            }
        }
    }

    public ACLDiff updateACL(Mailbox mailbox, MailboxACL.ACLCommand mailboxACLCommand) throws MailboxException {
        MaildirFolder folder = this.maildirStore.createMaildirFolder(mailbox);
        MailboxACL oldACL = mailbox.getACL();
        MailboxACL newACL = mailbox.getACL().apply(mailboxACLCommand);
        folder.setACL(newACL);
        mailbox.setACL(newACL);
        return ACLDiff.computeDiff((MailboxACL)oldACL, (MailboxACL)newACL);
    }

    public ACLDiff setACL(Mailbox mailbox, MailboxACL mailboxACL) throws MailboxException {
        MailboxACL oldAcl = mailbox.getACL();
        MaildirFolder folder = this.maildirStore.createMaildirFolder(mailbox);
        folder.setACL(mailboxACL);
        mailbox.setACL(mailboxACL);
        return ACLDiff.computeDiff((MailboxACL)oldAcl, (MailboxACL)mailboxACL);
    }

    public List<Mailbox> findNonPersonalMailboxes(Username userName, MailboxACL.Right right) throws MailboxException {
        return ImmutableList.of();
    }
}

