/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.maildir;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.maildir.MaildirId;
import org.apache.james.mailbox.maildir.MaildirMessageName;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.UidValidity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaildirFolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(MaildirFolder.class);
    public static final String VALIDITY_FILE = "james-uidvalidity";
    public static final String UIDLIST_FILE = "james-uidlist";
    public static final String ACL_FILE = "james-acl";
    public static final String MAILBOX_ID_FILE = "james-mailboxId";
    public static final String CUR = "cur";
    public static final String NEW = "new";
    public static final String TMP = "tmp";
    private final File rootFolder;
    private final File curFolder;
    private final File newFolder;
    private final File tmpFolder;
    private final File uidFile;
    private final File aclFile;
    private final File mailboxIdFile;
    private Optional<MessageUid> lastUid;
    private int messageCount = 0;
    private Optional<UidValidity> uidValidity = Optional.empty();
    private MailboxACL acl;
    private boolean messageNameStrictParse = false;
    private final MailboxPathLocker locker;
    private final MailboxPath path;

    public MaildirFolder(String absPath, MailboxPath path, MailboxPathLocker locker) {
        this.rootFolder = new File(absPath);
        this.curFolder = new File(this.rootFolder, CUR);
        this.newFolder = new File(this.rootFolder, NEW);
        this.tmpFolder = new File(this.rootFolder, TMP);
        this.uidFile = new File(this.rootFolder, UIDLIST_FILE);
        this.aclFile = new File(this.rootFolder, ACL_FILE);
        this.mailboxIdFile = new File(this.rootFolder, MAILBOX_ID_FILE);
        this.locker = locker;
        this.path = path;
        this.lastUid = Optional.empty();
    }

    private MaildirMessageName newMaildirMessageName(MaildirFolder folder, String fullName) {
        MaildirMessageName mdn = new MaildirMessageName(folder, fullName);
        mdn.setMessageNameStrictParse(this.isMessageNameStrictParse());
        return mdn;
    }

    public boolean isMessageNameStrictParse() {
        return this.messageNameStrictParse;
    }

    public void setMessageNameStrictParse(boolean messageNameStrictParse) {
        this.messageNameStrictParse = messageNameStrictParse;
    }

    public File getRootFile() {
        return this.rootFolder;
    }

    public boolean exists() {
        return this.rootFolder.isDirectory() && this.curFolder.isDirectory() && this.newFolder.isDirectory() && this.tmpFolder.isDirectory();
    }

    private boolean isModified() {
        long uidListModified = this.uidFile.lastModified();
        long curModified = this.curFolder.lastModified();
        long newModified = this.newFolder.lastModified();
        return curModified >= uidListModified || newModified >= uidListModified;
    }

    public File getCurFolder() {
        return this.curFolder;
    }

    public File getMailboxIdFile() {
        return this.mailboxIdFile;
    }

    public File getNewFolder() {
        return this.newFolder;
    }

    public File getTmpFolder() {
        return this.tmpFolder;
    }

    private MessageUid getNextUid() {
        MessageUid nextUid = this.lastUid.map(MessageUid::next).orElse(MessageUid.MIN_VALUE);
        this.lastUid = Optional.of(nextUid);
        return nextUid;
    }

    public Optional<MessageUid> getLastUid() throws MailboxException {
        if (!this.lastUid.isPresent()) {
            this.readLastUid();
        }
        return this.lastUid;
    }

    public ModSeq getHighestModSeq() throws IOException {
        long newModified = this.getNewFolder().lastModified();
        long curModified = this.getCurFolder().lastModified();
        if (newModified == 0L && curModified == 0L) {
            throw new IOException("Unable to read highest modSeq");
        }
        return ModSeq.of((long)Math.max(newModified, curModified));
    }

    private void readLastUid() throws MailboxException {
        this.locker.executeWithLock(this.path, () -> {
            File uidList = this.uidFile;
            if (!uidList.exists()) {
                this.createUidFile();
            }
            try (FileReader fileReader = new FileReader(uidList);){
                Void void_;
                try (BufferedReader reader = new BufferedReader(fileReader);){
                    String line = reader.readLine();
                    if (line != null) {
                        this.readUidListHeader(line);
                    }
                    void_ = null;
                }
                return void_;
            }
            catch (IOException e) {
                throw new MailboxException("Unable to read last uid", (Throwable)e);
            }
        }, MailboxPathLocker.LockType.Write);
    }

    public UidValidity getUidValidity() throws IOException {
        if (!this.uidValidity.isPresent()) {
            this.uidValidity = Optional.of(this.readUidValidity());
        }
        return this.uidValidity.get();
    }

    public void setUidValidity(UidValidity uidValidity) throws IOException {
        this.saveUidValidity(uidValidity);
        this.uidValidity = Optional.of(uidValidity);
    }

    private UidValidity readUidValidity() throws IOException {
        File validityFile = new File(this.rootFolder, VALIDITY_FILE);
        if (!validityFile.exists()) {
            return this.resetUidValidity();
        }
        try (FileInputStream fis = new FileInputStream(validityFile);){
            UidValidity uidValidity;
            try (InputStreamReader isr = new InputStreamReader(fis);){
                char[] uidValidity2 = new char[20];
                int len = isr.read(uidValidity2);
                long uidValidityValue = Long.parseLong(String.valueOf(uidValidity2, 0, len).trim());
                uidValidity = this.sanitizeUidValidity(uidValidityValue);
            }
            return uidValidity;
        }
    }

    private UidValidity sanitizeUidValidity(long uidValidityValue) throws IOException {
        if (!UidValidity.isValid((long)uidValidityValue)) {
            return this.resetUidValidity();
        }
        return UidValidity.of((long)uidValidityValue);
    }

    private void saveUidValidity(UidValidity uidValidity) throws IOException {
        File validityFile = new File(this.rootFolder, VALIDITY_FILE);
        if (!validityFile.createNewFile()) {
            throw new IOException("Could not create file " + validityFile);
        }
        try (FileOutputStream fos = new FileOutputStream(validityFile);){
            fos.write(String.valueOf(uidValidity.asLong()).getBytes());
        }
    }

    public void setMailboxId(MaildirId mailboxId) throws IOException {
        this.saveMailboxId(mailboxId);
    }

    public MaildirId readMailboxId() throws IOException {
        if (!this.mailboxIdFile.exists()) {
            MaildirId maildirId = MaildirId.random();
            this.saveMailboxId(maildirId);
            return maildirId;
        }
        try (FileInputStream fileInputStream = new FileInputStream(this.mailboxIdFile);){
            String serializedMaildirId = IOUtils.toString((InputStream)fileInputStream, (Charset)StandardCharsets.UTF_8);
            MaildirId maildirId = MaildirId.fromString(serializedMaildirId);
            return maildirId;
        }
    }

    private void saveMailboxId(MaildirId id) throws IOException {
        if (!this.mailboxIdFile.createNewFile()) {
            throw new IOException("Could not create file " + this.mailboxIdFile);
        }
        try (FileOutputStream fos = new FileOutputStream(this.mailboxIdFile);){
            fos.write(id.serialize().getBytes(StandardCharsets.UTF_8));
        }
    }

    private UidValidity resetUidValidity() throws IOException {
        UidValidity uidValidity = UidValidity.generate();
        this.setUidValidity(uidValidity);
        return uidValidity;
    }

    public MaildirMessageName getMessageNameByUid(MessageUid uid) throws MailboxException {
        return (MaildirMessageName)this.locker.executeWithLock(this.path, () -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 15[WHILELOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }, MailboxPathLocker.LockType.Write);
    }

    public SortedMap<MessageUid, MaildirMessageName> getUidMap(MessageUid from, MessageUid to) throws MailboxException {
        return (SortedMap)this.locker.executeWithLock(this.path, () -> {
            TreeMap<MessageUid, MaildirMessageName> uidMap = new TreeMap<MessageUid, MaildirMessageName>();
            File uidList = this.uidFile;
            if (uidList.isFile()) {
                if (this.isModified()) {
                    try {
                        uidMap.putAll(this.truncateMap(this.updateUidFile(), from, to));
                    }
                    catch (MailboxException e) {
                        uidMap.putAll(this.truncateMap(this.createUidFile(), from, to));
                    }
                } else {
                    uidMap.putAll(this.readUidFile(from, to));
                }
            } else {
                uidMap.putAll(this.truncateMap(this.createUidFile(), from, to));
            }
            return uidMap;
        }, MailboxPathLocker.LockType.Write);
    }

    public SortedMap<MessageUid, MaildirMessageName> getUidMap(MailboxSession session, FilenameFilter filter, MessageUid from, MessageUid to) throws MailboxException {
        SortedMap<MessageUid, MaildirMessageName> allUids = this.getUidMap(from, to);
        TreeMap<MessageUid, MaildirMessageName> filteredUids = new TreeMap<MessageUid, MaildirMessageName>();
        for (Map.Entry<MessageUid, MaildirMessageName> entry : allUids.entrySet()) {
            if (!filter.accept(null, entry.getValue().getFullName())) continue;
            filteredUids.put(entry.getKey(), entry.getValue());
        }
        return filteredUids;
    }

    public SortedMap<MessageUid, MaildirMessageName> getUidMap(FilenameFilter filter, int limit) throws MailboxException {
        MessageUid to = null;
        SortedMap<MessageUid, MaildirMessageName> allUids = this.getUidMap(MessageUid.MIN_VALUE, to);
        TreeMap<MessageUid, MaildirMessageName> filteredUids = new TreeMap<MessageUid, MaildirMessageName>();
        int theLimit = limit;
        if (limit < 1) {
            theLimit = allUids.size();
        }
        int counter = 0;
        for (Map.Entry<MessageUid, MaildirMessageName> entry : allUids.entrySet()) {
            if (counter >= theLimit) break;
            if (!filter.accept(null, entry.getValue().getFullName())) continue;
            filteredUids.put(entry.getKey(), entry.getValue());
            ++counter;
        }
        return filteredUids;
    }

    public SortedMap<MessageUid, MaildirMessageName> getRecentMessages() throws MailboxException {
        String[] recentFiles = this.getNewFolder().list();
        LinkedList lines = new LinkedList();
        int theLimit = recentFiles.length;
        return (SortedMap)this.locker.executeWithLock(this.path, () -> {
            TreeMap<MessageUid, MaildirMessageName> recentMessages = new TreeMap<MessageUid, MaildirMessageName>();
            File uidList = this.uidFile;
            try {
                if (!uidList.isFile()) {
                    String[] allFiles;
                    if (!uidList.createNewFile()) {
                        throw new IOException("Could not create file " + uidList);
                    }
                    Object[] curFiles = this.curFolder.list();
                    Object[] newFiles = this.newFolder.list();
                    this.messageCount = curFiles.length + newFiles.length;
                    for (String file : allFiles = (String[])ArrayUtils.addAll((Object[])curFiles, (Object[])newFiles)) {
                        lines.add(String.valueOf(this.getNextUid().asLong()) + " " + file);
                    }
                    try (PrintWriter pw = new PrintWriter(uidList);){
                        pw.println(this.createUidListHeader());
                        for (String line : lines) {
                            pw.println(line);
                        }
                    }
                }
                try (FileReader fileReader = new FileReader(uidList);
                     BufferedReader reader = new BufferedReader(fileReader);){
                    String line;
                    reader.readLine();
                    while ((line = reader.readLine()) != null) {
                        lines.add(line);
                    }
                }
                int counter = 0;
                block22: while (counter < theLimit) {
                    String line;
                    try {
                        line = (String)lines.removeLast();
                    }
                    catch (NoSuchElementException e) {
                        break;
                    }
                    if (line.equals("")) continue;
                    int gap = line.indexOf(" ");
                    if (gap == -1) {
                        LOGGER.info("Corrupted entry in uid-file {} line {}", (Object)uidList, (Object)lines.size());
                        continue;
                    }
                    MessageUid uid = MessageUid.of((long)Long.parseLong(line.substring(0, gap)));
                    String name = line.substring(gap + 1);
                    for (String recentFile : recentFiles) {
                        if (!recentFile.equals(name)) continue;
                        recentMessages.put(uid, this.newMaildirMessageName(this, recentFile));
                        ++counter;
                        continue block22;
                    }
                }
            }
            catch (IOException e) {
                throw new MailboxException("Unable to read recent messages", (Throwable)e);
            }
            return recentMessages;
        }, MailboxPathLocker.LockType.Write);
    }

    private Map<MessageUid, MaildirMessageName> createUidFile() throws MailboxException {
        TreeMap<MessageUid, MaildirMessageName> uidMap = new TreeMap<MessageUid, MaildirMessageName>();
        File uidList = this.uidFile;
        try {
            String[] allFiles;
            if (!uidList.createNewFile()) {
                throw new IOException("Could not create file " + uidList);
            }
            this.lastUid = Optional.empty();
            Object[] curFiles = this.curFolder.list();
            Object[] newFiles = this.newFolder.list();
            this.messageCount = curFiles.length + newFiles.length;
            for (String file : allFiles = (String[])ArrayUtils.addAll((Object[])curFiles, (Object[])newFiles)) {
                uidMap.put(this.getNextUid(), this.newMaildirMessageName(this, file));
            }
            try (PrintWriter pw = new PrintWriter(uidList);){
                pw.println(this.createUidListHeader());
                for (Map.Entry entry : uidMap.entrySet()) {
                    pw.println(String.valueOf(((MessageUid)entry.getKey()).asLong()) + " " + ((MaildirMessageName)entry.getValue()).getFullName());
                }
            }
        }
        catch (IOException e) {
            throw new MailboxException("Unable to create uid file", (Throwable)e);
        }
        return uidMap;
    }

    private Map<MessageUid, MaildirMessageName> updateUidFile() throws MailboxException {
        TreeMap<MessageUid, MaildirMessageName> uidMap = new TreeMap<MessageUid, MaildirMessageName>();
        File uidList = this.uidFile;
        Object[] curFiles = this.curFolder.list();
        Object[] newFiles = this.newFolder.list();
        this.messageCount = curFiles.length + newFiles.length;
        HashMap<String, MessageUid> reverseUidMap = new HashMap<String, MessageUid>(this.messageCount);
        try (FileReader fileReader = new FileReader(uidList);
             BufferedReader reader = new BufferedReader(fileReader);){
            MessageUid allFiles;
            String line = reader.readLine();
            if (line != null) {
                this.readUidListHeader(line);
            }
            int lineNumber = 1;
            while ((line = reader.readLine()) != null) {
                ++lineNumber;
                if (line.equals("")) continue;
                int gap = line.indexOf(" ");
                if (gap == -1) {
                    throw new MailboxException("Corrupted entry in uid-file " + uidList + " line " + lineNumber);
                }
                MessageUid uid = MessageUid.of((long)Long.parseLong(line.substring(0, gap)));
                String name = line.substring(gap + 1);
                reverseUidMap.put(MaildirFolder.stripMetaFromName(name), uid);
            }
            for (String file : allFiles = (MessageUid)ArrayUtils.addAll((Object[])curFiles, (Object[])newFiles)) {
                MaildirMessageName messageName = this.newMaildirMessageName(this, file);
                MessageUid uid = (MessageUid)reverseUidMap.get(messageName.getBaseName());
                if (uid == null) {
                    uid = this.getNextUid();
                }
                uidMap.put(uid, messageName);
            }
            try (PrintWriter pw = new PrintWriter(uidList);){
                pw.println(this.createUidListHeader());
                for (Map.Entry entry : uidMap.entrySet()) {
                    pw.println(String.valueOf(((MessageUid)entry.getKey()).asLong()) + " " + ((MaildirMessageName)entry.getValue()).getFullName());
                }
            }
        }
        catch (IOException e) {
            throw new MailboxException("Unable to update uid file", (Throwable)e);
        }
        return uidMap;
    }

    private Map<MessageUid, MaildirMessageName> readUidFile(MessageUid from, MessageUid to) throws MailboxException {
        HashMap<MessageUid, MaildirMessageName> uidMap = new HashMap<MessageUid, MaildirMessageName>();
        File uidList = this.uidFile;
        try (FileReader fileReader = new FileReader(uidList);
             BufferedReader reader = new BufferedReader(fileReader);){
            String line = reader.readLine();
            if (line != null) {
                this.readUidListHeader(line);
            }
            int lineNumber = 1;
            while ((line = reader.readLine()) != null) {
                ++lineNumber;
                if (line.equals("")) continue;
                int gap = line.indexOf(" ");
                if (gap == -1) {
                    LOGGER.info("Corrupted entry in uid-file {} line {}", (Object)uidList, (Object)lineNumber);
                    continue;
                }
                MessageUid uid = MessageUid.of((long)Long.parseLong(line.substring(0, gap)));
                if (uid.compareTo(from) < 0) continue;
                if (to != null && uid.compareTo(to) > 0) {
                    break;
                }
                String name = line.substring(gap + 1);
                uidMap.put(uid, this.newMaildirMessageName(this, name));
            }
        }
        catch (IOException e) {
            throw new MailboxException("Unable to read uid file", (Throwable)e);
        }
        this.messageCount = uidMap.size();
        return uidMap;
    }

    private SortedMap<MessageUid, MaildirMessageName> truncateMap(Map<MessageUid, MaildirMessageName> map, MessageUid from, MessageUid to) {
        TreeMap<MessageUid, MaildirMessageName> sortedMap = map instanceof TreeMap ? (TreeMap<MessageUid, MaildirMessageName>)map : new TreeMap<MessageUid, MaildirMessageName>(map);
        if (to != null) {
            return sortedMap.subMap(from, to.next());
        }
        return sortedMap.tailMap(from);
    }

    private void readUidListHeader(String line) throws IOException {
        if (line == null) {
            throw new IOException("Header entry in uid-file is null");
        }
        int gap1 = line.indexOf(" ");
        if (gap1 == -1) {
            throw new IOException("Corrupted header entry in uid-file");
        }
        int version = Integer.parseInt(line.substring(0, gap1));
        if (version != 1) {
            throw new IOException("Cannot read uidlists with versions other than 1.");
        }
        int gap2 = line.indexOf(" ", gap1 + 1);
        this.lastUid = Optional.of(MessageUid.of((long)Long.parseLong(line.substring(gap1 + 1, gap2))));
        this.messageCount = Integer.parseInt(line.substring(gap2 + 1));
    }

    private String createUidListHeader() {
        Long last = this.lastUid.map(MessageUid::asLong).orElse(0L);
        return "1 " + String.valueOf(last) + " " + String.valueOf(this.messageCount);
    }

    public static String stripMetaFromName(String fileName) {
        int end = fileName.indexOf(",S=");
        if (end == -1) {
            end = fileName.indexOf(":2,");
        }
        if (end == -1) {
            return fileName;
        }
        return fileName.substring(0, end);
    }

    public MessageUid appendMessage(String name) throws MailboxException {
        return (MessageUid)this.locker.executeWithLock(this.path, () -> {
            MessageUid uid;
            block30: {
                File uidList = this.uidFile;
                uid = null;
                try {
                    if (uidList.isFile()) {
                        try (FileReader fileReader = new FileReader(uidList);
                             BufferedReader reader = new BufferedReader(fileReader);){
                            String line = reader.readLine();
                            if (line != null) {
                                this.readUidListHeader(line);
                            }
                            ArrayList<String> lines = new ArrayList<String>();
                            while ((line = reader.readLine()) != null) {
                                lines.add(line);
                            }
                            uid = this.getNextUid();
                            lines.add(String.valueOf(uid.asLong()) + " " + name);
                            ++this.messageCount;
                            try (PrintWriter pw = new PrintWriter(uidList);){
                                pw.println(this.createUidListHeader());
                                for (String entry : lines) {
                                    pw.println(entry);
                                }
                                break block30;
                            }
                        }
                    }
                    if (!uidList.createNewFile()) {
                        throw new IOException("Could not create file " + uidList);
                    }
                    Object[] curFiles = this.curFolder.list();
                    Object[] newFiles = this.newFolder.list();
                    this.messageCount = curFiles.length + newFiles.length;
                    ArrayList<String> lines = new ArrayList<String>();
                    String[] allFiles = (String[])ArrayUtils.addAll((Object[])curFiles, (Object[])newFiles);
                    for (String file : allFiles) {
                        MessageUid theUid = this.getNextUid();
                        lines.add(String.valueOf(theUid.asLong()) + " " + file);
                        if (!file.equals(name)) continue;
                        uid = theUid;
                    }
                    try (PrintWriter pw = new PrintWriter(uidList);){
                        pw.println(this.createUidListHeader());
                        for (String line : lines) {
                            pw.println(line);
                        }
                    }
                }
                catch (IOException e) {
                    throw new MailboxException("Unable to append msg", (Throwable)e);
                }
            }
            if (uid == null) {
                throw new MailboxException("Unable to append msg");
            }
            return uid;
        }, MailboxPathLocker.LockType.Write);
    }

    public void update(MessageUid uid, String messageName) throws MailboxException {
        this.locker.executeWithLock(this.path, () -> {
            File uidList = this.uidFile;
            try (FileReader fileReader = new FileReader(uidList);
                 BufferedReader reader = new BufferedReader(fileReader);){
                String line = reader.readLine();
                this.readUidListHeader(line);
                ArrayList<String> lines = new ArrayList<String>();
                while ((line = reader.readLine()) != null) {
                    if (uid.equals((Object)MessageUid.of((long)Long.parseLong(line.substring(0, line.indexOf(" ")))))) {
                        line = String.valueOf(uid.asLong()) + " " + messageName;
                    }
                    lines.add(line);
                }
                try (PrintWriter writer = new PrintWriter(uidList);){
                    writer.println(this.createUidListHeader());
                    for (String entry : lines) {
                        writer.println(entry);
                    }
                }
            }
            catch (IOException e) {
                throw new MailboxException("Unable to update msg with uid " + uid, (Throwable)e);
            }
            return null;
        }, MailboxPathLocker.LockType.Write);
    }

    public MaildirMessageName delete(MessageUid uid) throws MailboxException {
        return (MaildirMessageName)this.locker.executeWithLock(this.path, () -> {
            File uidList = this.uidFile;
            MaildirMessageName deletedMessage = null;
            try (FileReader fileReader = new FileReader(uidList);){
                MaildirMessageName maildirMessageName;
                try (BufferedReader reader = new BufferedReader(fileReader);){
                    String line;
                    this.readUidListHeader(reader.readLine());
                    ArrayList<String> lines = new ArrayList<String>();
                    int lineNumber = 0;
                    while ((line = reader.readLine()) != null) {
                        ++lineNumber;
                        int gap = line.indexOf(" ");
                        if (gap == -1) {
                            LOGGER.info("Corrupted entry in uid-file {} line {}", (Object)uidList, (Object)lineNumber);
                            continue;
                        }
                        if (uid.equals((Object)MessageUid.of((long)Long.parseLong(line.substring(0, line.indexOf(" ")))))) {
                            deletedMessage = this.newMaildirMessageName(this, line.substring(gap + 1));
                            --this.messageCount;
                            continue;
                        }
                        lines.add(line);
                    }
                    if (deletedMessage != null) {
                        FileUtils.forceDelete((File)deletedMessage.getFile());
                        try (PrintWriter writer = new PrintWriter(uidList);){
                            writer.println(this.createUidListHeader());
                            for (String entry : lines) {
                                writer.println(entry);
                            }
                        }
                    }
                    maildirMessageName = deletedMessage;
                }
                return maildirMessageName;
            }
            catch (IOException e) {
                throw new MailboxException("Unable to delete msg with uid " + uid, (Throwable)e);
            }
        }, MailboxPathLocker.LockType.Write);
    }

    public String toString() {
        return this.getRootFile().getAbsolutePath();
    }

    public MailboxACL getACL() throws MailboxException {
        if (this.acl == null) {
            this.acl = this.readACL();
        }
        return this.acl;
    }

    private MailboxACL readACL() throws MailboxException {
        return (MailboxACL)this.locker.executeWithLock(this.path, () -> {
            File f = this.aclFile;
            Properties props = new Properties();
            if (f.exists()) {
                try (FileInputStream in = new FileInputStream(f);){
                    props.load(in);
                }
                catch (IOException e) {
                    throw new MailboxException("Unable to read last ACL from " + f.getAbsolutePath(), (Throwable)e);
                }
            }
            return new MailboxACL(props);
        }, MailboxPathLocker.LockType.Write);
    }

    public void setACL(MailboxACL acl) throws MailboxException {
        MailboxACL old = this.acl;
        if (!Objects.equals(old, acl)) {
            this.saveACL(acl);
            this.acl = acl;
        }
    }

    private void saveACL(final MailboxACL acl) throws MailboxException {
        this.locker.executeWithLock(this.path, (MailboxPathLocker.LockAwareExecution)new MailboxPathLocker.LockAwareExecution<Void>(){

            public Void execute() throws MailboxException {
                File f = MaildirFolder.this.aclFile;
                Properties props = new Properties();
                Map entries = acl.getEntries();
                if (entries != null) {
                    for (Map.Entry en : entries.entrySet()) {
                        props.put(((MailboxACL.EntryKey)en.getKey()).serialize(), ((MailboxACL.Rfc4314Rights)en.getValue()).serialize());
                    }
                }
                if (f.exists()) {
                    try (FileOutputStream out = new FileOutputStream(f);){
                        props.store(out, "written by " + this.getClass().getName());
                    }
                    catch (IOException e) {
                        throw new MailboxException("Unable to read last ACL from " + f.getAbsolutePath(), (Throwable)e);
                    }
                }
                return null;
            }
        }, MailboxPathLocker.LockType.Write);
    }
}

