/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver.fastfail;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.james.smtpserver.TLDLookup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URIScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(URIScanner.class);
    private static final String reserved = ";/?:@&=+$,[]\\#|";
    private static final String reservedNoColon = ";/?@&=+$,[]\\#|";
    private static final String mark = "-_.!~*'()";
    private static final String unreserved = "A-Za-z0-9" + URIScanner.escape("-_.!~*'()") + "\\x00-\\x08\\x0b\\x0c\\x0e-\\x1f";
    private static final String uricSet = URIScanner.escape(";/?:@&=+$,[]\\#|") + unreserved + "%";
    private static final String uricNoColon = URIScanner.escape(";/?@&=+$,[]\\#|") + unreserved + "%";
    private static final String schemeRE = "(?-xism:(?:https?|ftp|mailto|javascript|file))";
    private static final String schemelessRE = "(?-xism:(?<![.=])(?:(?i)www\\d*\\.|(?i)ftp\\.))";
    private static final String uriRE = "(?-xism:\\b(?:(?-xism:(?:https?|ftp|mailto|javascript|file)):[" + uricNoColon + "]|" + "(?-xism:(?<![.=])(?:(?i)www\\d*\\.|(?i)ftp\\.))" + ")[" + uricSet + "#]*)";
    private static final Pattern uriPattern = Pattern.compile(uriRE);
    private static final Pattern schemePattern = Pattern.compile("^(?-xism:(?:https?|ftp|mailto|javascript|file)):");
    private static final Pattern uriCleanup = Pattern.compile("^<(.*)>$");
    private static final Pattern uriCleanup2 = Pattern.compile("[\\]\\)>#]$");
    private static final Pattern uriCleanup3 = Pattern.compile("^(?i)mailto:([^\\/]{2})(.*)$");
    private static final String esc = "\\\\";
    private static final String period = "\\.";
    private static final String space = "\\040";
    private static final String open_br = "\\[";
    private static final String close_br = "\\]";
    private static final String nonASCII = "\\x80-\\xff";
    private static final String ctrl = "\\000-\\037";
    private static final String cr_list = "\\n\\r";
    private static final String qtext = "[^\\\\\\x80-\\xff\\n\\r\"]";
    private static final String dtext = "[^\\\\\\x80-\\xff\\n\\r\\[\\]]";
    private static final String quoted_pair = "\\\\[^\\x80-\\xff]";
    private static final String atom_char = "[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]";
    private static final String atom = "(?>[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+)";
    private static final String quoted_str = "\"[^\\\\\\x80-\\xff\\n\\r\"]*(?:\\\\[^\\x80-\\xff][^\\\\\\x80-\\xff\\n\\r\"]*)*\"";
    private static final String word = "(?:(?>[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+)|\"[^\\\\\\x80-\\xff\\n\\r\"]*(?:\\\\[^\\x80-\\xff][^\\\\\\x80-\\xff\\n\\r\"]*)*\")";
    private static final String local_part = "(?:(?>[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+)|\"[^\\\\\\x80-\\xff\\n\\r\"]*(?:\\\\[^\\x80-\\xff][^\\\\\\x80-\\xff\\n\\r\"]*)*\")(?:\\.(?:(?>[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+)|\"[^\\\\\\x80-\\xff\\n\\r\"]*(?:\\\\[^\\x80-\\xff][^\\\\\\x80-\\xff\\n\\r\"]*)*\"))*";
    private static final String label = "[A-Za-z\\d](?:[A-Za-z\\d-]*[A-Za-z\\d])?";
    private static final String domain_ref = "[A-Za-z\\d](?:[A-Za-z\\d-]*[A-Za-z\\d])?(?:\\.[A-Za-z\\d](?:[A-Za-z\\d-]*[A-Za-z\\d])?)*";
    private static final String domain_lit = "\\[(?:[^\\\\\\x80-\\xff\\n\\r\\[\\]]|\\\\[^\\x80-\\xff])*\\]";
    private static final String domain = "(?:[A-Za-z\\d](?:[A-Za-z\\d-]*[A-Za-z\\d])?(?:\\.[A-Za-z\\d](?:[A-Za-z\\d-]*[A-Za-z\\d])?)*|\\[(?:[^\\\\\\x80-\\xff\\n\\r\\[\\]]|\\\\[^\\x80-\\xff])*\\])";
    private static final String Addr_spec_re = "(?-xism:(?:(?>[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+)|\"[^\\\\\\x80-\\xff\\n\\r\"]*(?:\\\\[^\\x80-\\xff][^\\\\\\x80-\\xff\\n\\r\"]*)*\")(?:\\.(?:(?>[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+)|\"[^\\\\\\x80-\\xff\\n\\r\"]*(?:\\\\[^\\x80-\\xff][^\\\\\\x80-\\xff\\n\\r\"]*)*\"))*\\s*\\@\\s*(?:[A-Za-z\\d](?:[A-Za-z\\d-]*[A-Za-z\\d])?(?:\\.[A-Za-z\\d](?:[A-Za-z\\d-]*[A-Za-z\\d])?)*|\\[(?:[^\\\\\\x80-\\xff\\n\\r\\[\\]]|\\\\[^\\x80-\\xff])*\\]))";
    private static final Pattern emailAddrPattern = Pattern.compile("(?-xism:(?:(?>[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+)|\"[^\\\\\\x80-\\xff\\n\\r\"]*(?:\\\\[^\\x80-\\xff][^\\\\\\x80-\\xff\\n\\r\"]*)*\")(?:\\.(?:(?>[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+)|\"[^\\\\\\x80-\\xff\\n\\r\"]*(?:\\\\[^\\x80-\\xff][^\\\\\\x80-\\xff\\n\\r\"]*)*\"))*\\s*\\@\\s*(?:[A-Za-z\\d](?:[A-Za-z\\d-]*[A-Za-z\\d])?(?:\\.[A-Za-z\\d](?:[A-Za-z\\d-]*[A-Za-z\\d])?)*|\\[(?:[^\\\\\\x80-\\xff\\n\\r\\[\\]]|\\\\[^\\x80-\\xff])*\\]))");
    private static final String octet = "(?:[1-2][0-9][0-9])|(?:[1-9][0-9])|(?:[0-9])";
    private static final String tld = "[A-Za-z0-9\\-]*";
    private static final String tld2 = "[A-Za-z0-9\\-]*\\.[A-Za-z0-9\\-]*";
    private static final String tld3 = "[A-Za-z0-9\\-]*\\.[A-Za-z0-9\\-]*\\.[A-Za-z0-9\\-]*";
    private static final String tldCap = "([A-Za-z0-9\\-]*\\.([A-Za-z0-9\\-]*))$";
    private static final String tld2Cap = "([A-Za-z0-9\\-]*\\.([A-Za-z0-9\\-]*\\.[A-Za-z0-9\\-]*))$";
    private static final String tld3Cap = "([A-Za-z0-9\\-]*\\.([A-Za-z0-9\\-]*\\.[A-Za-z0-9\\-]*\\.[A-Za-z0-9\\-]*))$";
    private static final String ipCap = "(((?:[1-2][0-9][0-9])|(?:[1-9][0-9])|(?:[0-9]))\\.((?:[1-2][0-9][0-9])|(?:[1-9][0-9])|(?:[0-9]))\\.((?:[1-2][0-9][0-9])|(?:[1-9][0-9])|(?:[0-9]))\\.((?:[1-2][0-9][0-9])|(?:[1-9][0-9])|(?:[0-9])))$";
    private static final Pattern ipCapPattern = Pattern.compile("(((?:[1-2][0-9][0-9])|(?:[1-9][0-9])|(?:[0-9]))\\.((?:[1-2][0-9][0-9])|(?:[1-9][0-9])|(?:[0-9]))\\.((?:[1-2][0-9][0-9])|(?:[1-9][0-9])|(?:[0-9]))\\.((?:[1-2][0-9][0-9])|(?:[1-9][0-9])|(?:[0-9])))$");
    private static final Pattern tldCapPattern = Pattern.compile("([A-Za-z0-9\\-]*\\.([A-Za-z0-9\\-]*))$");
    private static final Pattern tld2CapPattern = Pattern.compile("([A-Za-z0-9\\-]*\\.([A-Za-z0-9\\-]*\\.[A-Za-z0-9\\-]*))$");
    private static final Pattern tld3CapPattern = Pattern.compile("([A-Za-z0-9\\-]*\\.([A-Za-z0-9\\-]*\\.[A-Za-z0-9\\-]*\\.[A-Za-z0-9\\-]*))$");

    public static HashSet<String> scanContentForDomains(HashSet<String> domains, CharSequence content) {
        HashSet<String> hosts = URIScanner.scanContentForHosts(content);
        return hosts.stream().map(URIScanner::domainFromHost).filter(Objects::nonNull).filter(domain -> !domains.contains(domain)).collect(Collectors.toCollection(HashSet::new));
    }

    protected static HashSet<String> scanContentForHosts(CharSequence content) {
        String found;
        HashSet<String> set = new HashSet<String>();
        Matcher mat = uriPattern.matcher(content);
        while (mat.find()) {
            String host;
            found = mat.group();
            Matcher cleanMat = uriCleanup.matcher(found);
            if (cleanMat.find()) {
                found = cleanMat.group(1);
            }
            if ((cleanMat = uriCleanup2.matcher(found)).find()) {
                found = cleanMat.replaceAll("");
            }
            if ((cleanMat = uriCleanup3.matcher(found)).find()) {
                found = "mailto://" + cleanMat.group(1) + cleanMat.group(2);
            }
            if (!(cleanMat = schemePattern.matcher(found)).find()) {
                if (found.matches("^(?i)www\\d*\\..*")) {
                    found = "http://" + found;
                } else if (found.matches("^(?i)ftp\\..*")) {
                    found = "ftp://" + found;
                }
            }
            if (null == (host = URIScanner.hostFromUriStr(found))) continue;
            host = host.toLowerCase(Locale.US);
            set.add(host);
        }
        mat = emailAddrPattern.matcher(content);
        while (mat.find()) {
            found = mat.group();
            LOGGER.debug("******** mailfound=\"{}\"", (Object)found);
            found = "mailto://" + found;
            LOGGER.debug("*******6 mailfoundfound=\"{}\" after cleanup 6", (Object)found);
            String host = URIScanner.hostFromUriStr(found);
            if (null == host) continue;
            host = host.toLowerCase(Locale.US);
            set.add(host);
        }
        return set;
    }

    protected static String hostFromUriStr(String uriStr) {
        LOGGER.debug("hostFromUriStr(\"{}\")", (Object)uriStr);
        String host = null;
        try {
            URI uri = new URI(uriStr);
            host = uri.getHost();
        }
        catch (URISyntaxException e) {
            LOGGER.error("Caught exception", (Throwable)e);
        }
        return host;
    }

    protected static String domainFromHost(String host) {
        String tld;
        LOGGER.debug("domainFromHost(\"{}\")", (Object)host);
        String domain = null;
        Matcher mat = ipCapPattern.matcher(host);
        if (mat.find()) {
            domain = mat.group(5) + "." + mat.group(4) + "." + mat.group(3) + "." + mat.group(2);
            LOGGER.debug("domain=\"{}\"", (Object)domain);
            return domain;
        }
        mat = tld3CapPattern.matcher(host);
        if (mat.find() && TLDLookup.isThreePartTLD(tld = mat.group(2))) {
            domain = mat.group(1);
            LOGGER.debug("domain=\"{}, tld=\"{}\"", (Object)domain, (Object)tld);
            return domain;
        }
        mat = tld2CapPattern.matcher(host);
        if (mat.find() && TLDLookup.isTwoPartTLD(tld = mat.group(2))) {
            domain = mat.group(1);
            LOGGER.debug("domain=\"{}, tld=\"{}\"", (Object)domain, (Object)tld);
            return domain;
        }
        mat = tldCapPattern.matcher(host);
        if (mat.find()) {
            tld = mat.group(2);
            domain = mat.group(1);
            LOGGER.debug("domain=\"{}, tld=\"{}\"", (Object)domain, (Object)tld);
            return domain;
        }
        return domain;
    }

    private static String escape(String str) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (Character.isDigit(ch) || Character.isUpperCase(ch) || Character.isLowerCase(ch) || ch == '_') {
                buffer.append(ch);
                continue;
            }
            buffer.append("\\");
            buffer.append(ch);
        }
        return buffer.toString();
    }
}

