/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.core.healthcheck;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.core.healthcheck.ComponentName;
import org.apache.james.core.healthcheck.ResultStatus;

public class Result {
    private final ComponentName componentName;
    private final ResultStatus status;
    private final Optional<String> cause;

    public static Result healthy(ComponentName componentName) {
        return new Result(componentName, ResultStatus.HEALTHY, Optional.empty());
    }

    public static Result unhealthy(ComponentName componentName, String cause) {
        return new Result(componentName, ResultStatus.UNHEALTHY, Optional.of(cause));
    }

    public static Result degraded(ComponentName componentName, String cause) {
        return new Result(componentName, ResultStatus.DEGRADED, Optional.of(cause));
    }

    private Result(ComponentName componentName, ResultStatus status, Optional<String> cause) {
        this.componentName = componentName;
        this.status = status;
        this.cause = cause;
    }

    public ComponentName getComponentName() {
        return this.componentName;
    }

    public ResultStatus getStatus() {
        return this.status;
    }

    public boolean isHealthy() {
        return this.status == ResultStatus.HEALTHY;
    }

    public boolean isDegraded() {
        return this.status == ResultStatus.DEGRADED;
    }

    public boolean isUnHealthy() {
        return this.status == ResultStatus.UNHEALTHY;
    }

    public Optional<String> getCause() {
        return this.cause;
    }

    public final boolean equals(Object o) {
        if (o instanceof Result) {
            Result result = (Result)o;
            return Objects.equals(this.componentName, result.componentName) && Objects.equals((Object)this.status, (Object)result.status) && Objects.equals(this.cause, result.cause);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(new Object[]{this.componentName, this.status, this.cause});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("componentName", (Object)this.componentName).add("status", (Object)this.status).add("cause", this.cause).toString();
    }
}

