/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Disposable;
import reactor.core.Exceptions;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.FluxProcessor;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.Operators;
import reactor.util.annotation.Nullable;
import reactor.util.concurrent.Queues;
import reactor.util.context.Context;

public final class UnicastProcessor<T>
extends FluxProcessor<T, T>
implements Fuseable.QueueSubscription<T>,
Fuseable,
InnerOperator<T, T> {
    final Queue<T> queue;
    final Consumer<? super T> onOverflow;
    volatile Disposable onTerminate;
    static final AtomicReferenceFieldUpdater<UnicastProcessor, Disposable> ON_TERMINATE = AtomicReferenceFieldUpdater.newUpdater(UnicastProcessor.class, Disposable.class, "onTerminate");
    volatile boolean done;
    Throwable error;
    volatile CoreSubscriber<? super T> actual;
    volatile boolean cancelled;
    volatile int once;
    static final AtomicIntegerFieldUpdater<UnicastProcessor> ONCE = AtomicIntegerFieldUpdater.newUpdater(UnicastProcessor.class, "once");
    volatile int wip;
    static final AtomicIntegerFieldUpdater<UnicastProcessor> WIP = AtomicIntegerFieldUpdater.newUpdater(UnicastProcessor.class, "wip");
    volatile long requested;
    static final AtomicLongFieldUpdater<UnicastProcessor> REQUESTED = AtomicLongFieldUpdater.newUpdater(UnicastProcessor.class, "requested");
    boolean outputFused;

    public static <E> UnicastProcessor<E> create() {
        return new UnicastProcessor(Queues.unbounded().get());
    }

    public static <E> UnicastProcessor<E> create(Queue<E> queue) {
        return new UnicastProcessor<E>(queue);
    }

    public static <E> UnicastProcessor<E> create(Queue<E> queue, Disposable endcallback) {
        return new UnicastProcessor<E>(queue, endcallback);
    }

    public static <E> UnicastProcessor<E> create(Queue<E> queue, Consumer<? super E> onOverflow, Disposable endcallback) {
        return new UnicastProcessor<E>(queue, onOverflow, endcallback);
    }

    public UnicastProcessor(Queue<T> queue) {
        this.queue = Objects.requireNonNull(queue, "queue");
        this.onTerminate = null;
        this.onOverflow = null;
    }

    public UnicastProcessor(Queue<T> queue, Disposable onTerminate) {
        this.queue = Objects.requireNonNull(queue, "queue");
        this.onTerminate = Objects.requireNonNull(onTerminate, "onTerminate");
        this.onOverflow = null;
    }

    public UnicastProcessor(Queue<T> queue, Consumer<? super T> onOverflow, Disposable onTerminate) {
        this.queue = Objects.requireNonNull(queue, "queue");
        this.onOverflow = Objects.requireNonNull(onOverflow, "onOverflow");
        this.onTerminate = Objects.requireNonNull(onTerminate, "onTerminate");
    }

    @Override
    public int getBufferSize() {
        return Queues.capacity(this.queue);
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (Scannable.Attr.BUFFERED == key) {
            return this.queue.size();
        }
        return super.scanUnsafe(key);
    }

    void doTerminate() {
        Disposable r = this.onTerminate;
        if (r != null && ON_TERMINATE.compareAndSet(this, r, null)) {
            r.dispose();
        }
    }

    void drainRegular(Subscriber<? super T> a) {
        int missed = 1;
        Queue<T> q = this.queue;
        do {
            long e;
            long r = this.requested;
            for (e = 0L; r != e; ++e) {
                boolean empty;
                boolean d = this.done;
                T t = q.poll();
                boolean bl = empty = t == null;
                if (this.checkTerminated(d, empty, a, q)) {
                    return;
                }
                if (empty) break;
                a.onNext(t);
            }
            if (r == e && this.checkTerminated(this.done, q.isEmpty(), a, q)) {
                return;
            }
            if (e == 0L || r == Long.MAX_VALUE) continue;
            REQUESTED.addAndGet(this, -e);
        } while ((missed = WIP.addAndGet(this, -missed)) != 0);
    }

    void drainFused(Subscriber<? super T> a) {
        int missed = 1;
        Queue<T> q = this.queue;
        do {
            if (this.cancelled) {
                q.clear();
                this.actual = null;
                return;
            }
            boolean d = this.done;
            a.onNext(null);
            if (!d) continue;
            this.actual = null;
            Throwable ex = this.error;
            if (ex != null) {
                a.onError(ex);
            } else {
                a.onComplete();
            }
            return;
        } while ((missed = WIP.addAndGet(this, -missed)) != 0);
    }

    void drain() {
        if (WIP.getAndIncrement(this) != 0) {
            return;
        }
        int missed = 1;
        do {
            CoreSubscriber<? super T> a;
            if ((a = this.actual) == null) continue;
            if (this.outputFused) {
                this.drainFused(a);
            } else {
                this.drainRegular(a);
            }
            return;
        } while ((missed = WIP.addAndGet(this, -missed)) != 0);
    }

    boolean checkTerminated(boolean d, boolean empty, Subscriber<? super T> a, Queue<T> q) {
        if (this.cancelled) {
            q.clear();
            this.actual = null;
            return true;
        }
        if (d && empty) {
            Throwable e = this.error;
            this.actual = null;
            if (e != null) {
                a.onError(e);
            } else {
                a.onComplete();
            }
            return true;
        }
        return false;
    }

    @Override
    public void onSubscribe(Subscription s) {
        if (this.done || this.cancelled) {
            s.cancel();
        } else {
            s.request(Long.MAX_VALUE);
        }
    }

    @Override
    public int getPrefetch() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Context currentContext() {
        CoreSubscriber<T> actual = this.actual;
        return actual != null ? actual.currentContext() : Context.empty();
    }

    public void onNext(T t) {
        if (this.done || this.cancelled) {
            Operators.onNextDropped(t, this.currentContext());
            return;
        }
        if (!this.queue.offer(t)) {
            Throwable ex = Operators.onOperatorError(null, Exceptions.failWithOverflow(), t, this.currentContext());
            if (this.onOverflow != null) {
                try {
                    this.onOverflow.accept(t);
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal(e);
                    ex.initCause(e);
                }
            }
            this.onError(Operators.onOperatorError(null, ex, t, this.currentContext()));
            return;
        }
        this.drain();
    }

    public void onError(Throwable t) {
        if (this.done || this.cancelled) {
            Operators.onErrorDropped(t, this.currentContext());
            return;
        }
        this.error = t;
        this.done = true;
        this.doTerminate();
        this.drain();
    }

    public void onComplete() {
        if (this.done || this.cancelled) {
            return;
        }
        this.done = true;
        this.doTerminate();
        this.drain();
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        Objects.requireNonNull(actual, "subscribe");
        if (this.once == 0 && ONCE.compareAndSet(this, 0, 1)) {
            actual.onSubscribe(this);
            this.actual = actual;
            if (this.cancelled) {
                this.actual = null;
            } else {
                this.drain();
            }
        } else {
            Operators.error(actual, new IllegalStateException("UnicastProcessor allows only a single Subscriber"));
        }
    }

    public void request(long n) {
        if (Operators.validate(n)) {
            Operators.addCap(REQUESTED, this, n);
            this.drain();
        }
    }

    public void cancel() {
        if (this.cancelled) {
            return;
        }
        this.cancelled = true;
        this.doTerminate();
        if (!this.outputFused && WIP.getAndIncrement(this) == 0) {
            this.queue.clear();
            this.actual = null;
        }
    }

    @Override
    @Nullable
    public T poll() {
        return this.queue.poll();
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public void clear() {
        this.queue.clear();
    }

    @Override
    public int requestFusion(int requestedMode) {
        if ((requestedMode & 2) != 0) {
            this.outputFused = true;
            return 2;
        }
        return 0;
    }

    @Override
    public boolean isDisposed() {
        return this.cancelled || this.done;
    }

    @Override
    public boolean isTerminated() {
        return this.done;
    }

    @Override
    @Nullable
    public Throwable getError() {
        return this.error;
    }

    @Override
    public CoreSubscriber<? super T> actual() {
        return this.actual;
    }

    @Override
    public long downstreamCount() {
        return this.hasDownstreams() ? 1L : 0L;
    }

    @Override
    public boolean hasDownstreams() {
        return this.actual != null;
    }
}

