/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.lib;

import com.github.fge.lambdas.Throwing;
import com.github.steveash.guavate.Guavate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.rrt.api.AliasReverseResolver;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.lib.CanSendFromImpl;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.rrt.lib.MappingSource;
import org.apache.james.util.OptionalUtils;
import org.apache.james.util.StreamUtils;

public class AliasReverseResolverImpl
implements AliasReverseResolver {
    private final RecipientRewriteTable recipientRewriteTable;

    @Inject
    public AliasReverseResolverImpl(RecipientRewriteTable recipientRewriteTable) {
        this.recipientRewriteTable = recipientRewriteTable;
    }

    public Stream<MailAddress> listAddresses(Username user) throws RecipientRewriteTable.ErrorMappingException, RecipientRewriteTableException {
        CanSendFromImpl.DomainFetcher domains = this.domainFetcher(user);
        return this.relatedAliases(user).flatMap(allowedUser -> domains.fetch((Username)allowedUser).stream().map(Optional::of).map(arg_0 -> ((Username)allowedUser).withOtherDomain(arg_0)).map(Throwing.function(Username::asMailAddress).sneakyThrow())).distinct();
    }

    private Stream<Username> relatedAliases(Username user) {
        return StreamUtils.iterate((Object)user, (Long)this.getMappingLimit(), (Function)Throwing.function(targetUser -> this.recipientRewriteTable.listSources(Mapping.alias((String)targetUser.asString())).map(MappingSource::asUsername).flatMap(OptionalUtils::toStream)).sneakyThrow());
    }

    private CanSendFromImpl.DomainFetcher domainFetcher(Username user) {
        HashMap fetchedDomains = new HashMap();
        List userDomains = (List)this.relatedDomains(user).collect(Guavate.toImmutableList());
        user.getDomainPart().ifPresent(domain -> fetchedDomains.put(domain, userDomains));
        Function<Domain, List> computeDomain = givenDomain -> (List)Stream.concat(userDomains.stream(), this.fetchDomains((Domain)givenDomain)).collect(Guavate.toImmutableList());
        return givenUsername -> givenUsername.getDomainPart().map(domain -> (List)fetchedDomains.computeIfAbsent(domain, computeDomain)).orElseGet(() -> Arrays.asList(new Domain[0]));
    }

    private Stream<Domain> relatedDomains(Username user) {
        return user.getDomainPart().map(this::fetchDomains).orElseGet(Stream::empty);
    }

    private Stream<Domain> fetchDomains(Domain domain) {
        return StreamUtils.iterate((Object)domain, (Long)this.getMappingLimit(), (Function)Throwing.function(targetDomain -> this.recipientRewriteTable.listSources(Mapping.domainAlias((Domain)targetDomain)).map(MappingSource::asDomain).flatMap(OptionalUtils::toStream)).sneakyThrow());
    }

    private long getMappingLimit() {
        return this.recipientRewriteTable.getConfiguration().getMappingLimit();
    }
}

