/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.LineHandler;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.SeparatingDataLineFilter;

public abstract class AbstractAddHeadersFilter
extends SeparatingDataLineFilter {
    private static final AtomicInteger COUNTER = new AtomicInteger(0);
    private final ProtocolSession.AttachmentKey<Boolean> headersPrefixAdded = ProtocolSession.AttachmentKey.of((String)("HEADERS_PREFIX_ADDED" + COUNTER.incrementAndGet()), Boolean.class);
    private final ProtocolSession.AttachmentKey<Boolean> headersSuffixAdded = ProtocolSession.AttachmentKey.of((String)("HEADERS_SUFFIX_ADDED" + COUNTER.incrementAndGet()), Boolean.class);

    protected abstract Location getLocation();

    @Override
    protected Response onSeparatorLine(SMTPSession session, ByteBuffer line, LineHandler<SMTPSession> next) {
        if (this.getLocation() == Location.Suffix && !session.getAttachment(this.headersSuffixAdded, ProtocolSession.State.Transaction).isPresent()) {
            session.setAttachment(this.headersSuffixAdded, Boolean.TRUE, ProtocolSession.State.Transaction);
            return this.addHeaders(session, line, next);
        }
        return super.onSeparatorLine(session, line, next);
    }

    @Override
    protected Response onHeadersLine(SMTPSession session, ByteBuffer line, LineHandler<SMTPSession> next) {
        if (this.getLocation() == Location.Prefix && !session.getAttachment(this.headersPrefixAdded, ProtocolSession.State.Transaction).isPresent()) {
            session.setAttachment(this.headersPrefixAdded, Boolean.TRUE, ProtocolSession.State.Transaction);
            return this.addHeaders(session, line, next);
        }
        return super.onHeadersLine(session, line, next);
    }

    private Response addHeaders(SMTPSession session, ByteBuffer line, LineHandler<SMTPSession> next) {
        for (Header header : this.headers(session)) {
            Response response = header.transferTo(session, next);
            if (response == null) continue;
            return response;
        }
        return next.onLine((ProtocolSession)session, line);
    }

    protected abstract Collection<Header> headers(SMTPSession var1);

    public static final class Header {
        public static final String MULTI_LINE_PREFIX = "          ";
        public final String name;
        public final List<String> values = new ArrayList<String>();

        public Header(String name, String value) {
            this.name = name;
            this.values.add(value);
        }

        public Header add(String value) {
            this.values.add(value);
            return this;
        }

        public Response transferTo(SMTPSession session, LineHandler<SMTPSession> handler) {
            String charset = session.getCharset().name();
            try {
                String line;
                Response response = null;
                for (int i = 0; i < this.values.size() && (response = handler.onLine((ProtocolSession)session, ByteBuffer.wrap(((line = i == 0 ? this.name + ": " + this.values.get(i) : MULTI_LINE_PREFIX + this.values.get(i)) + session.getLineDelimiter()).getBytes(charset)))) == null; ++i) {
                }
                return response;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("NO " + charset + " support ?", e);
            }
        }
    }

    static enum Location {
        Prefix,
        Suffix;

    }
}

