/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp;

import java.util.ArrayList;
import java.util.List;
import org.apache.james.protocols.api.AbstractResponse;

public class SMTPResponse
extends AbstractResponse {
    protected SMTPResponse() {
    }

    public SMTPResponse(String code, CharSequence description) {
        super(code, description);
    }

    public SMTPResponse(String rawLine) {
        this(SMTPResponse.extractCode(rawLine), SMTPResponse.extractResponse(rawLine));
    }

    private static String extractCode(String raw) {
        String[] args = raw.split(" ");
        if (args != null && args.length > 1) {
            return args[0];
        }
        throw new IllegalArgumentException("Invalid Response format. Format should be [Code Description]");
    }

    private static String extractResponse(String raw) {
        String[] args = raw.split(" ");
        if (args != null && args.length > 1) {
            return args[2];
        }
        return null;
    }

    public List<CharSequence> getLines() {
        ArrayList<CharSequence> responseList = new ArrayList<CharSequence>();
        for (int k = 0; k < this.lines.size(); ++k) {
            StringBuilder respBuff = new StringBuilder(256);
            respBuff.append(this.getRetCode());
            if (k == this.lines.size() - 1) {
                respBuff.append(" ");
                respBuff.append((CharSequence)this.lines.get(k));
            } else {
                respBuff.append("-");
                respBuff.append((CharSequence)this.lines.get(k));
            }
            responseList.add(respBuff.toString());
        }
        return responseList;
    }
}

