/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.apache.commons.io.FileUtils;

public class SizeFormat {
    public static String format(long bytesCount) {
        Preconditions.checkArgument((bytesCount >= 0L ? 1 : 0) != 0, (Object)"Formatting of a negative size is forbidden");
        return Unit.locateUnit(bytesCount).format(bytesCount);
    }

    public static enum Unit {
        TiB(FileUtils.ONE_TB_BI, "TiB"),
        GiB(FileUtils.ONE_GB_BI, "GiB"),
        MiB(FileUtils.ONE_MB_BI, "MiB"),
        KiB(FileUtils.ONE_KB_BI, "KiB"),
        Byte(BigInteger.valueOf(1L), "bytes");

        private static final int SCALE = 2;
        private static final DecimalFormatSymbols DECIMAL_FORMAT_SYMBOLS;
        private static final DecimalFormat DECIMAL_FORMAT;
        private final BigInteger bytesCount;
        private final String notation;

        static Unit locateUnit(long bytesCount) {
            if (bytesCount / 0x10000000000L > 0L) {
                return TiB;
            }
            if (bytesCount / 0x40000000L > 0L) {
                return GiB;
            }
            if (bytesCount / 0x100000L > 0L) {
                return MiB;
            }
            if (bytesCount / 1024L > 0L) {
                return KiB;
            }
            return Byte;
        }

        private Unit(BigInteger bytesCount, String notation) {
            this.bytesCount = bytesCount;
            this.notation = notation;
        }

        public String format(long size) {
            return this.format(new BigDecimal(size));
        }

        public String format(BigDecimal sizeAsDecimal) {
            return this.asString(this.scaleToUnit(sizeAsDecimal)) + " " + this.notation;
        }

        public BigDecimal scaleToUnit(BigDecimal sizeAsDecimal) {
            return sizeAsDecimal.divide(new BigDecimal(this.bytesCount), 2, RoundingMode.FLOOR);
        }

        private String asString(BigDecimal bigDecimal) {
            return DECIMAL_FORMAT.format(bigDecimal.doubleValue());
        }

        static {
            DECIMAL_FORMAT_SYMBOLS = new DecimalFormatSymbols(Locale.US);
            DECIMAL_FORMAT = new DecimalFormat("0.##", DECIMAL_FORMAT_SYMBOLS);
        }
    }
}

