/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.metrics.dropwizard;

import com.codahale.metrics.Timer;
import com.google.common.base.Preconditions;
import java.time.Duration;
import org.apache.james.metrics.api.TimeMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropWizardTimeMetric
implements TimeMetric {
    private static final Logger LOGGER = LoggerFactory.getLogger(DropWizardTimeMetric.class);
    private final String name;
    private final Timer.Context context;
    private final Timer timer;

    public DropWizardTimeMetric(String name, Timer timer) {
        this.name = name;
        this.timer = timer;
        this.context = this.timer.time();
    }

    public String name() {
        return this.name;
    }

    public TimeMetric.ExecutionResult stopAndPublish() {
        return new DropWizardExecutionResult(this.name, Duration.ofNanos(this.context.stop()), Duration.ofNanos(Math.round(this.timer.getSnapshot().get999thPercentile())));
    }

    static class DropWizardExecutionResult
    implements TimeMetric.ExecutionResult {
        private final String name;
        private final Duration elasped;
        private final Duration p99;

        DropWizardExecutionResult(String name, Duration elasped, Duration p99) {
            Preconditions.checkNotNull((Object)elasped);
            Preconditions.checkNotNull((Object)p99);
            Preconditions.checkNotNull((Object)name);
            this.name = name;
            this.elasped = elasped;
            this.p99 = p99;
        }

        public Duration elasped() {
            return this.elasped;
        }

        public TimeMetric.ExecutionResult logWhenExceedP99(Duration thresholdInNanoSeconds) {
            Preconditions.checkNotNull((Object)thresholdInNanoSeconds);
            if (this.elasped.compareTo(this.p99) > 0 && this.elasped.compareTo(thresholdInNanoSeconds) > 0) {
                LOGGER.info("{} metrics took {} nano seconds to complete, exceeding its {} nano seconds p99", new Object[]{this.name, this.elasped, this.p99});
            }
            return this;
        }
    }
}

