/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.metrics.dropwizard;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jmx.JmxReporter;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.james.lifecycle.api.Startable;
import org.apache.james.metrics.api.Metric;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.api.TimeMetric;
import org.apache.james.metrics.dropwizard.DropWizardMetric;
import org.apache.james.metrics.dropwizard.DropWizardTimeMetric;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class DropWizardMetricFactory
implements MetricFactory,
Startable {
    private final MetricRegistry metricRegistry;
    private final JmxReporter jmxReporter;

    @Inject
    public DropWizardMetricFactory(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
        this.jmxReporter = JmxReporter.forRegistry((MetricRegistry)metricRegistry).build();
    }

    public Metric generate(String name) {
        return new DropWizardMetric(this.metricRegistry.counter(name), name);
    }

    public TimeMetric timer(String name) {
        return new DropWizardTimeMetric(name, this.metricRegistry.timer(name));
    }

    public <T> Publisher<T> runPublishingTimerMetric(String name, Publisher<T> publisher) {
        TimeMetric timer = this.timer(name);
        return Flux.from(publisher).doOnComplete(() -> ((TimeMetric)timer).stopAndPublish());
    }

    public <T> Publisher<T> runPublishingTimerMetricLogP99(String name, Publisher<T> publisher) {
        TimeMetric timer = this.timer(name);
        return Flux.from(publisher).doOnComplete(() -> timer.stopAndPublish().logWhenExceedP99(TimeMetric.ExecutionResult.DEFAULT_100_MS_THRESHOLD));
    }

    @PostConstruct
    public void start() {
        this.jmxReporter.start();
    }

    @PreDestroy
    public void stop() {
        this.jmxReporter.stop();
    }
}

