/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.metrics.dropwizard;

import com.codahale.metrics.Counter;
import org.apache.james.metrics.api.Metric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropWizardMetric
implements Metric {
    private static final Logger LOGGER = LoggerFactory.getLogger(DropWizardMetric.class);
    private final Counter counter;
    private final String metricName;

    public DropWizardMetric(Counter counter, String metricName) {
        this.counter = counter;
        this.metricName = metricName;
    }

    public void increment() {
        this.counter.inc();
    }

    public void decrement() {
        this.counter.dec();
    }

    public void add(int value) {
        this.counter.inc((long)value);
    }

    public void remove(int value) {
        this.counter.dec((long)value);
    }

    public long getCount() {
        long value = this.counter.getCount();
        if (value < 0L) {
            LOGGER.error("counter value({}) of the metric '{}' should not be a negative number", (Object)value, (Object)this.metricName);
            return 0L;
        }
        return value;
    }
}

