/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.task;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.time.Duration;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskId;
import org.apache.james.task.TaskManagerWorker;
import org.apache.james.task.TaskWithId;
import org.apache.james.util.MDCBuilder;
import org.apache.james.util.concurrent.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SynchronousSink;
import reactor.core.scheduler.Schedulers;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public class SerialTaskManagerWorker
implements TaskManagerWorker {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerialTaskManagerWorker.class);
    private final ExecutorService taskExecutor;
    private final TaskManagerWorker.Listener listener;
    private final AtomicReference<Tuple2<TaskId, Future<?>>> runningTask;
    private final Set<TaskId> cancelledTasks;
    private final Duration pollingInterval;

    public SerialTaskManagerWorker(TaskManagerWorker.Listener listener, Duration pollingInterval) {
        this.pollingInterval = pollingInterval;
        this.taskExecutor = Executors.newSingleThreadExecutor((ThreadFactory)NamedThreadFactory.withName((String)"task executor"));
        this.listener = listener;
        this.cancelledTasks = Sets.newConcurrentHashSet();
        this.runningTask = new AtomicReference();
    }

    @Override
    public Mono<Task.Result> executeTask(TaskWithId taskWithId) {
        if (!this.cancelledTasks.remove(taskWithId.getId())) {
            CompletableFuture<Task.Result> future = CompletableFuture.supplyAsync(() -> this.runWithMdc(taskWithId, this.listener), this.taskExecutor);
            this.runningTask.set(Tuples.of((Object)taskWithId.getId(), future));
            return Mono.using(() -> this.pollAdditionalInformation(taskWithId).subscribe(), ignored -> Mono.fromFuture((CompletableFuture)future).doOnError(exception -> this.handleExecutionError(taskWithId, this.listener, (Throwable)exception)).onErrorReturn((Object)Task.Result.PARTIAL), Disposable::dispose);
        }
        this.listener.cancelled(taskWithId.getId(), taskWithId.getTask().details());
        return Mono.empty();
    }

    private void handleExecutionError(TaskWithId taskWithId, TaskManagerWorker.Listener listener, Throwable exception) {
        if (exception instanceof CancellationException) {
            listener.cancelled(taskWithId.getId(), taskWithId.getTask().details());
        } else {
            listener.failed(taskWithId.getId(), taskWithId.getTask().details(), exception);
        }
    }

    private Flux<TaskExecutionDetails.AdditionalInformation> pollAdditionalInformation(TaskWithId taskWithId) {
        return Mono.fromCallable(() -> taskWithId.getTask().details()).delayElement(this.pollingInterval, Schedulers.elastic()).repeat().handle((maybeDetails, sink) -> maybeDetails.ifPresent(arg_0 -> ((SynchronousSink)sink).next(arg_0))).doOnNext(information -> this.listener.updated(taskWithId.getId(), (TaskExecutionDetails.AdditionalInformation)information));
    }

    private Task.Result runWithMdc(TaskWithId taskWithId, TaskManagerWorker.Listener listener) {
        return (Task.Result)MDCBuilder.withMdc((MDCBuilder)MDCBuilder.create().addContext("taskId", (Object)taskWithId.getId()).addContext("taskType", (Object)taskWithId.getTask().type()).addContext("taskDetails", (Object)taskWithId.getTask().details()), () -> this.run(taskWithId, listener));
    }

    private Task.Result run(TaskWithId taskWithId, TaskManagerWorker.Listener listener) {
        listener.started(taskWithId.getId());
        try {
            return taskWithId.getTask().run().onComplete(new Task.CompletionOperation[]{result -> listener.completed(taskWithId.getId(), result, taskWithId.getTask().details())}).onFailure(new Task.Operation[]{() -> {
                LOGGER.error("Task was partially performed. Check logs for more details. Taskid : " + taskWithId.getId());
                listener.failed(taskWithId.getId(), taskWithId.getTask().details());
            }});
        }
        catch (InterruptedException e) {
            listener.cancelled(taskWithId.getId(), taskWithId.getTask().details());
            return Task.Result.PARTIAL;
        }
        catch (Exception e) {
            LOGGER.error("Error while running task {}", (Object)taskWithId.getId(), (Object)e);
            listener.failed(taskWithId.getId(), taskWithId.getTask().details(), e);
            return Task.Result.PARTIAL;
        }
    }

    @Override
    public void cancelTask(TaskId taskId) {
        this.cancelledTasks.add(taskId);
        Optional.ofNullable(this.runningTask.get()).filter(task -> ((TaskId)task.getT1()).equals((Object)taskId)).ifPresent(task -> ((Future)task.getT2()).cancel(true));
    }

    @Override
    public void fail(TaskId taskId, Optional<TaskExecutionDetails.AdditionalInformation> additionalInformation, String errorMessage, Throwable reason) {
        this.listener.failed(taskId, additionalInformation, errorMessage, reason);
    }

    @Override
    public void close() throws IOException {
        this.taskExecutor.shutdownNow();
    }
}

