/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.conf;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.apache.openjpa.audit.AuditLogger;
import org.apache.openjpa.audit.Auditor;
import org.apache.openjpa.conf.AutoDetachValue;
import org.apache.openjpa.conf.BrokerFactoryValue;
import org.apache.openjpa.conf.BrokerValue;
import org.apache.openjpa.conf.CacheMarshallersValue;
import org.apache.openjpa.conf.CallbackOptions;
import org.apache.openjpa.conf.Compatibility;
import org.apache.openjpa.conf.DetachOptions;
import org.apache.openjpa.conf.MetaDataRepositoryValue;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.conf.QueryCompilationCacheValue;
import org.apache.openjpa.conf.RemoteCommitProviderValue;
import org.apache.openjpa.conf.SeqValue;
import org.apache.openjpa.conf.Specification;
import org.apache.openjpa.conf.SpecificationPlugin;
import org.apache.openjpa.datacache.CacheDistributionPolicy;
import org.apache.openjpa.datacache.ConcurrentDataCache;
import org.apache.openjpa.datacache.ConcurrentQueryCache;
import org.apache.openjpa.datacache.DataCacheManager;
import org.apache.openjpa.datacache.DataCacheManagerImpl;
import org.apache.openjpa.datacache.PartitionedDataCache;
import org.apache.openjpa.ee.ManagedRuntime;
import org.apache.openjpa.event.BrokerFactoryEventManager;
import org.apache.openjpa.event.LifecycleEventManager;
import org.apache.openjpa.event.OrphanedKeyAction;
import org.apache.openjpa.event.RemoteCommitEventManager;
import org.apache.openjpa.event.RemoteCommitProvider;
import org.apache.openjpa.instrumentation.InstrumentationManager;
import org.apache.openjpa.instrumentation.InstrumentationManagerImpl;
import org.apache.openjpa.kernel.BrokerImpl;
import org.apache.openjpa.kernel.FinderCache;
import org.apache.openjpa.kernel.InverseManager;
import org.apache.openjpa.kernel.LockManager;
import org.apache.openjpa.kernel.PreparedQueryCache;
import org.apache.openjpa.kernel.SavepointManager;
import org.apache.openjpa.kernel.Seq;
import org.apache.openjpa.kernel.exps.AggregateListener;
import org.apache.openjpa.kernel.exps.FilterListener;
import org.apache.openjpa.lib.conf.BooleanValue;
import org.apache.openjpa.lib.conf.ConfigurationImpl;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.lib.conf.IntValue;
import org.apache.openjpa.lib.conf.ObjectValue;
import org.apache.openjpa.lib.conf.PluginListValue;
import org.apache.openjpa.lib.conf.PluginValue;
import org.apache.openjpa.lib.conf.ProductDerivations;
import org.apache.openjpa.lib.conf.StringListValue;
import org.apache.openjpa.lib.conf.StringValue;
import org.apache.openjpa.lib.encryption.EncryptionProvider;
import org.apache.openjpa.lib.instrumentation.InstrumentationLevel;
import org.apache.openjpa.lib.instrumentation.InstrumentationProvider;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.StringUtil;
import org.apache.openjpa.meta.MetaDataFactory;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.util.ClassResolver;
import org.apache.openjpa.util.ImplHelper;
import org.apache.openjpa.util.ProxyManager;
import org.apache.openjpa.util.StoreFacadeTypeRegistry;
import org.apache.openjpa.validation.ValidatingLifecycleEventManager;

public class OpenJPAConfigurationImpl
extends ConfigurationImpl
implements OpenJPAConfiguration {
    protected MetaDataRepository metaRepository = null;
    protected RemoteCommitEventManager remoteEventManager = null;
    public ObjectValue classResolverPlugin;
    public BrokerValue brokerPlugin;
    public ObjectValue dataCachePlugin;
    public ObjectValue dataCacheManagerPlugin;
    public ObjectValue auditorPlugin;
    public ObjectValue cacheDistributionPolicyPlugin;
    public IntValue dataCacheTimeout;
    public ObjectValue queryCachePlugin;
    public BooleanValue dynamicDataStructs;
    public ObjectValue managedRuntimePlugin;
    public BooleanValue transactionMode;
    public IntValue connectionRetainMode;
    public IntValue fetchBatchSize;
    public IntValue maxFetchDepth;
    public StringListValue fetchGroups;
    public IntValue flushBeforeQueries;
    public IntValue lockTimeout;
    public IntValue queryTimeout;
    public IntValue readLockLevel;
    public IntValue writeLockLevel;
    public ObjectValue seqPlugin;
    public PluginListValue filterListenerPlugins;
    public PluginListValue aggregateListenerPlugins;
    public BooleanValue retryClassRegistration;
    public ObjectValue proxyManagerPlugin;
    public StringValue connectionUserName;
    public StringValue connectionPassword;
    public PluginValue encryptionProvider;
    public StringValue connectionURL;
    public StringValue connectionDriverName;
    public ObjectValue connectionFactory;
    public StringValue connectionFactoryName;
    public StringValue connectionProperties;
    public StringValue connectionFactoryProperties;
    public BooleanValue connectionFactoryMode;
    public StringValue connection2UserName;
    public StringValue connection2Password;
    public StringValue connection2URL;
    public StringValue connection2DriverName;
    public StringValue connection2Properties;
    public ObjectValue connectionFactory2;
    public StringValue connectionFactory2Name;
    public StringValue connectionFactory2Properties;
    public BooleanValue optimistic;
    public IntValue autoClear;
    public BooleanValue retainState;
    public IntValue restoreState;
    public ObjectValue detachStatePlugin;
    public BooleanValue ignoreChanges;
    public BooleanValue nontransactionalRead;
    public BooleanValue nontransactionalWrite;
    public BooleanValue refreshFromDataCache;
    public BooleanValue multithreaded;
    public StringValue mapping;
    public PluginValue metaFactoryPlugin;
    public MetaDataRepositoryValue metaRepositoryPlugin;
    public ObjectValue lockManagerPlugin;
    public ObjectValue inverseManagerPlugin;
    public ObjectValue savepointManagerPlugin;
    public ObjectValue orphanedKeyPlugin;
    public ObjectValue compatibilityPlugin;
    public ObjectValue callbackPlugin;
    public QueryCompilationCacheValue queryCompilationCachePlugin;
    public IntValue runtimeUnenhancedClasses;
    public CacheMarshallersValue cacheMarshallerPlugins;
    public BooleanValue eagerInitialization;
    public PluginValue preparedQueryCachePlugin;
    public PluginValue finderCachePlugin;
    public ObjectValue specification;
    public StringValue validationMode;
    public ObjectValue validationFactory;
    public ObjectValue validator;
    public ObjectValue lifecycleEventManager;
    public StringValue validationGroupPrePersist;
    public StringValue validationGroupPreUpdate;
    public StringValue validationGroupPreRemove;
    public StringValue dataCacheMode;
    public BooleanValue dynamicEnhancementAgent;
    public ObjectValue instrumentationManager;
    public PluginListValue instrumentationProviders;
    public BooleanValue postLoadOnMerge;
    public BooleanValue optimizeIdCopy;
    public BooleanValue useTcclForSelectNew;
    public IntValue databaseAction;
    public IntValue scriptsAction;
    public IntValue createSource;
    public IntValue dropSource;
    public StringValue createScriptSource;
    public StringValue dropScriptSource;
    public StringValue createScriptTarget;
    public StringValue dropScriptTarget;
    public StringValue loadScriptSource;
    public BrokerFactoryValue brokerFactoryPlugin;
    public RemoteCommitProviderValue remoteProviderPlugin;
    public AutoDetachValue autoDetach;
    private Collection<String> supportedOptions = new HashSet<String>(33);
    private final StoreFacadeTypeRegistry _storeFacadeRegistry = new StoreFacadeTypeRegistry();
    private BrokerFactoryEventManager _brokerFactoryEventManager = new BrokerFactoryEventManager(this);
    private Map<String, Object> _peMap;
    private boolean _allowSetLifeCycleEventManager = true;

    public OpenJPAConfigurationImpl() {
        this(true);
    }

    public OpenJPAConfigurationImpl(boolean loadGlobals) {
        this(true, loadGlobals);
    }

    public OpenJPAConfigurationImpl(boolean derivations, boolean loadGlobals) {
        super(false);
        this.classResolverPlugin = this.addPlugin("ClassResolver", true);
        String[] aliases = new String[]{"default", "org.apache.openjpa.util.ClassResolverImpl", "spec", "org.apache.openjpa.util.ClassResolverImpl"};
        this.classResolverPlugin.setAliases(aliases);
        this.classResolverPlugin.setDefault(aliases[0]);
        this.classResolverPlugin.setString(aliases[0]);
        this.classResolverPlugin.setInstantiatingGetter("getClassResolverInstance");
        this.brokerFactoryPlugin = new BrokerFactoryValue();
        this.addValue(this.brokerFactoryPlugin);
        this.brokerPlugin = new BrokerValue();
        this.addValue(this.brokerPlugin);
        this.dataCacheManagerPlugin = this.addPlugin("DataCacheManager", true);
        aliases = new String[]{"default", DataCacheManagerImpl.class.getName()};
        this.dataCacheManagerPlugin.setAliases(aliases);
        this.dataCacheManagerPlugin.setDefault(aliases[0]);
        this.dataCacheManagerPlugin.setString(aliases[0]);
        this.dataCacheManagerPlugin.setInstantiatingGetter("getDataCacheManager");
        this.cacheDistributionPolicyPlugin = this.addPlugin("CacheDistributionPolicy", true);
        aliases = new String[]{"default", "org.apache.openjpa.datacache.DefaultCacheDistributionPolicy", "type-based", "org.apache.openjpa.datacache.TypeBasedCacheDistributionPolicy"};
        this.cacheDistributionPolicyPlugin.setAliases(aliases);
        this.cacheDistributionPolicyPlugin.setDefault(aliases[0]);
        this.cacheDistributionPolicyPlugin.setString(aliases[0]);
        this.cacheDistributionPolicyPlugin.setInstantiatingGetter("getCacheDistributionPolicy");
        this.dataCachePlugin = this.addPlugin("DataCache", false);
        aliases = new String[]{"false", null, "true", ConcurrentDataCache.class.getName(), "concurrent", ConcurrentDataCache.class.getName(), "partitioned", PartitionedDataCache.class.getName()};
        this.dataCachePlugin.setAliases(aliases);
        this.dataCachePlugin.setDefault(aliases[0]);
        this.dataCachePlugin.setString(aliases[0]);
        this.dataCacheTimeout = this.addInt("DataCacheTimeout");
        this.dataCacheTimeout.setDefault("-1");
        this.dataCacheTimeout.set(-1);
        this.dataCacheTimeout.setDynamic(true);
        this.queryCachePlugin = this.addPlugin("QueryCache", false);
        aliases = new String[]{"false", null, "true", ConcurrentQueryCache.class.getName(), "concurrent", ConcurrentQueryCache.class.getName()};
        this.queryCachePlugin.setAliases(aliases);
        this.queryCachePlugin.setDefault(aliases[0]);
        this.queryCachePlugin.setString(aliases[0]);
        this.refreshFromDataCache = this.addBoolean("RefreshFromDataCache");
        this.refreshFromDataCache.setDefault("false");
        this.refreshFromDataCache.set(false);
        this.refreshFromDataCache.setDynamic(true);
        this.dynamicDataStructs = this.addBoolean("DynamicDataStructs");
        this.dynamicDataStructs.setDefault("false");
        this.dynamicDataStructs.set(false);
        this.lockManagerPlugin = this.addPlugin("LockManager", false);
        aliases = new String[]{"none", "org.apache.openjpa.kernel.NoneLockManager", "version", "org.apache.openjpa.kernel.VersionLockManager"};
        this.lockManagerPlugin.setAliases(aliases);
        this.lockManagerPlugin.setDefault(aliases[0]);
        this.lockManagerPlugin.setString(aliases[0]);
        this.inverseManagerPlugin = this.addPlugin("InverseManager", false);
        aliases = new String[]{"false", null, "true", "org.apache.openjpa.kernel.InverseManager"};
        this.inverseManagerPlugin.setAliases(aliases);
        this.inverseManagerPlugin.setDefault(aliases[0]);
        this.inverseManagerPlugin.setString(aliases[0]);
        this.savepointManagerPlugin = this.addPlugin("SavepointManager", true);
        aliases = new String[]{"in-mem", "org.apache.openjpa.kernel.InMemorySavepointManager"};
        this.savepointManagerPlugin.setAliases(aliases);
        this.savepointManagerPlugin.setDefault(aliases[0]);
        this.savepointManagerPlugin.setString(aliases[0]);
        this.savepointManagerPlugin.setInstantiatingGetter("getSavepointManagerInstance");
        this.orphanedKeyPlugin = this.addPlugin("OrphanedKeyAction", true);
        aliases = new String[]{"log", "org.apache.openjpa.event.LogOrphanedKeyAction", "exception", "org.apache.openjpa.event.ExceptionOrphanedKeyAction", "none", "org.apache.openjpa.event.NoneOrphanedKeyAction"};
        this.orphanedKeyPlugin.setAliases(aliases);
        this.orphanedKeyPlugin.setDefault(aliases[0]);
        this.orphanedKeyPlugin.setString(aliases[0]);
        this.orphanedKeyPlugin.setInstantiatingGetter("getOrphanedKeyActionInstance");
        this.remoteProviderPlugin = new RemoteCommitProviderValue();
        this.addValue(this.remoteProviderPlugin);
        this.transactionMode = this.addBoolean("TransactionMode");
        aliases = new String[]{"local", "false", "managed", "true"};
        this.transactionMode.setAliases(aliases);
        this.transactionMode.setDefault(aliases[0]);
        this.managedRuntimePlugin = this.addPlugin("ManagedRuntime", true);
        aliases = new String[]{"auto", "org.apache.openjpa.ee.AutomaticManagedRuntime", "jndi", "org.apache.openjpa.ee.JNDIManagedRuntime", "invocation", "org.apache.openjpa.ee.InvocationManagedRuntime"};
        this.managedRuntimePlugin.setAliases(aliases);
        this.managedRuntimePlugin.setDefault(aliases[0]);
        this.managedRuntimePlugin.setString(aliases[0]);
        this.managedRuntimePlugin.setInstantiatingGetter("getManagedRuntimeInstance");
        this.proxyManagerPlugin = this.addPlugin("ProxyManager", true);
        aliases = new String[]{"default", "org.apache.openjpa.util.ProxyManagerImpl"};
        this.proxyManagerPlugin.setAliases(aliases);
        this.proxyManagerPlugin.setDefault(aliases[0]);
        this.proxyManagerPlugin.setString(aliases[0]);
        this.proxyManagerPlugin.setInstantiatingGetter("getProxyManagerInstance");
        this.mapping = this.addString("Mapping");
        this.metaFactoryPlugin = this.addPlugin("MetaDataFactory", false);
        this.metaRepositoryPlugin = this.addValue(new MetaDataRepositoryValue());
        this.connectionFactory = this.addObject("ConnectionFactory");
        this.connectionFactory.setInstantiatingGetter("getConnectionFactory");
        this.connectionFactory2 = this.addObject("ConnectionFactory2");
        this.connectionFactory2.setInstantiatingGetter("getConnectionFactory2");
        this.connectionFactory.setDynamic(true);
        this.connectionFactory2.setDynamic(true);
        this.connectionUserName = this.addString("ConnectionUserName");
        this.connectionUserName.addEquivalentKey("javax.persistence.jdbc.user");
        this.connectionPassword = this.addString("ConnectionPassword");
        this.connectionPassword.addEquivalentKey("javax.persistence.jdbc.password");
        this.connectionPassword.hide();
        this.encryptionProvider = this.addPlugin("EncryptionProvider", true);
        this.connectionURL = this.addString("ConnectionURL");
        this.connectionURL.addEquivalentKey("javax.persistence.jdbc.url");
        this.connectionDriverName = this.addString("ConnectionDriverName");
        this.connectionDriverName.addEquivalentKey("javax.persistence.jdbc.driver");
        this.connectionFactoryName = this.addString("ConnectionFactoryName");
        this.connectionProperties = this.addString("ConnectionProperties");
        this.connectionFactoryProperties = this.addString("ConnectionFactoryProperties");
        this.connection2UserName = this.addString("Connection2UserName");
        this.connection2Password = this.addString("Connection2Password");
        this.connection2Password.hide();
        this.connection2URL = this.addString("Connection2URL");
        this.connection2DriverName = this.addString("Connection2DriverName");
        this.connection2Properties = this.addString("Connection2Properties");
        this.connectionFactory2Properties = this.addString("ConnectionFactory2Properties");
        this.connectionFactory2Name = this.addString("ConnectionFactory2Name");
        this.connectionFactoryMode = this.addBoolean("ConnectionFactoryMode");
        aliases = new String[]{"local", "false", "managed", "true"};
        this.connectionFactoryMode.setAliases(aliases);
        this.connectionFactoryMode.setDefault(aliases[0]);
        this.optimistic = this.addBoolean("Optimistic");
        this.optimistic.setDefault("true");
        this.optimistic.set(true);
        this.postLoadOnMerge = this.addBoolean("PostLoadOnMerge");
        this.postLoadOnMerge.setDefault("false");
        this.postLoadOnMerge.set(false);
        this.optimizeIdCopy = this.addBoolean("OptimizeIdCopy");
        this.optimizeIdCopy.setDefault("false");
        this.optimizeIdCopy.set(false);
        this.databaseAction = this.addInt("javax.persistence.schema-generation.database.action");
        aliases = new String[]{"none", String.valueOf(0), "create", String.valueOf(1), "drop-and-create", String.valueOf(2), "drop", String.valueOf(3)};
        this.databaseAction.setAliases(aliases);
        this.databaseAction.setDefault(aliases[0]);
        this.databaseAction.setAliasListComprehensive(true);
        this.scriptsAction = this.addInt("javax.persistence.schema-generation.scripts.action");
        aliases = new String[]{"none", String.valueOf(0), "create", String.valueOf(1), "drop-and-create", String.valueOf(2), "drop", String.valueOf(3)};
        this.scriptsAction.setAliases(aliases);
        this.scriptsAction.setDefault(aliases[0]);
        this.scriptsAction.setAliasListComprehensive(true);
        this.createSource = this.addInt("javax.persistence.schema-generation.create-source");
        aliases = new String[]{"none", String.valueOf(0), "metadata", String.valueOf(1), "script", String.valueOf(2), "metadata-then-script", String.valueOf(3), "script-then-metadata", String.valueOf(4)};
        this.createSource.setAliases(aliases);
        this.createSource.setDefault(aliases[0]);
        this.createSource.setAliasListComprehensive(true);
        this.dropSource = this.addInt("javax.persistence.schema-generation.drop-source");
        aliases = new String[]{"metadata", String.valueOf(1), "script", String.valueOf(2), "metadata-then-script", String.valueOf(3), "script-then-metadata", String.valueOf(4)};
        this.dropSource.setAliases(aliases);
        this.dropSource.setDefault(aliases[0]);
        this.dropSource.setAliasListComprehensive(true);
        this.createScriptSource = this.addString("javax.persistence.schema-generation.create-script-source");
        this.dropScriptSource = this.addString("javax.persistence.schema-generation.drop-script-source");
        this.createScriptTarget = this.addString("javax.persistence.schema-generation.scripts.create-target");
        this.dropScriptTarget = this.addString("javax.persistence.schema-generation.scripts.drop-target");
        this.loadScriptSource = this.addString("javax.persistence.sql-load-script-source");
        this.autoClear = this.addInt("AutoClear");
        aliases = new String[]{"datastore", String.valueOf(0), "all", String.valueOf(1)};
        this.autoClear.setAliases(aliases);
        this.autoClear.setDefault(aliases[0]);
        this.autoClear.set(0);
        this.autoClear.setAliasListComprehensive(true);
        this.retainState = this.addBoolean("RetainState");
        this.retainState.setDefault("true");
        this.retainState.set(true);
        this.restoreState = this.addInt("RestoreState");
        aliases = new String[]{"none", String.valueOf(0), "false", String.valueOf(0), "immutable", String.valueOf(1), "true", String.valueOf(1), "all", String.valueOf(2)};
        this.restoreState.setAliases(aliases);
        this.restoreState.setDefault(aliases[0]);
        this.restoreState.set(1);
        this.restoreState.setAliasListComprehensive(true);
        this.autoDetach = new AutoDetachValue();
        this.addValue(this.autoDetach);
        this.detachStatePlugin = this.addPlugin("DetachState", true);
        aliases = new String[]{"loaded", DetachOptions.Loaded.class.getName(), "fgs", DetachOptions.FetchGroups.class.getName(), "fetch-groups", DetachOptions.FetchGroups.class.getName(), "all", DetachOptions.All.class.getName()};
        this.detachStatePlugin.setAliases(aliases);
        this.detachStatePlugin.setDefault(aliases[0]);
        this.detachStatePlugin.setString(aliases[0]);
        this.detachStatePlugin.setInstantiatingGetter("getDetachStateInstance");
        this.ignoreChanges = this.addBoolean("IgnoreChanges");
        this.nontransactionalRead = this.addBoolean("NontransactionalRead");
        this.nontransactionalRead.setDefault("true");
        this.nontransactionalRead.set(true);
        this.nontransactionalWrite = this.addBoolean("NontransactionalWrite");
        this.multithreaded = this.addBoolean("Multithreaded");
        this.fetchBatchSize = this.addInt("FetchBatchSize");
        this.fetchBatchSize.setDefault("-1");
        this.fetchBatchSize.set(-1);
        this.fetchBatchSize.setDynamic(true);
        this.maxFetchDepth = this.addInt("MaxFetchDepth");
        this.maxFetchDepth.setDefault("-1");
        this.maxFetchDepth.set(-1);
        this.fetchGroups = this.addStringList("FetchGroups");
        this.fetchGroups.setDefault("default");
        this.fetchGroups.set(new String[]{"default"});
        this.flushBeforeQueries = this.addInt("FlushBeforeQueries");
        aliases = new String[]{"true", String.valueOf(0), "false", String.valueOf(1), "with-connection", String.valueOf(2)};
        this.flushBeforeQueries.setAliases(aliases);
        this.flushBeforeQueries.setDefault(aliases[0]);
        this.flushBeforeQueries.set(0);
        this.flushBeforeQueries.setAliasListComprehensive(true);
        this.lockTimeout = this.addInt("LockTimeout");
        this.lockTimeout.addEquivalentKey("javax.persistence.lock.timeout");
        this.lockTimeout.setDefault("-1");
        this.lockTimeout.setDynamic(true);
        this.readLockLevel = this.addInt("ReadLockLevel");
        aliases = new String[]{"read", String.valueOf(10), "write", String.valueOf(20), "none", String.valueOf(0)};
        this.readLockLevel.setAliases(aliases);
        this.readLockLevel.setDefault(aliases[0]);
        this.readLockLevel.set(10);
        this.readLockLevel.setAliasListComprehensive(true);
        this.writeLockLevel = this.addInt("WriteLockLevel");
        aliases = new String[]{"read", String.valueOf(10), "write", String.valueOf(20), "none", String.valueOf(0)};
        this.writeLockLevel.setAliases(aliases);
        this.writeLockLevel.setDefault(aliases[1]);
        this.writeLockLevel.set(20);
        this.writeLockLevel.setAliasListComprehensive(true);
        this.seqPlugin = new SeqValue("Sequence");
        this.seqPlugin.setInstantiatingGetter("getSequenceInstance");
        this.addValue(this.seqPlugin);
        this.connectionRetainMode = this.addInt("ConnectionRetainMode");
        aliases = new String[]{"on-demand", String.valueOf(0), "transaction", String.valueOf(1), "always", String.valueOf(2), "persistence-manager", String.valueOf(2)};
        this.connectionRetainMode.setAliases(aliases);
        this.connectionRetainMode.setDefault(aliases[0]);
        this.connectionRetainMode.setAliasListComprehensive(true);
        this.connectionRetainMode.set(0);
        this.filterListenerPlugins = this.addPluginList("FilterListeners");
        this.filterListenerPlugins.setInstantiatingGetter("getFilterListenerInstances");
        this.aggregateListenerPlugins = this.addPluginList("AggregateListeners");
        this.aggregateListenerPlugins.setInstantiatingGetter("getAggregateListenerInstances");
        this.retryClassRegistration = this.addBoolean("RetryClassRegistration");
        this.compatibilityPlugin = this.addPlugin("Compatibility", true);
        aliases = new String[]{"default", Compatibility.class.getName()};
        this.compatibilityPlugin.setAliases(aliases);
        this.compatibilityPlugin.setDefault(aliases[0]);
        this.compatibilityPlugin.setString(aliases[0]);
        this.compatibilityPlugin.setInstantiatingGetter("getCompatibilityInstance");
        this.callbackPlugin = this.addPlugin("Callbacks", true);
        aliases = new String[]{"default", CallbackOptions.class.getName()};
        this.callbackPlugin.setAliases(aliases);
        this.callbackPlugin.setDefault(aliases[0]);
        this.callbackPlugin.setString(aliases[0]);
        this.callbackPlugin.setInstantiatingGetter("getCallbackOptionsInstance");
        this.queryCompilationCachePlugin = new QueryCompilationCacheValue("QueryCompilationCache");
        this.queryCompilationCachePlugin.setInstantiatingGetter("getQueryCompilationCacheInstance");
        this.addValue(this.queryCompilationCachePlugin);
        this.runtimeUnenhancedClasses = this.addInt("RuntimeUnenhancedClasses");
        this.runtimeUnenhancedClasses.setAliases(new String[]{"supported", String.valueOf(0), "unsupported", String.valueOf(1), "warn", String.valueOf(2)});
        this.runtimeUnenhancedClasses.setDefault("unsupported");
        this.runtimeUnenhancedClasses.setString("unsupported");
        this.runtimeUnenhancedClasses.setAliasListComprehensive(true);
        this.cacheMarshallerPlugins = this.addValue(new CacheMarshallersValue(this));
        this.eagerInitialization = this.addBoolean("InitializeEagerly");
        this.specification = new SpecificationPlugin(this, "Specification");
        this.addValue(this.specification);
        this.specification.setInstantiatingGetter("getSpecificationInstance");
        this.queryTimeout = this.addInt("javax.persistence.query.timeout");
        this.queryTimeout.setDefault("-1");
        this.queryTimeout.setDynamic(true);
        this.lifecycleEventManager = this.addPlugin("LifecycleEventManager", true);
        aliases = new String[]{"default", LifecycleEventManager.class.getName(), "validating", ValidatingLifecycleEventManager.class.getName()};
        this.lifecycleEventManager.setAliases(aliases);
        this.lifecycleEventManager.setDefault(aliases[0]);
        this.lifecycleEventManager.setString(aliases[0]);
        this.lifecycleEventManager.setInstantiatingGetter("getLifecycleEventManagerInstance");
        this.dynamicEnhancementAgent = this.addBoolean("DynamicEnhancementAgent");
        this.dynamicEnhancementAgent.setDefault("true");
        this.dynamicEnhancementAgent.set(true);
        this.instrumentationManager = this.addPlugin("InstrumentationManager", true);
        aliases = new String[]{"default", InstrumentationManagerImpl.class.getName()};
        this.instrumentationManager.setAliases(aliases);
        this.instrumentationManager.setDefault(aliases[0]);
        this.instrumentationManager.setString(aliases[0]);
        this.instrumentationManager.setInstantiatingGetter("getInstrumentationManager");
        this.instrumentationProviders = this.addPluginList("Instrumentation");
        aliases = new String[]{"jmx", "org.apache.openjpa.instrumentation.jmx.JMXProvider"};
        this.instrumentationProviders.setAliases(aliases);
        this.instrumentationProviders.setInstantiatingGetter("getInstrumentationInstances");
        this.auditorPlugin = this.addPlugin("Auditor", true);
        aliases = new String[]{"default", AuditLogger.class.getName()};
        this.auditorPlugin.setAliases(aliases);
        this.auditorPlugin.setInstantiatingGetter("getAuditorInstance");
        this.useTcclForSelectNew = this.addBoolean("UseTCCLinSelectNew");
        this.useTcclForSelectNew.setDefault("false");
        this.useTcclForSelectNew.set(false);
        this.supportedOptions.add("openjpa.option.NontransactionalRead");
        this.supportedOptions.add("openjpa.option.Optimistic");
        this.supportedOptions.add("openjpa.option.ApplicationIdentity");
        this.supportedOptions.add("openjpa.option.DatastoreIdentity");
        this.supportedOptions.add("openjpa.option.Collection");
        this.supportedOptions.add("openjpa.option.Map");
        this.supportedOptions.add("openjpa.option.Array");
        this.supportedOptions.add("openjpa.option.NullContainer");
        this.supportedOptions.add("openjpa.option.EmbeddedRelation");
        this.supportedOptions.add("openjpa.option.EmbeddedCollectionRelation");
        this.supportedOptions.add("openjpa.option.EmbeddedMapRelation");
        this.supportedOptions.add("openjpa.option.IncrementalFlush");
        this.supportedOptions.add("openjpa.option.AutoassignValue");
        this.supportedOptions.add("openjpa.option.IncrementValue");
        this.supportedOptions.add("openjpa.option.DataStoreConnection");
        this.supportedOptions.add("openjpa.option.PostLoadOnMerge");
        this.supportedOptions.add("openjpa.option.UseTCCLinSelectNew");
        if (derivations) {
            ProductDerivations.beforeConfigurationLoad(this);
        }
        if (loadGlobals) {
            this.loadGlobals();
        }
    }

    @Override
    public Collection<String> supportedOptions() {
        return this.supportedOptions;
    }

    @Override
    public String getSpecification() {
        Specification spec = this.getSpecificationInstance();
        return spec == null ? "" : spec.getName();
    }

    @Override
    public Specification getSpecificationInstance() {
        return (Specification)this.specification.get();
    }

    @Override
    public void setSpecification(String spec) {
        this.specification.setString(spec);
    }

    @Override
    public void setSpecification(Specification newSpec) {
        this.specification.set(newSpec);
    }

    @Override
    public void setClassResolver(String classResolver) {
        this.classResolverPlugin.setString(classResolver);
    }

    @Override
    public String getClassResolver() {
        return this.classResolverPlugin.getString();
    }

    @Override
    public void setClassResolver(ClassResolver classResolver) {
        this.classResolverPlugin.set(classResolver);
    }

    @Override
    public ClassResolver getClassResolverInstance() {
        if (this.classResolverPlugin.get() == null) {
            this.classResolverPlugin.instantiate(ClassResolver.class, this);
        }
        return (ClassResolver)this.classResolverPlugin.get();
    }

    @Override
    public void setBrokerFactory(String factory) {
        this.brokerFactoryPlugin.setString(factory);
    }

    @Override
    public String getBrokerFactory() {
        return this.brokerFactoryPlugin.getString();
    }

    @Override
    public void setBrokerImpl(String broker) {
        this.brokerPlugin.setString(broker);
    }

    @Override
    public String getBrokerImpl() {
        return this.brokerPlugin.getString();
    }

    @Override
    public BrokerImpl newBrokerInstance(String user, String pass) {
        BrokerImpl broker = (BrokerImpl)this.brokerPlugin.instantiate(BrokerImpl.class, this);
        if (broker != null) {
            broker.setAuthentication(user, pass);
        }
        return broker;
    }

    @Override
    public void setDataCacheManager(String mgr) {
        this.dataCacheManagerPlugin.setString(mgr);
    }

    @Override
    public String getDataCacheManager() {
        return this.dataCacheManagerPlugin.getString();
    }

    @Override
    public void setDataCacheManager(DataCacheManager dcm) {
        if (dcm != null) {
            dcm.initialize(this, this.dataCachePlugin, this.queryCachePlugin);
        }
        this.dataCacheManagerPlugin.set(dcm);
    }

    @Override
    public DataCacheManager getDataCacheManagerInstance() {
        DataCacheManager dcm = (DataCacheManager)this.dataCacheManagerPlugin.get();
        if (dcm == null && (dcm = (DataCacheManager)this.dataCacheManagerPlugin.instantiate(DataCacheManager.class, this)) != null) {
            dcm.initialize(this, this.dataCachePlugin, this.queryCachePlugin);
        }
        return dcm;
    }

    @Override
    public void setDataCache(String dataCache) {
        this.dataCachePlugin.setString(dataCache);
    }

    @Override
    public String getDataCache() {
        return this.dataCachePlugin.getString();
    }

    @Override
    public void setDataCacheTimeout(int dataCacheTimeout) {
        this.dataCacheTimeout.set(dataCacheTimeout);
    }

    @Override
    public void setDataCacheTimeout(Integer dataCacheTimeout) {
        if (dataCacheTimeout != null) {
            this.setDataCacheTimeout((int)dataCacheTimeout);
        }
    }

    @Override
    public int getDataCacheTimeout() {
        return this.dataCacheTimeout.get();
    }

    @Override
    public void setQueryCache(String queryCache) {
        this.queryCachePlugin.setString(queryCache);
    }

    @Override
    public String getQueryCache() {
        return this.queryCachePlugin.getString();
    }

    @Override
    public boolean getRefreshFromDataCache() {
        return this.refreshFromDataCache.get();
    }

    @Override
    public void setRefreshFromDataCache(boolean flag) {
        this.refreshFromDataCache.set(flag);
    }

    @Override
    public void setRefreshFromDataCache(Boolean flag) {
        if (flag != null) {
            this.refreshFromDataCache.set(flag);
        }
    }

    @Override
    public boolean getDynamicDataStructs() {
        return this.dynamicDataStructs.get();
    }

    @Override
    public void setDynamicDataStructs(boolean dynamic) {
        this.dynamicDataStructs.set(dynamic);
    }

    @Override
    public void setDynamicDataStructs(Boolean dynamic) {
        this.setDynamicDataStructs((boolean)dynamic);
    }

    @Override
    public void setLockManager(String lockManager) {
        this.lockManagerPlugin.setString(lockManager);
    }

    @Override
    public String getLockManager() {
        return this.lockManagerPlugin.getString();
    }

    @Override
    public LockManager newLockManagerInstance() {
        return (LockManager)this.lockManagerPlugin.instantiate(LockManager.class, this, false);
    }

    @Override
    public void setInverseManager(String inverseManager) {
        this.inverseManagerPlugin.setString(inverseManager);
    }

    @Override
    public String getInverseManager() {
        return this.inverseManagerPlugin.getString();
    }

    @Override
    public InverseManager newInverseManagerInstance() {
        return (InverseManager)this.inverseManagerPlugin.instantiate(InverseManager.class, this);
    }

    @Override
    public void setSavepointManager(String savepointManager) {
        this.savepointManagerPlugin.setString(savepointManager);
    }

    @Override
    public String getSavepointManager() {
        return this.savepointManagerPlugin.getString();
    }

    @Override
    public SavepointManager getSavepointManagerInstance() {
        if (this.savepointManagerPlugin.get() == null) {
            this.savepointManagerPlugin.instantiate(SavepointManager.class, this);
        }
        return (SavepointManager)this.savepointManagerPlugin.get();
    }

    @Override
    public void setOrphanedKeyAction(String action) {
        this.orphanedKeyPlugin.setString(action);
    }

    @Override
    public String getOrphanedKeyAction() {
        return this.orphanedKeyPlugin.getString();
    }

    @Override
    public OrphanedKeyAction getOrphanedKeyActionInstance() {
        if (this.orphanedKeyPlugin.get() == null) {
            this.orphanedKeyPlugin.instantiate(OrphanedKeyAction.class, this);
        }
        return (OrphanedKeyAction)this.orphanedKeyPlugin.get();
    }

    @Override
    public void setOrphanedKeyAction(OrphanedKeyAction action) {
        this.orphanedKeyPlugin.set(action);
    }

    @Override
    public void setRemoteCommitProvider(String remoteCommitProvider) {
        this.remoteProviderPlugin.setString(remoteCommitProvider);
    }

    @Override
    public String getRemoteCommitProvider() {
        return this.remoteProviderPlugin.getString();
    }

    @Override
    public RemoteCommitProvider newRemoteCommitProviderInstance() {
        return this.remoteProviderPlugin.instantiateProvider(this);
    }

    @Override
    public void setRemoteCommitEventManager(RemoteCommitEventManager remoteEventManager) {
        this.remoteEventManager = remoteEventManager;
        this.remoteProviderPlugin.configureEventManager(remoteEventManager);
    }

    @Override
    public RemoteCommitEventManager getRemoteCommitEventManager() {
        if (this.remoteEventManager == null) {
            this.remoteEventManager = new RemoteCommitEventManager(this);
            this.remoteProviderPlugin.configureEventManager(this.remoteEventManager);
        }
        return this.remoteEventManager;
    }

    @Override
    public void setTransactionMode(String transactionMode) {
        this.transactionMode.setString(transactionMode);
    }

    @Override
    public String getTransactionMode() {
        return this.transactionMode.getString();
    }

    @Override
    public void setTransactionModeManaged(boolean managed) {
        this.transactionMode.set(managed);
    }

    @Override
    public boolean isTransactionModeManaged() {
        return this.transactionMode.get();
    }

    @Override
    public void setManagedRuntime(String managedRuntime) {
        this.managedRuntimePlugin.setString(managedRuntime);
    }

    @Override
    public String getManagedRuntime() {
        return this.managedRuntimePlugin.getString();
    }

    @Override
    public void setManagedRuntime(ManagedRuntime managedRuntime) {
        this.managedRuntimePlugin.set(managedRuntime);
    }

    @Override
    public ManagedRuntime getManagedRuntimeInstance() {
        if (this.managedRuntimePlugin.get() == null) {
            this.managedRuntimePlugin.instantiate(ManagedRuntime.class, this);
        }
        return (ManagedRuntime)this.managedRuntimePlugin.get();
    }

    @Override
    public void setProxyManager(String proxyManager) {
        this.proxyManagerPlugin.setString(proxyManager);
    }

    @Override
    public String getProxyManager() {
        return this.proxyManagerPlugin.getString();
    }

    @Override
    public void setProxyManager(ProxyManager proxyManager) {
        this.proxyManagerPlugin.set(proxyManager);
    }

    @Override
    public ProxyManager getProxyManagerInstance() {
        if (this.proxyManagerPlugin.get() == null) {
            this.proxyManagerPlugin.instantiate(ProxyManager.class, this);
        }
        return (ProxyManager)this.proxyManagerPlugin.get();
    }

    @Override
    public void setMapping(String mapping) {
        this.mapping.setString(mapping);
    }

    @Override
    public String getMapping() {
        return this.mapping.getString();
    }

    @Override
    public void setMetaDataFactory(String meta) {
        this.metaFactoryPlugin.setString(meta);
    }

    @Override
    public String getMetaDataFactory() {
        return this.metaFactoryPlugin.getString();
    }

    @Override
    public MetaDataFactory newMetaDataFactoryInstance() {
        return (MetaDataFactory)this.metaFactoryPlugin.instantiate(MetaDataFactory.class, this);
    }

    @Override
    public void setMetaDataRepository(String meta) {
        this.metaRepositoryPlugin.setString(meta);
    }

    @Override
    public String getMetaDataRepository() {
        return this.metaRepositoryPlugin.getString();
    }

    @Override
    public void setMetaDataRepository(MetaDataRepository meta) {
        this.metaRepository = meta;
    }

    @Override
    public MetaDataRepository getMetaDataRepositoryInstance() {
        if (this.metaRepository == null) {
            this.metaRepository = this.newMetaDataRepositoryInstance();
        }
        return this.metaRepository;
    }

    @Override
    public boolean metaDataRepositoryAvailable() {
        return this.metaRepository != null;
    }

    @Override
    public MetaDataRepository newMetaDataRepositoryInstance() {
        return (MetaDataRepository)this.metaRepositoryPlugin.instantiate(MetaDataRepository.class, this);
    }

    @Override
    public void setConnectionUserName(String connectionUserName) {
        this.connectionUserName.setString(connectionUserName);
    }

    @Override
    public String getConnectionUserName() {
        return this.connectionUserName.getString();
    }

    @Override
    public void setConnectionPassword(String connectionPassword) {
        this.connectionPassword.setString(connectionPassword);
    }

    @Override
    public String getConnectionPassword() {
        EncryptionProvider p = this.getEncryptionProvider();
        if (p != null) {
            return p.decrypt(this.connectionPassword.getString());
        }
        return this.connectionPassword.getString();
    }

    @Override
    public void setConnectionURL(String connectionURL) {
        this.connectionURL.setString(connectionURL);
    }

    @Override
    public String getConnectionURL() {
        return this.connectionURL.getString();
    }

    @Override
    public void setConnectionDriverName(String driverName) {
        this.connectionDriverName.setString(driverName);
    }

    @Override
    public String getConnectionDriverName() {
        return this.connectionDriverName.getString();
    }

    @Override
    public void setConnectionProperties(String connectionProperties) {
        this.connectionProperties.setString(connectionProperties);
    }

    @Override
    public String getConnectionProperties() {
        return this.connectionProperties.getString();
    }

    @Override
    public void setConnectionFactoryProperties(String connectionFactoryProperties) {
        this.connectionFactoryProperties.setString(connectionFactoryProperties);
    }

    @Override
    public String getConnectionFactoryProperties() {
        return this.connectionFactoryProperties.getString();
    }

    @Override
    public String getConnectionFactoryMode() {
        return this.connectionFactoryMode.getString();
    }

    @Override
    public void setConnectionFactoryMode(String mode) {
        this.connectionFactoryMode.setString(mode);
    }

    @Override
    public boolean isConnectionFactoryModeManaged() {
        return this.connectionFactoryMode.get();
    }

    @Override
    public void setConnectionFactoryModeManaged(boolean managed) {
        this.connectionFactoryMode.set(managed);
    }

    @Override
    public void setConnectionFactoryName(String connectionFactoryName) {
        this.connectionFactoryName.setString(connectionFactoryName);
    }

    @Override
    public String getConnectionFactoryName() {
        return this.connectionFactoryName.getString();
    }

    @Override
    public void setConnectionFactory(Object factory) {
        this.connectionFactory.set(factory);
    }

    @Override
    public Object getConnectionFactory() {
        if (this.connectionFactory.get() == null) {
            this.connectionFactory.set(this.lookupConnectionFactory(this.getConnectionFactoryName(), this.connectionFactory.getProperty()), true);
        }
        return this.connectionFactory.get();
    }

    private Object lookupConnectionFactory(String name, String userKey) {
        if ((name = StringUtil.trimToNull(name)) == null) {
            return null;
        }
        try {
            return Configurations.lookup(name, userKey, this.getLog("openjpa.Runtime"));
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public void setConnection2UserName(String connection2UserName) {
        this.connection2UserName.setString(connection2UserName);
    }

    @Override
    public String getConnection2UserName() {
        return this.connection2UserName.getString();
    }

    @Override
    public void setConnection2Password(String connection2Password) {
        this.connection2Password.setString(connection2Password);
    }

    @Override
    public String getConnection2Password() {
        EncryptionProvider p = this.getEncryptionProvider();
        if (p != null) {
            return p.decrypt(this.connection2Password.getString());
        }
        return this.connection2Password.getString();
    }

    @Override
    public void setConnection2URL(String connection2URL) {
        this.connection2URL.setString(connection2URL);
    }

    @Override
    public String getConnection2URL() {
        return this.connection2URL.getString();
    }

    @Override
    public void setConnection2DriverName(String driverName) {
        this.connection2DriverName.setString(driverName);
    }

    @Override
    public String getConnection2DriverName() {
        return this.connection2DriverName.getString();
    }

    @Override
    public void setConnection2Properties(String connection2Properties) {
        this.connection2Properties.setString(connection2Properties);
    }

    @Override
    public String getConnection2Properties() {
        return this.connection2Properties.getString();
    }

    @Override
    public void setConnectionFactory2Properties(String connectionFactory2Properties) {
        this.connectionFactory2Properties.setString(connectionFactory2Properties);
    }

    @Override
    public String getConnectionFactory2Properties() {
        return this.connectionFactory2Properties.getString();
    }

    @Override
    public void setConnectionFactory2Name(String connectionFactory2Name) {
        this.connectionFactory2Name.setString(connectionFactory2Name);
    }

    @Override
    public String getConnectionFactory2Name() {
        return this.connectionFactory2Name.getString();
    }

    @Override
    public void setConnectionFactory2(Object factory) {
        this.connectionFactory2.set(factory);
    }

    @Override
    public Object getConnectionFactory2() {
        if (this.connectionFactory2.get() == null) {
            this.connectionFactory2.set(this.lookupConnectionFactory(this.getConnectionFactory2Name(), this.connectionFactory2.getProperty()), false);
        }
        return this.connectionFactory2.get();
    }

    @Override
    public void setOptimistic(boolean optimistic) {
        this.optimistic.set(optimistic);
    }

    @Override
    public void setOptimistic(Boolean optimistic) {
        if (optimistic != null) {
            this.setOptimistic((boolean)optimistic);
        }
    }

    @Override
    public boolean getOptimistic() {
        return this.optimistic.get();
    }

    @Override
    public void setAutoClear(String clear) {
        this.autoClear.setString(clear);
    }

    @Override
    public String getAutoClear() {
        return this.autoClear.getString();
    }

    @Override
    public void setAutoClear(int clear) {
        this.autoClear.set(clear);
    }

    @Override
    public int getAutoClearConstant() {
        return this.autoClear.get();
    }

    @Override
    public void setRetainState(boolean retainState) {
        this.retainState.set(retainState);
    }

    @Override
    public void setRetainState(Boolean retainState) {
        if (retainState != null) {
            this.setRetainState((boolean)retainState);
        }
    }

    @Override
    public boolean getRetainState() {
        return this.retainState.get();
    }

    @Override
    public void setRestoreState(String restoreState) {
        this.restoreState.setString(restoreState);
    }

    @Override
    public String getRestoreState() {
        return this.restoreState.getString();
    }

    @Override
    public void setRestoreState(int restoreState) {
        this.restoreState.set(restoreState);
    }

    @Override
    public int getRestoreStateConstant() {
        return this.restoreState.get();
    }

    @Override
    public void setAutoDetach(String autoDetach) {
        this.autoDetach.setString(autoDetach);
    }

    @Override
    public String getAutoDetach() {
        return this.autoDetach.getString();
    }

    @Override
    public void setAutoDetach(int autoDetachFlags) {
        this.autoDetach.setConstant(autoDetachFlags);
    }

    @Override
    public int getAutoDetachConstant() {
        return this.autoDetach.getConstant();
    }

    @Override
    public void setDetachState(String detachState) {
        this.detachStatePlugin.setString(detachState);
    }

    public String getDetachState() {
        return this.detachStatePlugin.getString();
    }

    @Override
    public void setDetachState(DetachOptions detachState) {
        this.detachStatePlugin.set(detachState);
    }

    @Override
    public DetachOptions getDetachStateInstance() {
        if (this.detachStatePlugin.get() == null) {
            this.detachStatePlugin.instantiate(DetachOptions.class, this);
        }
        return (DetachOptions)this.detachStatePlugin.get();
    }

    @Override
    public void setIgnoreChanges(boolean ignoreChanges) {
        this.ignoreChanges.set(ignoreChanges);
    }

    @Override
    public void setIgnoreChanges(Boolean ignoreChanges) {
        if (ignoreChanges != null) {
            this.setIgnoreChanges((boolean)ignoreChanges);
        }
    }

    @Override
    public boolean getIgnoreChanges() {
        return this.ignoreChanges.get();
    }

    @Override
    public void setNontransactionalRead(boolean nontransactionalRead) {
        this.nontransactionalRead.set(nontransactionalRead);
    }

    @Override
    public void setNontransactionalRead(Boolean nontransactionalRead) {
        if (nontransactionalRead != null) {
            this.setNontransactionalRead((boolean)nontransactionalRead);
        }
    }

    @Override
    public boolean getNontransactionalRead() {
        return this.nontransactionalRead.get();
    }

    @Override
    public void setNontransactionalWrite(boolean nontransactionalWrite) {
        this.nontransactionalWrite.set(nontransactionalWrite);
    }

    @Override
    public void setNontransactionalWrite(Boolean nontransactionalWrite) {
        if (nontransactionalWrite != null) {
            this.setNontransactionalWrite((boolean)nontransactionalWrite);
        }
    }

    @Override
    public boolean getNontransactionalWrite() {
        return this.nontransactionalWrite.get();
    }

    @Override
    public void setMultithreaded(boolean multithreaded) {
        this.multithreaded.set(multithreaded);
    }

    @Override
    public void setMultithreaded(Boolean multithreaded) {
        if (multithreaded != null) {
            this.setMultithreaded((boolean)multithreaded);
        }
    }

    @Override
    public boolean getMultithreaded() {
        return this.multithreaded.get();
    }

    @Override
    public void setFetchBatchSize(int fetchBatchSize) {
        this.fetchBatchSize.set(fetchBatchSize);
    }

    @Override
    public void setFetchBatchSize(Integer fetchBatchSize) {
        if (fetchBatchSize != null) {
            this.setFetchBatchSize((int)fetchBatchSize);
        }
    }

    @Override
    public int getFetchBatchSize() {
        return this.fetchBatchSize.get();
    }

    @Override
    public void setMaxFetchDepth(int maxFetchDepth) {
        this.maxFetchDepth.set(maxFetchDepth);
    }

    @Override
    public void setMaxFetchDepth(Integer maxFetchDepth) {
        if (maxFetchDepth != null) {
            this.setMaxFetchDepth((int)maxFetchDepth);
        }
    }

    @Override
    public int getMaxFetchDepth() {
        return this.maxFetchDepth.get();
    }

    @Override
    public void setFetchGroups(String fetchGroups) {
        this.fetchGroups.setString(fetchGroups);
    }

    @Override
    public String getFetchGroups() {
        return this.fetchGroups.getString();
    }

    @Override
    public String[] getFetchGroupsList() {
        return this.fetchGroups.get();
    }

    @Override
    public void setFetchGroups(String[] fetchGroups) {
        this.fetchGroups.set(fetchGroups);
    }

    @Override
    public void setFlushBeforeQueries(String flush) {
        this.flushBeforeQueries.setString(flush);
    }

    @Override
    public String getFlushBeforeQueries() {
        return this.flushBeforeQueries.getString();
    }

    @Override
    public void setFlushBeforeQueries(int flush) {
        this.flushBeforeQueries.set(flush);
    }

    @Override
    public int getFlushBeforeQueriesConstant() {
        return this.flushBeforeQueries.get();
    }

    @Override
    public void setLockTimeout(int timeout) {
        this.lockTimeout.set(timeout);
    }

    @Override
    public void setLockTimeout(Integer timeout) {
        if (timeout != null) {
            this.setLockTimeout((int)timeout);
        }
    }

    @Override
    public int getLockTimeout() {
        return this.lockTimeout.get();
    }

    @Override
    public int getQueryTimeout() {
        return this.queryTimeout.get();
    }

    @Override
    public void setQueryTimeout(int timeout) {
        this.queryTimeout.set(timeout);
    }

    @Override
    public void setReadLockLevel(String level) {
        this.readLockLevel.setString(level);
    }

    @Override
    public String getReadLockLevel() {
        return this.readLockLevel.getString();
    }

    @Override
    public void setReadLockLevel(int level) {
        this.readLockLevel.set(level);
    }

    @Override
    public int getReadLockLevelConstant() {
        return this.readLockLevel.get();
    }

    @Override
    public void setWriteLockLevel(String level) {
        this.writeLockLevel.setString(level);
    }

    @Override
    public String getWriteLockLevel() {
        return this.writeLockLevel.getString();
    }

    @Override
    public void setWriteLockLevel(int level) {
        this.writeLockLevel.set(level);
    }

    @Override
    public int getWriteLockLevelConstant() {
        return this.writeLockLevel.get();
    }

    @Override
    public void setSequence(String sequence) {
        this.seqPlugin.setString(sequence);
    }

    @Override
    public String getSequence() {
        return this.seqPlugin.getString();
    }

    @Override
    public void setSequence(Seq seq) {
        this.seqPlugin.set(seq);
    }

    @Override
    public Seq getSequenceInstance() {
        if (this.seqPlugin.get() == null) {
            this.seqPlugin.instantiate(Seq.class, this);
        }
        return (Seq)this.seqPlugin.get();
    }

    @Override
    public void setConnectionRetainMode(String connectionRetainMode) {
        this.connectionRetainMode.setString(connectionRetainMode);
    }

    @Override
    public String getConnectionRetainMode() {
        return this.connectionRetainMode.getString();
    }

    @Override
    public void setConnectionRetainMode(int connectionRetainMode) {
        this.connectionRetainMode.set(connectionRetainMode);
    }

    @Override
    public int getConnectionRetainModeConstant() {
        return this.connectionRetainMode.get();
    }

    @Override
    public void setFilterListeners(String filterListeners) {
        this.filterListenerPlugins.setString(filterListeners);
    }

    @Override
    public String getFilterListeners() {
        return this.filterListenerPlugins.getString();
    }

    @Override
    public void setFilterListeners(FilterListener[] listeners) {
        this.filterListenerPlugins.set(listeners);
    }

    @Override
    public FilterListener[] getFilterListenerInstances() {
        if (this.filterListenerPlugins.get() == null) {
            this.filterListenerPlugins.instantiate(FilterListener.class, this);
        }
        return (FilterListener[])this.filterListenerPlugins.get();
    }

    @Override
    public void setAggregateListeners(String aggregateListeners) {
        this.aggregateListenerPlugins.setString(aggregateListeners);
    }

    @Override
    public String getAggregateListeners() {
        return this.aggregateListenerPlugins.getString();
    }

    @Override
    public void setAggregateListeners(AggregateListener[] listeners) {
        this.aggregateListenerPlugins.set(listeners);
    }

    @Override
    public AggregateListener[] getAggregateListenerInstances() {
        if (this.aggregateListenerPlugins.get() == null) {
            this.aggregateListenerPlugins.instantiate(AggregateListener.class, this);
        }
        return (AggregateListener[])this.aggregateListenerPlugins.get();
    }

    @Override
    public void setRetryClassRegistration(boolean retry) {
        this.retryClassRegistration.set(retry);
    }

    @Override
    public void setRetryClassRegistration(Boolean retry) {
        if (retry != null) {
            this.setRetryClassRegistration((boolean)retry);
        }
    }

    @Override
    public boolean getRetryClassRegistration() {
        return this.retryClassRegistration.get();
    }

    @Override
    public String getCompatibility() {
        return this.compatibilityPlugin.getString();
    }

    @Override
    public void setCompatibility(String compatibility) {
        this.compatibilityPlugin.setString(compatibility);
    }

    @Override
    public Compatibility getCompatibilityInstance() {
        if (this.compatibilityPlugin.get() == null) {
            Compatibility comp;
            Specification spec = this.getSpecificationInstance();
            Compatibility compatibility = comp = spec != null ? spec.getCompatibility() : null;
            if (comp == null) {
                this.compatibilityPlugin.instantiate(Compatibility.class, this);
            } else {
                this.compatibilityPlugin.configure(comp, this);
            }
        }
        return (Compatibility)this.compatibilityPlugin.get();
    }

    @Override
    public String getCallbackOptions() {
        return this.callbackPlugin.getString();
    }

    @Override
    public void setCallbackOptions(String options) {
        this.callbackPlugin.setString(options);
    }

    @Override
    public CallbackOptions getCallbackOptionsInstance() {
        if (this.callbackPlugin.get() == null) {
            this.callbackPlugin.instantiate(CallbackOptions.class, this);
        }
        return (CallbackOptions)this.callbackPlugin.get();
    }

    @Override
    public String getQueryCompilationCache() {
        return this.queryCompilationCachePlugin.getString();
    }

    @Override
    public void setQueryCompilationCache(String queryCompilationCache) {
        this.queryCompilationCachePlugin.setString(queryCompilationCache);
    }

    @Override
    public Map getQueryCompilationCacheInstance() {
        if (this.queryCompilationCachePlugin.get() == null) {
            this.queryCompilationCachePlugin.instantiate(Map.class, this);
        }
        return (Map)this.queryCompilationCachePlugin.get();
    }

    @Override
    public StoreFacadeTypeRegistry getStoreFacadeTypeRegistry() {
        return this._storeFacadeRegistry;
    }

    @Override
    public BrokerFactoryEventManager getBrokerFactoryEventManager() {
        return this._brokerFactoryEventManager;
    }

    @Override
    public String getRuntimeUnenhancedClasses() {
        return this.runtimeUnenhancedClasses.getString();
    }

    @Override
    public int getRuntimeUnenhancedClassesConstant() {
        return this.runtimeUnenhancedClasses.get();
    }

    @Override
    public void setRuntimeUnenhancedClasses(int mode) {
        this.runtimeUnenhancedClasses.set(mode);
    }

    @Override
    public void setRuntimeUnenhancedClasses(String mode) {
        this.runtimeUnenhancedClasses.setString(mode);
    }

    @Override
    public String getCacheMarshallers() {
        return this.cacheMarshallerPlugins.getString();
    }

    @Override
    public void setCacheMarshallers(String marshallers) {
        this.cacheMarshallerPlugins.setString(marshallers);
    }

    public Map getCacheMarshallerInstances() {
        return this.cacheMarshallerPlugins.getInstancesAsMap();
    }

    @Override
    public boolean isInitializeEagerly() {
        return this.eagerInitialization.get();
    }

    @Override
    public void setInitializeEagerly(boolean retry) {
        this.eagerInitialization.set(retry);
    }

    @Override
    public void setValidationMode(String mode) {
        this.validationMode.setString(mode);
    }

    @Override
    public String getValidationMode() {
        String mode = this.validationMode.getString();
        if (mode == null) {
            mode = this.validationMode.getDefault();
        }
        return mode;
    }

    @Override
    public void setValidationGroupPrePersist(String vgPrePersist) {
        this.validationGroupPrePersist.setString(vgPrePersist);
    }

    @Override
    public String getValidationGroupPrePersist() {
        String vgPrePersist = this.validationGroupPrePersist.getString();
        if (vgPrePersist == null) {
            vgPrePersist = this.validationGroupPrePersist.getDefault();
        }
        return vgPrePersist;
    }

    @Override
    public void setValidationGroupPreUpdate(String vgPreUpdate) {
        this.validationGroupPreUpdate.setString(vgPreUpdate);
    }

    @Override
    public String getValidationGroupPreUpdate() {
        String vgPreUpdate = this.validationGroupPreUpdate.getString();
        if (vgPreUpdate == null) {
            vgPreUpdate = this.validationGroupPreUpdate.getDefault();
        }
        return vgPreUpdate;
    }

    @Override
    public void setValidationGroupPreRemove(String vgPreRemove) {
        this.validationGroupPreRemove.setString(vgPreRemove);
    }

    @Override
    public String getValidationGroupPreRemove() {
        String vgPreRemove = this.validationGroupPreRemove.getString();
        if (vgPreRemove == null) {
            vgPreRemove = this.validationGroupPreRemove.getDefault();
        }
        return vgPreRemove;
    }

    @Override
    public String getInstrumentation() {
        return this.instrumentationProviders.getString();
    }

    @Override
    public void setInstrumentation(String providers) {
        this.instrumentationProviders.setString(providers);
    }

    public InstrumentationProvider[] getInstrumentationInstances() {
        if (this.instrumentationProviders.get() == null) {
            this.instrumentationProviders.instantiate(InstrumentationProvider.class, this);
        }
        return (InstrumentationProvider[])this.instrumentationProviders.get();
    }

    public void setInstrumentationManager(String mgr) {
        this.instrumentationManager.setString(mgr);
    }

    public String getInstrumentationManager() {
        return this.instrumentationManager.getString();
    }

    public void setInstrumentationManager(InstrumentationManager im) {
        if (im != null) {
            im.initialize(this, this.instrumentationProviders);
        }
        this.instrumentationManager.set(im);
    }

    @Override
    public InstrumentationManager getInstrumentationManagerInstance() {
        InstrumentationManager im = (InstrumentationManager)this.instrumentationManager.get();
        if (im == null && (im = (InstrumentationManager)this.instrumentationManager.instantiate(InstrumentationManager.class, this)) != null) {
            im.initialize(this, this.instrumentationProviders);
            im.start(InstrumentationLevel.IMMEDIATE, this);
        }
        return im;
    }

    @Override
    public void instantiateAll() {
        super.instantiateAll();
        this.getMetaDataRepositoryInstance();
        this.getRemoteCommitEventManager();
        this.getAuditorInstance();
        this.cacheMarshallerPlugins.initialize();
        if (this.isInitializeEagerly()) {
            this.getConnectionFactory();
            this.getConnectionFactory2();
        }
    }

    @Override
    protected void preClose() {
        ImplHelper.close(this.metaRepository);
        ImplHelper.close(this.remoteEventManager);
        ImplHelper.close(this.getInstrumentationManagerInstance());
        super.preClose();
    }

    @Override
    public Log getConfigurationLog() {
        return this.getLog("openjpa.Runtime");
    }

    @Override
    public void setQuerySQLCache(String querySQLCache) {
        this.preparedQueryCachePlugin.setString(querySQLCache);
    }

    @Override
    public void setQuerySQLCache(PreparedQueryCache querySQLCache) {
        this.preparedQueryCachePlugin.set(querySQLCache);
    }

    @Override
    public String getQuerySQLCache() {
        return this.preparedQueryCachePlugin.getString();
    }

    @Override
    public PreparedQueryCache getQuerySQLCacheInstance() {
        if (this.preparedQueryCachePlugin == null) {
            return null;
        }
        if (this.preparedQueryCachePlugin.get() == null) {
            this.preparedQueryCachePlugin.instantiate(PreparedQueryCache.class, this);
        }
        return (PreparedQueryCache)this.preparedQueryCachePlugin.get();
    }

    @Override
    public void setFinderCache(String finderCache) {
        this.finderCachePlugin.setString(finderCache);
    }

    @Override
    public String getFinderCache() {
        return this.finderCachePlugin.getString();
    }

    @Override
    public FinderCache getFinderCacheInstance() {
        if (this.finderCachePlugin.get() == null) {
            this.finderCachePlugin.instantiate(FinderCache.class, this);
        }
        return (FinderCache)this.finderCachePlugin.get();
    }

    @Override
    public Object getValidationFactoryInstance() {
        return this.validationFactory.get();
    }

    @Override
    public void setValidationFactory(Object factory) {
        this.validationFactory.set(factory);
    }

    @Override
    public Object getValidatorInstance() {
        return this.validator.get();
    }

    @Override
    public void setValidatorInstance(Object val) {
        this.validator.set(val);
    }

    @Override
    public String getLifecycleEventManager() {
        return this.lifecycleEventManager.getString();
    }

    @Override
    public LifecycleEventManager getLifecycleEventManagerInstance() {
        LifecycleEventManager lem = null;
        if (!this.getCompatibilityInstance().isSingletonLifecycleEventManager() || (lem = (LifecycleEventManager)this.lifecycleEventManager.get()) == null) {
            lem = (LifecycleEventManager)this.lifecycleEventManager.instantiate(LifecycleEventManager.class, this);
        }
        return lem;
    }

    @Override
    public void setLifecycleEventManager(String lem) {
        if (this._allowSetLifeCycleEventManager) {
            this._allowSetLifeCycleEventManager = false;
            this.lifecycleEventManager.setDynamic(true);
            this.lifecycleEventManager.setString(lem);
            this.lifecycleEventManager.setDynamic(false);
        } else {
            this.lifecycleEventManager.setString(lem);
        }
    }

    @Override
    public boolean getDynamicEnhancementAgent() {
        return this.dynamicEnhancementAgent.get();
    }

    @Override
    public void setDynamicEnhancementAgent(boolean dynamic) {
        this.dynamicEnhancementAgent.set(dynamic);
    }

    @Override
    public void setEncryptionProvider(String p) {
        this.encryptionProvider.setString(p);
    }

    @Override
    public EncryptionProvider getEncryptionProvider() {
        if (this.encryptionProvider.get() == null) {
            this.encryptionProvider.instantiate(EncryptionProvider.class, this);
        }
        return (EncryptionProvider)this.encryptionProvider.get();
    }

    @Override
    public void setDataCacheMode(String mode) {
        this.dataCacheMode.setString(mode);
    }

    @Override
    public String getDataCacheMode() {
        return this.dataCacheMode.getString();
    }

    @Override
    public String getCacheDistributionPolicy() {
        return this.cacheDistributionPolicyPlugin.getString();
    }

    @Override
    public CacheDistributionPolicy getCacheDistributionPolicyInstance() {
        CacheDistributionPolicy policy = (CacheDistributionPolicy)this.cacheDistributionPolicyPlugin.get();
        if (policy == null) {
            policy = (CacheDistributionPolicy)this.cacheDistributionPolicyPlugin.instantiate(CacheDistributionPolicy.class, this);
        }
        return policy;
    }

    @Override
    public void setCacheDistributionPolicy(String policyPlugin) {
        this.cacheDistributionPolicyPlugin.setString(policyPlugin);
    }

    @Override
    public void setCacheDistributionPolicyInstance(CacheDistributionPolicy policy) {
        this.cacheDistributionPolicyPlugin.set(policy);
    }

    public void setPersistenceEnvironment(Map<String, Object> peMap) {
        this._peMap = peMap;
    }

    public Map<String, Object> getPersistenceEnvironment() {
        return this._peMap;
    }

    @Override
    public Auditor getAuditorInstance() {
        Auditor auditor = (Auditor)this.auditorPlugin.get();
        if (auditor == null) {
            auditor = (Auditor)this.auditorPlugin.instantiate(Auditor.class, this);
        }
        return auditor;
    }

    @Override
    public void setAuditorInstance(Auditor auditor) {
        this.auditorPlugin.set(auditor);
    }

    @Override
    public String getAuditor() {
        return this.auditorPlugin.getString();
    }

    @Override
    public void setAuditor(String auditor) {
        this.auditorPlugin.setString(auditor);
    }

    @Override
    public boolean getPostLoadOnMerge() {
        return this.postLoadOnMerge.get();
    }

    @Override
    public void setPostLoadOnMerge(boolean postLoadOnMerge) {
        this.postLoadOnMerge.set(postLoadOnMerge);
    }

    @Override
    public void setPostLoadOnMerge(Boolean postLoadOnMerge) {
        if (postLoadOnMerge != null) {
            this.setPostLoadOnMerge((boolean)postLoadOnMerge);
        }
    }

    @Override
    public boolean getOptimizeIdCopy() {
        return this.optimizeIdCopy.get();
    }

    @Override
    public void setOptimizeIdCopy(boolean optimizeId) {
        this.optimizeIdCopy.set(optimizeId);
    }

    @Override
    public void setOptimizeIdCopy(Boolean optimizeId) {
        if (optimizeId != null) {
            this.setOptimizeIdCopy((boolean)optimizeId);
        }
    }

    @Override
    public String getDatabaseAction() {
        return this.databaseAction.getString();
    }

    @Override
    public int getDatabaseActionConstant() {
        return this.databaseAction.get();
    }

    @Override
    public String getScriptsAction() {
        return this.scriptsAction.getString();
    }

    @Override
    public int getScriptsActionConstant() {
        return this.scriptsAction.get();
    }

    @Override
    public String getCreateSource() {
        return this.createSource.getString();
    }

    @Override
    public int getCreateSourceConstant() {
        return this.createSource.get();
    }

    @Override
    public String getDropSource() {
        return this.dropSource.getString();
    }

    @Override
    public int getDropSourceConstant() {
        return this.dropSource.get();
    }

    @Override
    public String getCreateScriptSource() {
        return this.createScriptSource.getString();
    }

    @Override
    public String getDropScriptSource() {
        return this.dropScriptSource.getString();
    }

    @Override
    public String getCreateScriptTarget() {
        return this.createScriptTarget.getString();
    }

    @Override
    public String getDropScriptTarget() {
        return this.dropScriptTarget.getString();
    }

    @Override
    public String getLoadScriptSource() {
        return this.loadScriptSource.getString();
    }

    @Override
    public boolean getUseTCCLinSelectNew() {
        return this.useTcclForSelectNew.get();
    }

    @Override
    public void setUseTCCLinSelectNew(boolean useTcclForSelectNew) {
        this.useTcclForSelectNew.set(useTcclForSelectNew);
    }

    @Override
    public void setUseTCCLinSelectNew(Boolean useTcclForSelectNew) {
        if (useTcclForSelectNew != null) {
            this.setUseTCCLinSelectNew((boolean)useTcclForSelectNew);
        }
    }
}

