/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.events.delivery;

import java.time.Duration;
import org.apache.james.mailbox.events.Event;
import org.apache.james.mailbox.events.EventDeadLetters;
import org.apache.james.mailbox.events.Group;
import org.apache.james.mailbox.events.MailboxListener;
import org.apache.james.mailbox.events.RetryBackoffConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public interface EventDelivery {
    public Mono<Void> deliver(MailboxListener var1, Event var2, DeliveryOption var3);

    public static interface PermanentFailureHandler {
        public static final PermanentFailureHandler NO_HANDLER = event -> Mono.error((Throwable)new UnsupportedOperationException("doesn't handle error"));

        public Mono<Void> handle(Event var1);

        public static class StoreToDeadLetters
        implements PermanentFailureHandler {
            private final Group group;
            private final EventDeadLetters eventDeadLetters;

            public static StoreToDeadLetters of(Group group, EventDeadLetters eventDeadLetters) {
                return new StoreToDeadLetters(group, eventDeadLetters);
            }

            private StoreToDeadLetters(Group group, EventDeadLetters eventDeadLetters) {
                this.group = group;
                this.eventDeadLetters = eventDeadLetters;
            }

            @Override
            public Mono<Void> handle(Event event) {
                return this.eventDeadLetters.store(this.group, event).then();
            }
        }
    }

    public static interface Retryer {
        public static final Retryer NO_RETRYER = (executionResult, event) -> executionResult;

        public Mono<Void> doRetry(Mono<Void> var1, Event var2);

        public static class BackoffRetryer
        implements Retryer {
            private static final Logger LOGGER = LoggerFactory.getLogger(BackoffRetryer.class);
            private static final Duration FOREVER = Duration.ofMillis(Long.MAX_VALUE);
            private final RetryBackoffConfiguration retryBackoff;
            private final MailboxListener mailboxListener;

            public static BackoffRetryer of(RetryBackoffConfiguration retryBackoff, MailboxListener mailboxListener) {
                return new BackoffRetryer(retryBackoff, mailboxListener);
            }

            public BackoffRetryer(RetryBackoffConfiguration retryBackoff, MailboxListener mailboxListener) {
                this.retryBackoff = retryBackoff;
                this.mailboxListener = mailboxListener;
            }

            @Override
            public Mono<Void> doRetry(Mono<Void> executionResult, Event event) {
                return executionResult.retryBackoff((long)this.retryBackoff.getMaxRetries(), this.retryBackoff.getFirstBackoff(), FOREVER, this.retryBackoff.getJitterFactor(), Schedulers.elastic()).doOnError(throwable -> LOGGER.error("listener {} exceeded maximum retry({}) to handle event {}", new Object[]{this.mailboxListener.getClass().getCanonicalName(), this.retryBackoff.getMaxRetries(), event.getClass().getCanonicalName(), throwable})).then();
            }
        }
    }

    public static class DeliveryOption {
        private final Retryer retrier;
        private final PermanentFailureHandler permanentFailureHandler;

        public static DeliveryOption of(Retryer retrier, PermanentFailureHandler permanentFailureHandler) {
            return new DeliveryOption(retrier, permanentFailureHandler);
        }

        public static DeliveryOption none() {
            return new DeliveryOption(Retryer.NO_RETRYER, PermanentFailureHandler.NO_HANDLER);
        }

        private DeliveryOption(Retryer retrier, PermanentFailureHandler permanentFailureHandler) {
            this.retrier = retrier;
            this.permanentFailureHandler = permanentFailureHandler;
        }

        Retryer getRetrier() {
            return this.retrier;
        }

        PermanentFailureHandler getPermanentFailureHandler() {
            return this.permanentFailureHandler;
        }
    }
}

