/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.util;

import com.github.steveash.guavate.Guavate;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Stream;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.james.core.MailAddress;
import org.apache.james.transport.mailets.redirect.SpecialAddress;

public class MailAddressUtils {
    public static List<MailAddress> from(InternetAddress[] internetAddresses) throws AddressException {
        return MailAddressUtils.from((List<InternetAddress>)ImmutableList.copyOf((Object[])internetAddresses));
    }

    private static List<MailAddress> from(List<InternetAddress> internetAddresses) throws AddressException {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (InternetAddress internetAddress : internetAddresses) {
            builder.add((Object)new MailAddress(internetAddress));
        }
        return builder.build();
    }

    public static List<InternetAddress> toInternetAddresses(List<MailAddress> mailAddresses) {
        return (List)MailAddressUtils.streamOfInternetAddress(mailAddresses).collect(Guavate.toImmutableList());
    }

    public static InternetAddress[] toInternetAddressArray(List<MailAddress> mailAddresses) {
        return (InternetAddress[])MailAddressUtils.streamOfInternetAddress(mailAddresses).toArray(InternetAddress[]::new);
    }

    private static Stream<InternetAddress> streamOfInternetAddress(List<MailAddress> mailAddresses) {
        return mailAddresses.stream().map(MailAddress::toInternetAddress);
    }

    public static boolean isUnalteredOrReversePathOrSender(MailAddress mailAddress) {
        return mailAddress.equals((Object)SpecialAddress.UNALTERED) || mailAddress.equals((Object)SpecialAddress.REVERSE_PATH) || mailAddress.equals((Object)SpecialAddress.SENDER);
    }
}

