/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.jdbc;

import com.github.fge.lambdas.Throwing;
import com.github.steveash.guavate.Guavate;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.StringTokenizer;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.sql.DataSource;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.james.core.MailAddress;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.mailrepository.api.MailKey;
import org.apache.james.mailrepository.api.MailRepository;
import org.apache.james.mailrepository.jdbc.MessageInputStream;
import org.apache.james.mailrepository.jdbc.MimeMessageJDBCSource;
import org.apache.james.repository.api.Initializable;
import org.apache.james.repository.api.StreamRepository;
import org.apache.james.repository.file.FilePersistentStreamRepository;
import org.apache.james.server.core.MailImpl;
import org.apache.james.server.core.MimeMessageCopyOnWriteProxy;
import org.apache.james.server.core.MimeMessageSource;
import org.apache.james.server.core.MimeMessageWrapper;
import org.apache.james.util.sql.JDBCUtil;
import org.apache.james.util.sql.SqlResources;
import org.apache.mailet.Attribute;
import org.apache.mailet.Mail;
import org.apache.mailet.PerRecipientHeaders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCMailRepository
implements MailRepository,
Configurable,
Initializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(JDBCMailRepository.class);
    private static final boolean DEEP_DEBUG = false;
    @VisibleForTesting
    String tableName;
    @VisibleForTesting
    String repositoryName;
    private String sqlFileName;
    private FilePersistentStreamRepository sr = null;
    private DataSource datasource;
    private String datasourceName;
    @VisibleForTesting
    SqlResources sqlQueries;
    private JDBCUtil theJDBCUtil;
    private boolean jdbcMailAttributesReady = false;
    private int inMemorySizeLimit;
    private FileSystem fileSystem;
    private String filestore;
    private String destination;

    @Inject
    @VisibleForTesting
    void setDatasource(DataSource datasource) {
        this.datasource = datasource;
    }

    @Inject
    @VisibleForTesting
    void setFileSystem(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    public void configure(HierarchicalConfiguration<ImmutableNode> configuration) throws ConfigurationException {
        LOGGER.debug("{}.configure()", (Object)this.getClass().getName());
        this.destination = configuration.getString("[@destinationURL]");
        if (!this.destination.endsWith("/")) {
            this.destination = this.destination + "/";
        }
        ArrayList<String> urlParams = new ArrayList<String>();
        int start = 5;
        if (this.destination.startsWith("dbfile")) {
            start += 4;
        }
        int end = this.destination.indexOf(47, start);
        while (end > -1) {
            urlParams.add(this.destination.substring(start, end));
            start = end + 1;
            end = this.destination.indexOf(47, start);
        }
        if (urlParams.size() == 0) {
            String exceptionBuffer = "Malformed destinationURL - Must be of the format 'db://<data-source>[/<table>[/<repositoryName>]]'.  Was passed " + configuration.getString("[@destinationURL]");
            throw new ConfigurationException(exceptionBuffer);
        }
        if (urlParams.size() >= 1) {
            this.datasourceName = (String)urlParams.get(0);
        }
        if (urlParams.size() >= 2) {
            this.tableName = (String)urlParams.get(1);
        }
        if (urlParams.size() >= 3) {
            this.repositoryName = "";
            for (int i = 2; i < urlParams.size(); ++i) {
                if (i >= 3) {
                    this.repositoryName = this.repositoryName + '/';
                }
                this.repositoryName = this.repositoryName + (String)urlParams.get(i);
            }
        }
        LOGGER.debug("Parsed URL: table = '{}', repositoryName = '{}'", (Object)this.tableName, (Object)this.repositoryName);
        this.inMemorySizeLimit = configuration.getInt("inMemorySizeLimit", 409600000);
        this.filestore = configuration.getString("filestore", null);
        this.sqlFileName = configuration.getString("sqlFile");
    }

    @PostConstruct
    public void init() throws Exception {
        LOGGER.debug("{}.initialize()", (Object)this.getClass().getName());
        try {
            if (this.filestore != null) {
                BaseHierarchicalConfiguration streamConfiguration = new BaseHierarchicalConfiguration();
                streamConfiguration.addProperty("[@destinationURL]", (Object)this.filestore);
                this.sr = new FilePersistentStreamRepository();
                this.sr.setFileSystem(this.fileSystem);
                this.sr.configure((HierarchicalConfiguration)streamConfiguration);
                this.sr.init();
                LOGGER.debug("Got filestore for JdbcMailRepository: {}", (Object)this.filestore);
            }
            LOGGER.debug("{} created according to {}", (Object)this.getClass().getName(), (Object)this.destination);
        }
        catch (Exception e) {
            LOGGER.error("Failed to retrieve Store component", (Throwable)e);
            throw new ConfigurationException("Failed to retrieve Store component", (Throwable)e);
        }
        this.theJDBCUtil = new JDBCUtil();
        try (Connection conn = this.datasource.getConnection();){
            InputStream sqlFile;
            try {
                sqlFile = this.fileSystem.getResource(this.sqlFileName);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw e;
            }
            LOGGER.debug("Reading SQL resources from file: {}, section {}.", (Object)this.sqlFileName, (Object)this.getClass().getName());
            HashMap<String, String> sqlParameters = new HashMap<String, String>();
            if (this.tableName != null) {
                sqlParameters.put("table", this.tableName);
            }
            if (this.repositoryName != null) {
                sqlParameters.put("repository", this.repositoryName);
            }
            this.sqlQueries = new SqlResources();
            this.sqlQueries.init(sqlFile, this.getClass().getName(), conn, sqlParameters);
            DatabaseMetaData dbMetaData = conn.getMetaData();
            if (!this.theJDBCUtil.tableExists(dbMetaData, this.tableName)) {
                try (PreparedStatement createStatement = conn.prepareStatement(this.sqlQueries.getSqlString("createTable", true));){
                    createStatement.execute();
                }
                LOGGER.info("JdbcMailRepository: Created table '{}'.", (Object)this.tableName);
            }
            this.checkJdbcAttributesSupport(dbMetaData);
        }
    }

    private void checkJdbcAttributesSupport(DatabaseMetaData dbMetaData) throws SQLException {
        String retrieveMessageAttrSql;
        String attributesColumnName = "message_attributes";
        boolean hasUpdateMessageAttributesSQL = false;
        boolean hasRetrieveMessageAttributesSQL = false;
        boolean hasMessageAttributesColumn = this.theJDBCUtil.columnExists(dbMetaData, this.tableName, attributesColumnName);
        StringBuilder logBuffer = new StringBuilder(64).append("JdbcMailRepository '").append(this.repositoryName).append(", table '").append(this.tableName).append("': ");
        String updateMessageAttrSql = this.sqlQueries.getSqlString("updateMessageAttributesSQL", false);
        if (updateMessageAttrSql != null) {
            hasUpdateMessageAttributesSQL = true;
        }
        if ((retrieveMessageAttrSql = this.sqlQueries.getSqlString("retrieveMessageAttributesSQL", false)) != null) {
            hasRetrieveMessageAttributesSQL = true;
        }
        if (hasUpdateMessageAttributesSQL && !hasRetrieveMessageAttributesSQL) {
            logBuffer.append("JDBC Mail Attributes support was activated for update but not for retrieval(found 'updateMessageAttributesSQL' but not 'retrieveMessageAttributesSQL'in table '").append(this.tableName).append("').");
            String logBufferAsString = logBuffer.toString();
            LOGGER.error(logBufferAsString);
            throw new SQLException(logBufferAsString);
        }
        if (!hasUpdateMessageAttributesSQL && hasRetrieveMessageAttributesSQL) {
            logBuffer.append("JDBC Mail Attributes support was activated for retrieval but not for update(found 'retrieveMessageAttributesSQL' but not 'updateMessageAttributesSQL'in table '").append(this.tableName).append("'.");
            String logBufferAsString = logBuffer.toString();
            LOGGER.error(logBufferAsString);
            throw new SQLException(logBufferAsString);
        }
        if (!hasMessageAttributesColumn && (hasUpdateMessageAttributesSQL || hasRetrieveMessageAttributesSQL)) {
            logBuffer.append("JDBC Mail Attributes support was activated but column '").append(attributesColumnName).append("' is missing in table '").append(this.tableName).append("'.");
            String logBufferAsString = logBuffer.toString();
            LOGGER.error(logBufferAsString);
            throw new SQLException(logBufferAsString);
        }
        if (hasUpdateMessageAttributesSQL && hasRetrieveMessageAttributesSQL) {
            this.jdbcMailAttributesReady = true;
            logBuffer.append("JDBC Mail Attributes support ready.");
            LOGGER.info("{}", (Object)logBuffer);
        } else {
            this.jdbcMailAttributesReady = false;
            logBuffer.append("JDBC Mail Attributes support not activated. Missing both 'updateMessageAttributesSQL' and 'retrieveMessageAttributesSQL' statements for table '").append(this.tableName).append("' in sqlResources.xml. ").append("Will not persist in the repository '").append(this.repositoryName).append("'.");
            LOGGER.warn("{}", (Object)logBuffer);
        }
    }

    public MailKey store(Mail mc) throws MessagingException {
        MailKey key = MailKey.forMail((Mail)mc);
        try {
            this.internalStore(mc);
            return key;
        }
        catch (MessagingException e) {
            LOGGER.error("Exception caught while storing mail {}", (Object)key, (Object)e);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("Exception caught while storing mail {}", (Object)key, (Object)e);
            throw new MessagingException("Exception caught while storing mail " + key, e);
        }
    }

    private void internalStore(Mail mc) throws IOException, MessagingException {
        try (Connection conn = this.datasource.getConnection();){
            boolean saveBody = this.saveBodyRequired(mc);
            MessageInputStream is = new MessageInputStream(mc, (StreamRepository)this.sr, this.inMemorySizeLimit, true);
            conn.setAutoCommit(false);
            boolean exists = this.checkMessageExists(mc, conn);
            if (exists) {
                this.updateMessage(mc, conn);
                if (this.jdbcMailAttributesReady && mc.hasAttributes()) {
                    this.updateMailAttributes(mc, conn);
                }
                if (saveBody) {
                    this.updateMessageBody(mc, conn, is);
                }
            } else {
                this.insertMessage(mc, conn, is);
            }
            conn.commit();
            conn.setAutoCommit(true);
        }
        catch (SQLException e) {
            LOGGER.debug("Failed to store internal mail", (Throwable)e);
            throw new IOException(e.getMessage());
        }
    }

    private void insertMessage(Mail mc, Connection conn, MessageInputStream is) throws SQLException, IOException {
        String insertMessageSQL = this.sqlQueries.getSqlString("insertMessageSQL", true);
        try (PreparedStatement insertMessage = conn.prepareStatement(insertMessageSQL);){
            int numberOfParameters = insertMessage.getParameterMetaData().getParameterCount();
            insertMessage.setString(1, mc.getName());
            insertMessage.setString(2, this.repositoryName);
            insertMessage.setString(3, mc.getState());
            insertMessage.setString(4, mc.getErrorMessage());
            if (mc.getMaybeSender().isNullSender()) {
                insertMessage.setNull(5, 12);
            } else {
                insertMessage.setString(5, mc.getMaybeSender().get().toString());
            }
            StringBuilder recipients = new StringBuilder();
            Iterator i = mc.getRecipients().iterator();
            while (i.hasNext()) {
                recipients.append(((MailAddress)i.next()).toString());
                if (!i.hasNext()) continue;
                recipients.append("\r\n");
            }
            insertMessage.setString(6, recipients.toString());
            insertMessage.setString(7, mc.getRemoteHost());
            insertMessage.setString(8, mc.getRemoteAddr());
            if (mc.getPerRecipientSpecificHeaders().getHeadersByRecipient().isEmpty()) {
                insertMessage.setObject(9, null);
            } else {
                byte[] bytes = SerializationUtils.serialize((Serializable)mc.getPerRecipientSpecificHeaders());
                insertMessage.setBinaryStream(9, (InputStream)new ByteArrayInputStream(bytes), bytes.length);
            }
            insertMessage.setTimestamp(10, new Timestamp(mc.getLastUpdated().getTime()));
            insertMessage.setBinaryStream(11, (InputStream)is, (int)is.getSize());
            if (numberOfParameters > 11) {
                try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
                     ObjectOutputStream oos = new ObjectOutputStream(baos);){
                    if (mc instanceof MailImpl) {
                        oos.writeObject(((MailImpl)mc).getAttributesRaw());
                    } else {
                        Map temp = (Map)mc.attributes().collect(Guavate.toImmutableMap(attribute -> attribute.getName().asString(), attribute -> (Serializable)attribute.getValue().value()));
                        oos.writeObject(temp);
                    }
                    oos.flush();
                    ByteArrayInputStream attrInputStream = new ByteArrayInputStream(baos.toByteArray());
                    insertMessage.setBinaryStream(12, (InputStream)attrInputStream, baos.size());
                }
            }
            insertMessage.execute();
        }
    }

    private void updateMessageBody(Mail mc, Connection conn, MessageInputStream is) throws SQLException {
        try (PreparedStatement updateMessageBody = conn.prepareStatement(this.sqlQueries.getSqlString("updateMessageBodySQL", true));){
            updateMessageBody.setBinaryStream(1, (InputStream)is, (int)is.getSize());
            updateMessageBody.setString(2, mc.getName());
            updateMessageBody.setString(3, this.repositoryName);
            updateMessageBody.execute();
        }
    }

    private void updateMailAttributes(Mail mc, Connection conn) throws IOException {
        String updateMessageAttrSql = this.sqlQueries.getSqlString("updateMessageAttributesSQL", false);
        try (PreparedStatement updateMessageAttr = conn.prepareStatement(updateMessageAttrSql);
             ByteArrayOutputStream baos = new ByteArrayOutputStream();
             ObjectOutputStream oos = new ObjectOutputStream(baos);){
            if (mc instanceof MailImpl) {
                oos.writeObject(((MailImpl)mc).getAttributesRaw());
            } else {
                Map temp = (Map)mc.attributes().collect(Guavate.toImmutableMap(attribute -> attribute.getName().asString(), attribute -> (Serializable)attribute.getValue().value()));
                oos.writeObject(temp);
            }
            oos.flush();
            ByteArrayInputStream attrInputStream = new ByteArrayInputStream(baos.toByteArray());
            updateMessageAttr.setBinaryStream(1, (InputStream)attrInputStream, baos.size());
            updateMessageAttr.setString(2, mc.getName());
            updateMessageAttr.setString(3, this.repositoryName);
            updateMessageAttr.execute();
        }
        catch (SQLException sqle) {
            LOGGER.info("JDBCMailRepository: Trying to update mail attributes failed.", (Throwable)sqle);
        }
    }

    private void updateMessage(Mail mc, Connection conn) throws SQLException {
        try (PreparedStatement updateMessage = conn.prepareStatement(this.sqlQueries.getSqlString("updateMessageSQL", true));){
            updateMessage.setString(1, mc.getState());
            updateMessage.setString(2, mc.getErrorMessage());
            if (mc.getMaybeSender().isNullSender()) {
                updateMessage.setNull(3, 12);
            } else {
                updateMessage.setString(3, mc.getMaybeSender().get().toString());
            }
            StringBuilder recipients = new StringBuilder();
            Iterator i = mc.getRecipients().iterator();
            while (i.hasNext()) {
                recipients.append(((MailAddress)i.next()).toString());
                if (!i.hasNext()) continue;
                recipients.append("\r\n");
            }
            updateMessage.setString(4, recipients.toString());
            updateMessage.setString(5, mc.getRemoteHost());
            updateMessage.setString(6, mc.getRemoteAddr());
            updateMessage.setTimestamp(7, new Timestamp(mc.getLastUpdated().getTime()));
            updateMessage.setString(8, mc.getName());
            updateMessage.setString(9, this.repositoryName);
            updateMessage.execute();
        }
    }

    private boolean checkMessageExists(Mail mc, Connection conn) throws SQLException {
        try (PreparedStatement checkMessageExists = conn.prepareStatement(this.sqlQueries.getSqlString("checkMessageExistsSQL", true));){
            checkMessageExists.setString(1, mc.getName());
            checkMessageExists.setString(2, this.repositoryName);
            ResultSet rsExists = checkMessageExists.executeQuery();
            boolean bl = rsExists.next() && rsExists.getInt(1) > 0;
            return bl;
        }
    }

    private boolean saveBodyRequired(Mail mc) throws MessagingException {
        boolean saveBody;
        MimeMessage messageBody = mc.getMessage();
        if (messageBody instanceof MimeMessageCopyOnWriteProxy) {
            MimeMessageCopyOnWriteProxy messageCow = (MimeMessageCopyOnWriteProxy)messageBody;
            messageBody = messageCow.getWrappedMessage();
        }
        if (messageBody instanceof MimeMessageWrapper) {
            MimeMessageWrapper message = (MimeMessageWrapper)messageBody;
            saveBody = message.isModified();
            if (saveBody) {
                message.loadMessage();
            }
        } else {
            saveBody = true;
        }
        return saveBody;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Mail retrieve(MailKey key) throws MessagingException {
        MailImpl mailImpl;
        ResultSet rsMessage;
        PreparedStatement retrieveMessage;
        Connection conn;
        block27: {
            conn = null;
            retrieveMessage = null;
            rsMessage = null;
            conn = this.datasource.getConnection();
            retrieveMessage = conn.prepareStatement(this.sqlQueries.getSqlString("retrieveMessageSQL", true));
            retrieveMessage.setString(1, key.asString());
            retrieveMessage.setString(2, this.repositoryName);
            rsMessage = retrieveMessage.executeQuery();
            if (rsMessage.next()) break block27;
            LOGGER.debug("Did not find a record {} in {}", (Object)key, (Object)this.repositoryName);
            Mail mail = null;
            this.theJDBCUtil.closeJDBCResultSet(rsMessage);
            this.theJDBCUtil.closeJDBCStatement((Statement)retrieveMessage);
            this.theJDBCUtil.closeJDBCConnection(conn);
            return mail;
        }
        try {
            PreparedStatement retrieveMessageAttr = null;
            HashMap attributes = null;
            if (this.jdbcMailAttributesReady) {
                ResultSet rsMessageAttr;
                block28: {
                    String retrieveMessageAttrSql = this.sqlQueries.getSqlString("retrieveMessageAttributesSQL", false);
                    rsMessageAttr = null;
                    try {
                        retrieveMessageAttr = conn.prepareStatement(retrieveMessageAttrSql);
                        retrieveMessageAttr.setString(1, key.asString());
                        retrieveMessageAttr.setString(2, this.repositoryName);
                        rsMessageAttr = retrieveMessageAttr.executeQuery();
                        if (rsMessageAttr.next()) {
                            try {
                                byte[] serializedAttr;
                                String getAttributesOption = this.sqlQueries.getDbOption("getAttributes");
                                if (getAttributesOption != null && (getAttributesOption.equalsIgnoreCase("useBlob") || getAttributesOption.equalsIgnoreCase("useBinaryStream"))) {
                                    Blob b = rsMessageAttr.getBlob(1);
                                    serializedAttr = b.getBytes(1L, (int)b.length());
                                } else {
                                    serializedAttr = rsMessageAttr.getBytes(1);
                                }
                                if (serializedAttr != null) {
                                    ByteArrayInputStream bais = new ByteArrayInputStream(serializedAttr);
                                    ObjectInputStream ois = new ObjectInputStream(bais);
                                    attributes = (HashMap)ois.readObject();
                                    ois.close();
                                }
                                break block28;
                            }
                            catch (IOException ioe) {
                                LOGGER.debug("Exception reading attributes {} in {}", new Object[]{key, this.repositoryName, ioe});
                            }
                            break block28;
                        }
                        LOGGER.debug("Did not find a record (attributes) {} in {}", (Object)key, (Object)this.repositoryName);
                    }
                    catch (SQLException sqle) {
                        try {
                            LOGGER.error("Error retrieving message{}{}{}{}", new Object[]{sqle.getMessage(), sqle.getErrorCode(), sqle.getSQLState(), String.valueOf(sqle.getNextException())});
                        }
                        catch (Throwable throwable) {
                            this.theJDBCUtil.closeJDBCResultSet(rsMessageAttr);
                            this.theJDBCUtil.closeJDBCStatement((Statement)retrieveMessageAttr);
                            throw throwable;
                        }
                        this.theJDBCUtil.closeJDBCResultSet(rsMessageAttr);
                        this.theJDBCUtil.closeJDBCStatement((Statement)retrieveMessageAttr);
                    }
                }
                this.theJDBCUtil.closeJDBCResultSet(rsMessageAttr);
                this.theJDBCUtil.closeJDBCStatement((Statement)retrieveMessageAttr);
            }
            MailImpl.Builder mc = MailImpl.builder().name(key.asString());
            mc.addAttributes(this.toAttributes(attributes));
            mc.state(rsMessage.getString(1));
            mc.errorMessage(rsMessage.getString(2));
            String sender = rsMessage.getString(3);
            if (sender == null) {
                mc.sender((MailAddress)null);
            } else {
                mc.sender(new MailAddress(sender));
            }
            StringTokenizer st = new StringTokenizer(rsMessage.getString(4), "\r\n", false);
            while (st.hasMoreTokens()) {
                mc.addRecipient(st.nextToken());
            }
            mc.remoteHost(rsMessage.getString(5));
            mc.remoteAddr(rsMessage.getString(6));
            try (InputStream is = rsMessage.getBinaryStream(7);){
                if (is != null) {
                    mc.addAllHeadersForRecipients((PerRecipientHeaders)SerializationUtils.deserialize((InputStream)is));
                }
            }
            mc.lastUpdated((Date)rsMessage.getTimestamp(8));
            MimeMessageJDBCSource source = new MimeMessageJDBCSource(this, key.asString(), (StreamRepository)this.sr);
            MimeMessageCopyOnWriteProxy message = new MimeMessageCopyOnWriteProxy((MimeMessageSource)source);
            mc.mimeMessage((MimeMessage)message);
            mailImpl = mc.build();
        }
        catch (SQLException sqle) {
            try {
                LOGGER.error("Error retrieving message{}{}{}{}", new Object[]{sqle.getMessage(), sqle.getErrorCode(), sqle.getSQLState(), String.valueOf(sqle.getNextException())});
                LOGGER.debug("Failed to retrieve mail", (Throwable)sqle);
                throw new MessagingException("Exception while retrieving mail: " + sqle.getMessage(), (Exception)sqle);
                catch (Exception me) {
                    throw new MessagingException("Exception while retrieving mail: " + me.getMessage(), me);
                }
            }
            catch (Throwable throwable) {
                this.theJDBCUtil.closeJDBCResultSet(rsMessage);
                this.theJDBCUtil.closeJDBCStatement(retrieveMessage);
                this.theJDBCUtil.closeJDBCConnection(conn);
                throw throwable;
            }
        }
        this.theJDBCUtil.closeJDBCResultSet(rsMessage);
        this.theJDBCUtil.closeJDBCStatement((Statement)retrieveMessage);
        this.theJDBCUtil.closeJDBCConnection(conn);
        return mailImpl;
    }

    private ImmutableList<Attribute> toAttributes(HashMap<String, Object> attributes) {
        return (ImmutableList)Optional.ofNullable(attributes).orElse(new HashMap()).entrySet().stream().map(entry -> Attribute.convertToAttribute((String)((String)entry.getKey()), entry.getValue())).collect(Guavate.toImmutableList());
    }

    public void remove(Mail mail) throws MessagingException {
        this.remove(MailKey.forMail((Mail)mail));
    }

    public void remove(Collection<Mail> mails) throws MessagingException {
        for (Mail mail : mails) {
            this.remove(mail);
        }
    }

    public void remove(MailKey key) throws MessagingException {
        this.internalRemove(key);
    }

    private void internalRemove(MailKey key) throws MessagingException {
        Connection conn = null;
        PreparedStatement removeMessage = null;
        try {
            conn = this.datasource.getConnection();
            removeMessage = conn.prepareStatement(this.sqlQueries.getSqlString("removeMessageSQL", true));
            removeMessage.setString(1, key.asString());
            removeMessage.setString(2, this.repositoryName);
            removeMessage.execute();
            if (this.sr != null) {
                this.sr.remove(key.asString());
            }
        }
        catch (Exception me) {
            try {
                throw new MessagingException("Exception while removing mail: " + me.getMessage(), me);
            }
            catch (Throwable throwable) {
                this.theJDBCUtil.closeJDBCStatement(removeMessage);
                this.theJDBCUtil.closeJDBCConnection(conn);
                throw throwable;
            }
        }
        this.theJDBCUtil.closeJDBCStatement((Statement)removeMessage);
        this.theJDBCUtil.closeJDBCConnection(conn);
    }

    /*
     * Exception decompiling
     */
    public long size() throws MessagingException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Iterator<MailKey> list() throws MessagingException {
        Iterator<MailKey> iterator;
        Connection conn = null;
        PreparedStatement listMessages = null;
        ResultSet rsListMessages = null;
        try {
            conn = this.datasource.getConnection();
            listMessages = conn.prepareStatement(this.sqlQueries.getSqlString("listMessagesSQL", true));
            listMessages.setString(1, this.repositoryName);
            rsListMessages = listMessages.executeQuery();
            ArrayList<String> messageList = new ArrayList<String>();
            while (rsListMessages.next() && !Thread.currentThread().isInterrupted()) {
                messageList.add(rsListMessages.getString(1));
            }
            iterator = messageList.stream().map(MailKey::new).iterator();
        }
        catch (Exception me) {
            try {
                throw new MessagingException("Exception while listing mail: " + me.getMessage(), me);
            }
            catch (Throwable throwable) {
                this.theJDBCUtil.closeJDBCResultSet(rsListMessages);
                this.theJDBCUtil.closeJDBCStatement(listMessages);
                this.theJDBCUtil.closeJDBCConnection(conn);
                throw throwable;
            }
        }
        this.theJDBCUtil.closeJDBCResultSet(rsListMessages);
        this.theJDBCUtil.closeJDBCStatement((Statement)listMessages);
        this.theJDBCUtil.closeJDBCConnection(conn);
        return iterator;
    }

    @VisibleForTesting
    Connection getConnection() throws SQLException {
        return this.datasource.getConnection();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JDBCMailRepository)) {
            return false;
        }
        JDBCMailRepository repository = (JDBCMailRepository)obj;
        return (repository.tableName.equals(this.tableName) || repository.tableName != null && repository.tableName.equals(this.tableName)) && (repository.repositoryName.equals(this.repositoryName) || repository.repositoryName != null && repository.repositoryName.equals(this.repositoryName));
    }

    public void removeAll() throws MessagingException {
        ImmutableList.copyOf(this.list()).forEach(Throwing.consumer(this::remove).sneakyThrow());
    }

    public int hashCode() {
        int result = 17;
        if (this.tableName != null) {
            result = 37 * this.tableName.hashCode();
        }
        if (this.repositoryName != null) {
            result = 37 * this.repositoryName.hashCode();
        }
        return result;
    }
}

