/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.james.core.MailAddress;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HasMimeType
extends GenericMatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(HasMimeType.class);
    private Set<String> acceptedContentTypes;

    public void init() throws MessagingException {
        this.acceptedContentTypes = ImmutableSet.copyOf((Iterable)Splitter.on((String)",").trimResults().split((CharSequence)this.getCondition()));
    }

    public Collection<MailAddress> match(Mail mail) throws MessagingException {
        Optional<String> mimeTypes = HasMimeType.getMimeTypeFromMessage(mail.getMessage());
        return mimeTypes.filter(this.acceptedContentTypes::contains).map(any -> mail.getRecipients()).orElse((Collection)ImmutableList.of());
    }

    private static Optional<String> getMimeTypeFromMessage(MimeMessage message) throws MessagingException {
        try {
            return Optional.of(new MimeType(message.getContentType()).getBaseType());
        }
        catch (MimeTypeParseException e) {
            LOGGER.warn("Error while parsing message's mimeType {}", (Object)message.getContentType(), (Object)e);
            return Optional.empty();
        }
    }
}

