/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailbox.tools.indexer;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import java.util.List;
import org.apache.james.core.Username;
import org.apache.james.json.DTOModule;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.server.task.json.dto.AdditionalInformationDTO;
import org.apache.james.server.task.json.dto.AdditionalInformationDTOModule;
import org.apache.mailbox.tools.indexer.ReprocessingContextInformationDTO;
import org.apache.mailbox.tools.indexer.UserReindexingTask;

public class UserReindexingTaskAdditionalInformationDTO
implements AdditionalInformationDTO {
    private final ReprocessingContextInformationDTO reprocessingContextInformationDTO;
    private final String user;

    public static AdditionalInformationDTOModule<UserReindexingTask.AdditionalInformation, UserReindexingTaskAdditionalInformationDTO> serializationModule(MailboxId.Factory factory) {
        return (AdditionalInformationDTOModule)DTOModule.forDomainObject(UserReindexingTask.AdditionalInformation.class).convertToDTO(UserReindexingTaskAdditionalInformationDTO.class).toDomainObjectConverter(dto -> new UserReindexingTask.AdditionalInformation(Username.of((String)dto.getUser()), dto.getSuccessfullyReprocessedMailCount(), dto.getFailedReprocessedMailCount(), ReprocessingContextInformationDTO.deserializeFailures(factory, dto.getFailures()), dto.getTimestamp())).toDTOConverter((details, type) -> new UserReindexingTaskAdditionalInformationDTO(type, details.getUsername(), details.getSuccessfullyReprocessedMailCount(), details.getFailedReprocessedMailCount(), ReprocessingContextInformationDTO.serializeFailures(details.failures()), details.timestamp())).typeName(UserReindexingTask.USER_RE_INDEXING.asString()).withFactory(AdditionalInformationDTOModule::new);
    }

    @JsonCreator
    private UserReindexingTaskAdditionalInformationDTO(@JsonProperty(value="type") String type, @JsonProperty(value="user") String user, @JsonProperty(value="successfullyReprocessedMailCount") int successfullyReprocessedMailCount, @JsonProperty(value="failedReprocessedMailCount") int failedReprocessedMailCount, @JsonProperty(value="failures") List<ReprocessingContextInformationDTO.ReindexingFailureDTO> failures, @JsonProperty(value="timestamp") Instant timestamp) {
        this.user = user;
        this.reprocessingContextInformationDTO = new ReprocessingContextInformationDTO(type, successfullyReprocessedMailCount, failedReprocessedMailCount, failures, timestamp);
    }

    public String getType() {
        return this.reprocessingContextInformationDTO.getType();
    }

    public Instant getTimestamp() {
        return this.reprocessingContextInformationDTO.getTimestamp();
    }

    public String getUser() {
        return this.user;
    }

    public int getSuccessfullyReprocessedMailCount() {
        return this.reprocessingContextInformationDTO.getSuccessfullyReprocessedMailCount();
    }

    public int getFailedReprocessedMailCount() {
        return this.reprocessingContextInformationDTO.getFailedReprocessedMailCount();
    }

    public List<ReprocessingContextInformationDTO.ReindexingFailureDTO> getFailures() {
        return this.reprocessingContextInformationDTO.getFailures();
    }
}

