/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailbox.tools.indexer;

import java.time.Clock;
import java.time.Instant;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.indexer.ReIndexingExecutionFailures;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;
import org.apache.mailbox.tools.indexer.ReIndexerPerformer;
import org.apache.mailbox.tools.indexer.ReprocessingContext;
import org.apache.mailbox.tools.indexer.ReprocessingContextInformation;
import org.apache.mailbox.tools.indexer.UserReindexingTaskDTO;

public class UserReindexingTask
implements Task {
    public static final TaskType USER_RE_INDEXING = TaskType.of((String)"user-reindexing");
    private final ReIndexerPerformer reIndexerPerformer;
    private final Username username;
    private final ReprocessingContext reprocessingContext;

    @Inject
    public UserReindexingTask(ReIndexerPerformer reIndexerPerformer, Username username) {
        this.reIndexerPerformer = reIndexerPerformer;
        this.username = username;
        this.reprocessingContext = new ReprocessingContext();
    }

    public Task.Result run() {
        try {
            return this.reIndexerPerformer.reIndex(this.username, this.reprocessingContext);
        }
        catch (MailboxException e) {
            return Task.Result.PARTIAL;
        }
    }

    public Username getUsername() {
        return this.username;
    }

    public TaskType type() {
        return USER_RE_INDEXING;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.of(new AdditionalInformation(this.username, this.reprocessingContext.successfullyReprocessedMailCount(), this.reprocessingContext.failedReprocessingMailCount(), this.reprocessingContext.failures(), Clock.systemUTC().instant()));
    }

    public static class Factory {
        private final ReIndexerPerformer reIndexerPerformer;

        @Inject
        public Factory(ReIndexerPerformer reIndexerPerformer) {
            this.reIndexerPerformer = reIndexerPerformer;
        }

        public UserReindexingTask create(UserReindexingTaskDTO dto) {
            Username username = Username.of((String)dto.getUsername());
            return new UserReindexingTask(this.reIndexerPerformer, username);
        }
    }

    public static class AdditionalInformation
    extends ReprocessingContextInformation {
        private final Username username;

        AdditionalInformation(Username username, int successfullyReprocessedMailCount, int failedReprocessedMailCount, ReIndexingExecutionFailures failures, Instant timestamp) {
            super(successfullyReprocessedMailCount, failedReprocessedMailCount, failures, timestamp);
            this.username = username;
        }

        public String getUsername() {
            return this.username.asString();
        }
    }
}

