/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailbox.tools.indexer;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Clock;
import java.time.Instant;
import org.apache.james.json.DTOModule;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.server.task.json.dto.AdditionalInformationDTO;
import org.apache.james.server.task.json.dto.AdditionalInformationDTOModule;
import org.apache.mailbox.tools.indexer.SingleMessageReindexingTask;

public class SingleMessageReindexingTaskAdditionalInformationDTO
implements AdditionalInformationDTO {
    private final String type;
    private final String mailboxId;
    private final long uid;
    private final Instant timestamp;

    public static AdditionalInformationDTOModule<SingleMessageReindexingTask.AdditionalInformation, SingleMessageReindexingTaskAdditionalInformationDTO> serializationModule(MailboxId.Factory factory) {
        return (AdditionalInformationDTOModule)DTOModule.forDomainObject(SingleMessageReindexingTask.AdditionalInformation.class).convertToDTO(SingleMessageReindexingTaskAdditionalInformationDTO.class).toDomainObjectConverter(dto -> new SingleMessageReindexingTask.AdditionalInformation(factory.fromString(dto.mailboxId), MessageUid.of((long)dto.getUid()), dto.timestamp)).toDTOConverter((details, type) -> new SingleMessageReindexingTaskAdditionalInformationDTO(type, details.getMailboxId(), details.getUid(), details.timestamp())).typeName(SingleMessageReindexingTask.MESSAGE_RE_INDEXING.asString()).withFactory(AdditionalInformationDTOModule::new);
    }

    private SingleMessageReindexingTaskAdditionalInformationDTO(@JsonProperty(value="type") String type, @JsonProperty(value="mailboxId") String mailboxId, @JsonProperty(value="uid") long uid, @JsonProperty(value="timestamp") Instant timestamp) {
        this.type = type;
        this.mailboxId = mailboxId;
        this.uid = uid;
        this.timestamp = timestamp;
    }

    public String getMailboxId() {
        return this.mailboxId;
    }

    public long getUid() {
        return this.uid;
    }

    public String getType() {
        return this.type;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public static SingleMessageReindexingTaskAdditionalInformationDTO of(SingleMessageReindexingTask task) {
        return new SingleMessageReindexingTaskAdditionalInformationDTO(task.type().asString(), task.getMailboxId().serialize(), task.getUid().asLong(), Clock.systemUTC().instant());
    }
}

