/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailbox.tools.indexer;

import java.time.Clock;
import java.time.Instant;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.mailbox.indexer.ReIndexingExecutionFailures;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;
import org.apache.mailbox.tools.indexer.ReIndexerPerformer;
import org.apache.mailbox.tools.indexer.ReprocessingContext;
import org.apache.mailbox.tools.indexer.ReprocessingContextInformation;
import org.apache.mailbox.tools.indexer.SingleMailboxReindexingTaskDTO;

public class SingleMailboxReindexingTask
implements Task {
    public static final TaskType MAILBOX_RE_INDEXING = TaskType.of((String)"mailbox-reindexing");
    private final ReIndexerPerformer reIndexerPerformer;
    private final MailboxId mailboxId;
    private final ReprocessingContext reprocessingContext;

    @Inject
    public SingleMailboxReindexingTask(ReIndexerPerformer reIndexerPerformer, MailboxId mailboxId) {
        this.reIndexerPerformer = reIndexerPerformer;
        this.mailboxId = mailboxId;
        this.reprocessingContext = new ReprocessingContext();
    }

    public Task.Result run() {
        try {
            return this.reIndexerPerformer.reIndex(this.mailboxId, this.reprocessingContext);
        }
        catch (Exception e) {
            return Task.Result.PARTIAL;
        }
    }

    public MailboxId getMailboxId() {
        return this.mailboxId;
    }

    public TaskType type() {
        return MAILBOX_RE_INDEXING;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.of(new AdditionalInformation(this.mailboxId, this.reprocessingContext.successfullyReprocessedMailCount(), this.reprocessingContext.failedReprocessingMailCount(), this.reprocessingContext.failures(), Clock.systemUTC().instant()));
    }

    public static class Factory {
        private final ReIndexerPerformer reIndexerPerformer;
        private final MailboxId.Factory mailboxIdFactory;

        @Inject
        public Factory(ReIndexerPerformer reIndexerPerformer, MailboxId.Factory mailboxIdFactory) {
            this.reIndexerPerformer = reIndexerPerformer;
            this.mailboxIdFactory = mailboxIdFactory;
        }

        public SingleMailboxReindexingTask create(SingleMailboxReindexingTaskDTO dto) {
            MailboxId mailboxId = this.mailboxIdFactory.fromString(dto.getMailboxId());
            return new SingleMailboxReindexingTask(this.reIndexerPerformer, mailboxId);
        }
    }

    public static class AdditionalInformation
    extends ReprocessingContextInformation {
        private final MailboxId mailboxId;

        AdditionalInformation(MailboxId mailboxId, int successfullyReprocessedMailCount, int failedReprocessedMailCount, ReIndexingExecutionFailures failures, Instant timestamp) {
            super(successfullyReprocessedMailCount, failedReprocessedMailCount, failures, timestamp);
            this.mailboxId = mailboxId;
        }

        public String getMailboxId() {
            return this.mailboxId.serialize();
        }
    }
}

