/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailbox.tools.indexer;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.json.DTOModule;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.server.task.json.dto.TaskDTO;
import org.apache.james.server.task.json.dto.TaskDTOModule;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;
import org.apache.mailbox.tools.indexer.ReIndexerPerformer;
import org.apache.mailbox.tools.indexer.ReprocessingContext;
import org.apache.mailbox.tools.indexer.ReprocessingContextInformation;

public class FullReindexingTask
implements Task {
    public static final TaskType FULL_RE_INDEXING = TaskType.of((String)"full-reindexing");
    private final ReIndexerPerformer reIndexerPerformer;
    private final ReprocessingContext reprocessingContext;

    public static TaskDTOModule<FullReindexingTask, FullReindexingTaskDTO> module(ReIndexerPerformer reIndexerPerformer) {
        return (TaskDTOModule)DTOModule.forDomainObject(FullReindexingTask.class).convertToDTO(FullReindexingTaskDTO.class).toDomainObjectConverter(dto -> new FullReindexingTask(reIndexerPerformer)).toDTOConverter((task, type) -> new FullReindexingTaskDTO(type)).typeName(FULL_RE_INDEXING.asString()).withFactory(TaskDTOModule::new);
    }

    @Inject
    public FullReindexingTask(ReIndexerPerformer reIndexerPerformer) {
        this.reIndexerPerformer = reIndexerPerformer;
        this.reprocessingContext = new ReprocessingContext();
    }

    public Task.Result run() {
        try {
            return this.reIndexerPerformer.reIndex(this.reprocessingContext);
        }
        catch (MailboxException e) {
            return Task.Result.PARTIAL;
        }
    }

    public TaskType type() {
        return FULL_RE_INDEXING;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.of(ReprocessingContextInformation.forFullReindexingTask(this.reprocessingContext));
    }

    public static class FullReindexingTaskDTO
    implements TaskDTO {
        private final String type;

        public FullReindexingTaskDTO(@JsonProperty(value="type") String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }
}

