/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.server.core.configuration;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.convert.DisabledListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.server.core.configuration.Configuration;
import org.apache.james.server.core.configuration.ConfigurationProvider;
import org.apache.james.util.LoggingLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileConfigurationProvider
implements ConfigurationProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileConfigurationProvider.class);
    private static final String CONFIGURATION_FILE_SUFFIX = ".xml";
    public static final HierarchicalConfiguration<ImmutableNode> EMPTY_CONFIGURATION = new XMLConfiguration();
    private final FileSystem fileSystem;
    private final String configurationPrefix;

    public static XMLConfiguration getConfig(InputStream configStream) throws ConfigurationException {
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(XMLConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)new Parameters().xml().setListDelimiterHandler((ListDelimiterHandler)new DisabledListDelimiterHandler())});
        XMLConfiguration xmlConfiguration = (XMLConfiguration)builder.getConfiguration();
        FileHandler fileHandler = new FileHandler((FileBased)xmlConfiguration);
        fileHandler.load(configStream);
        return xmlConfiguration;
    }

    public FileConfigurationProvider(FileSystem fileSystem, Configuration configuration) {
        this.fileSystem = fileSystem;
        this.configurationPrefix = configuration.configurationPath();
    }

    @Override
    public HierarchicalConfiguration<ImmutableNode> getConfiguration(String component, LoggingLevel loggingLevelOnError) throws ConfigurationException {
        Preconditions.checkNotNull((Object)component);
        List configPathParts = Splitter.on((String)".").splitToList((CharSequence)component);
        Preconditions.checkArgument((!configPathParts.isEmpty() ? 1 : 0) != 0);
        Optional<InputStream> inputStream = this.retrieveConfigInputStream((String)configPathParts.get(0), loggingLevelOnError);
        if (inputStream.isPresent()) {
            return this.selectConfigurationPart(configPathParts, (HierarchicalConfiguration<ImmutableNode>)FileConfigurationProvider.getConfig(inputStream.get()));
        }
        return EMPTY_CONFIGURATION;
    }

    private HierarchicalConfiguration<ImmutableNode> selectConfigurationPart(List<String> configPathParts, HierarchicalConfiguration<ImmutableNode> config) {
        return this.selectHierarchicalConfigPart(config, Iterables.skip(configPathParts, (int)1));
    }

    private Optional<InputStream> retrieveConfigInputStream(String configurationFileWithoutExtension, LoggingLevel loggingLevelOnError) throws ConfigurationException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)configurationFileWithoutExtension) ? 1 : 0) != 0, (Object)"The configuration file name should not be empty or null");
        try {
            return Optional.of(this.fileSystem.getResource(this.configurationPrefix + configurationFileWithoutExtension + CONFIGURATION_FILE_SUFFIX));
        }
        catch (IOException e) {
            loggingLevelOnError.format(LOGGER, "Unable to locate configuration file {}.xml, assuming empty configuration", new Object[]{configurationFileWithoutExtension});
            return Optional.empty();
        }
    }

    private HierarchicalConfiguration<ImmutableNode> selectHierarchicalConfigPart(HierarchicalConfiguration<ImmutableNode> config, Iterable<String> configsPathParts) {
        HierarchicalConfiguration currentConfig = config;
        for (String nextPathPart : configsPathParts) {
            currentConfig = currentConfig.configurationAt(nextPathPart);
        }
        return currentConfig;
    }
}

