/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.server.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeMessage;
import javax.mail.util.SharedByteArrayInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.james.lifecycle.api.Disposable;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.server.core.InternetHeadersInputStream;
import org.apache.james.server.core.MailHeaders;
import org.apache.james.server.core.MimeMessageInputStreamSource;
import org.apache.james.server.core.MimeMessageSource;
import org.apache.james.server.core.MimeMessageUtil;

public class MimeMessageWrapper
extends MimeMessage
implements Disposable {
    public static final String USE_MEMORY_COPY = "james.message.usememorycopy";
    protected MimeMessageSource source = null;
    protected boolean messageParsed = false;
    protected boolean headersModified = false;
    protected boolean bodyModified = false;
    private InputStream sourceIn;
    private long initialHeaderSize;

    private MimeMessageWrapper(Session session) {
        super(session);
        this.headers = null;
        this.modified = false;
        this.headersModified = false;
        this.bodyModified = false;
    }

    public MimeMessageWrapper(Session session, MimeMessageSource source) {
        this(session);
        this.source = source;
    }

    public MimeMessageWrapper(MimeMessageSource source) {
        this(Session.getDefaultInstance((Properties)System.getProperties()), source);
    }

    public MimeMessageWrapper(MimeMessage original) throws MessagingException {
        this(Session.getDefaultInstance((Properties)System.getProperties()));
        this.flags = original.getFlags();
        if (this.source == null) {
            boolean useMemoryCopy = false;
            String memoryCopy = System.getProperty(USE_MEMORY_COPY);
            if (memoryCopy != null) {
                useMemoryCopy = Boolean.parseBoolean(memoryCopy);
            }
            try {
                if (useMemoryCopy) {
                    int size = original.getSize();
                    ByteArrayOutputStream bos = size > 0 ? new ByteArrayOutputStream(size) : new ByteArrayOutputStream();
                    original.writeTo((OutputStream)bos);
                    bos.close();
                    SharedByteArrayInputStream in = new SharedByteArrayInputStream(bos.toByteArray());
                    this.parse((InputStream)in);
                    in.close();
                    this.saved = true;
                } else {
                    MimeMessageInputStreamSource src = new MimeMessageInputStreamSource("MailCopy-" + UUID.randomUUID().toString());
                    OutputStream out = src.getWritableOutputStream();
                    original.writeTo(out);
                    out.close();
                    this.source = src;
                }
            }
            catch (IOException ex) {
                throw new MessagingException("IOException while copying message", (Exception)ex);
            }
        }
    }

    protected void updateMessageID() throws MessagingException {
        if (this.getMessageID() == null) {
            super.updateMessageID();
        }
    }

    public synchronized String getSourceId() {
        return this.source != null ? this.source.getSourceId() : null;
    }

    protected synchronized void loadHeaders() throws MessagingException {
        block10: {
            if (this.headers == null) {
                if (this.source != null) {
                    try (InputStream in = this.source.getInputStream();){
                        this.headers = this.createInternetHeaders(in);
                        break block10;
                    }
                    catch (IOException ioe) {
                        throw new MessagingException("Unable to parse headers from stream: " + ioe.getMessage(), (Exception)ioe);
                    }
                }
                throw new MessagingException("loadHeaders called for a message with no source, contentStream or stream");
            }
        }
    }

    public synchronized void loadMessage() throws MessagingException {
        if (!this.messageParsed) {
            if (this.source != null) {
                this.sourceIn = null;
                try {
                    this.sourceIn = this.source.getInputStream();
                    this.parse(this.sourceIn);
                    this.saved = true;
                }
                catch (IOException ioe) {
                    try {
                        this.sourceIn.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.sourceIn = null;
                    throw new MessagingException("Unable to parse stream: " + ioe.getMessage(), (Exception)ioe);
                }
            }
            throw new MessagingException("loadHeaders called for an unparsed message with no source");
        }
    }

    public synchronized boolean isModified() {
        return this.headersModified || this.bodyModified || this.modified;
    }

    public synchronized boolean isBodyModified() {
        return this.bodyModified;
    }

    public synchronized boolean isHeaderModified() {
        return this.headersModified;
    }

    public void writeTo(OutputStream os) throws IOException, MessagingException {
        this.writeTo(os, os);
    }

    public void writeTo(OutputStream os, String[] ignoreList) throws IOException, MessagingException {
        this.writeTo(os, os, ignoreList);
    }

    public void writeTo(OutputStream headerOs, OutputStream bodyOs) throws IOException, MessagingException {
        this.writeTo(headerOs, bodyOs, new String[0]);
    }

    public void writeTo(OutputStream headerOs, OutputStream bodyOs, String[] ignoreList) throws IOException, MessagingException {
        this.writeTo(headerOs, bodyOs, ignoreList, false);
    }

    public synchronized void writeTo(OutputStream headerOs, OutputStream bodyOs, String[] ignoreList, boolean preLoad) throws IOException, MessagingException {
        if (!preLoad && this.source != null && !this.isBodyModified()) {
            try (InputStream in = this.source.getInputStream();){
                MailHeaders myHeaders;
                MailHeaders parsedHeaders = new MailHeaders(in);
                if (!this.isHeaderModified()) {
                    myHeaders = parsedHeaders;
                } else {
                    if (!this.saved) {
                        this.saveChanges();
                    }
                    myHeaders = this.headers;
                }
                Enumeration filteredHeaders = myHeaders.getNonMatchingHeaderLines(ignoreList);
                IOUtils.copy((InputStream)new InternetHeadersInputStream(filteredHeaders), (OutputStream)headerOs);
                IOUtils.copy((InputStream)in, (OutputStream)bodyOs);
            }
        } else {
            if (!this.saved) {
                this.saveChanges();
            }
            if (this.headers == null) {
                this.loadHeaders();
            }
            Enumeration filteredHeaders = this.headers.getNonMatchingHeaderLines(ignoreList);
            IOUtils.copy((InputStream)new InternetHeadersInputStream(filteredHeaders), (OutputStream)headerOs);
            if (preLoad && !this.messageParsed) {
                this.loadMessage();
            }
            MimeMessageUtil.writeMessageBodyTo(this, bodyOs);
        }
    }

    public synchronized int getSize() throws MessagingException {
        if (this.source != null) {
            try {
                long fullSize = this.source.getMessageSize();
                if (this.headers == null) {
                    this.loadHeaders();
                }
                return (int)(fullSize - this.initialHeaderSize - 2L);
            }
            catch (IOException e) {
                throw new MessagingException("Unable to calculate message size");
            }
        }
        if (!this.messageParsed) {
            this.loadMessage();
        }
        return super.getSize();
    }

    /*
     * Exception decompiling
     */
    public int getLineCount() throws MessagingException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private InputStreamReader builderReader(InputStream in) throws MessagingException, UnsupportedEncodingException {
        if (this.getEncoding() != null) {
            return new InputStreamReader(in, this.getEncoding());
        }
        return new InputStreamReader(in);
    }

    public long getMessageSize() throws MessagingException {
        if (this.source != null && !this.isModified()) {
            try {
                return this.source.getMessageSize();
            }
            catch (IOException ioe) {
                throw new MessagingException("Error retrieving message size", (Exception)ioe);
            }
        }
        return MimeMessageUtil.calculateMessageSize(this);
    }

    public String[] getHeader(String name) throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getHeader(name);
    }

    public String getHeader(String name, String delimiter) throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getHeader(name, delimiter);
    }

    public Enumeration<Header> getAllHeaders() throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getAllHeaders();
    }

    public Enumeration<Header> getMatchingHeaders(String[] names) throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getMatchingHeaders(names);
    }

    public Enumeration<Header> getNonMatchingHeaders(String[] names) throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getNonMatchingHeaders(names);
    }

    public Enumeration<String> getAllHeaderLines() throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getAllHeaderLines();
    }

    public Enumeration<String> getMatchingHeaderLines(String[] names) throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getMatchingHeaderLines(names);
    }

    public Enumeration<String> getNonMatchingHeaderLines(String[] names) throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getNonMatchingHeaderLines(names);
    }

    private synchronized void checkModifyHeaders() throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        this.modified = true;
        this.saved = false;
        this.headersModified = true;
    }

    public void setHeader(String name, String value) throws MessagingException {
        this.checkModifyHeaders();
        super.setHeader(name, value);
    }

    public void addHeader(String name, String value) throws MessagingException {
        this.checkModifyHeaders();
        super.addHeader(name, value);
    }

    public void removeHeader(String name) throws MessagingException {
        this.checkModifyHeaders();
        super.removeHeader(name);
    }

    public void addHeaderLine(String line) throws MessagingException {
        this.checkModifyHeaders();
        super.addHeaderLine(line);
    }

    public synchronized void setDataHandler(DataHandler arg0) throws MessagingException {
        this.modified = true;
        this.saved = false;
        this.bodyModified = true;
        super.setDataHandler(arg0);
    }

    public void dispose() {
        if (this.sourceIn != null) {
            try {
                this.sourceIn.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.source != null) {
            LifecycleUtil.dispose((Object)this.source);
        }
    }

    protected synchronized void parse(InputStream is) throws MessagingException {
        super.parse(is);
        this.messageParsed = true;
    }

    protected synchronized InternetHeaders createInternetHeaders(InputStream is) throws MessagingException {
        MailHeaders newHeaders = new MailHeaders(is);
        if (this.headers != null) {
            return this.headers;
        }
        this.initialHeaderSize = newHeaders.getSize();
        return newHeaders;
    }

    protected InputStream getContentStream() throws MessagingException {
        if (!this.messageParsed) {
            this.loadMessage();
        }
        return super.getContentStream();
    }

    public synchronized InputStream getRawInputStream() throws MessagingException {
        if (!this.messageParsed && !this.isModified() && this.source != null) {
            try {
                InputStream is = this.source.getInputStream();
                new MailHeaders(is);
                return is;
            }
            catch (IOException e) {
                throw new MessagingException("Unable to read the stream", (Exception)e);
            }
        }
        return super.getRawInputStream();
    }

    public synchronized InputStream getMessageInputStream() throws MessagingException {
        if (!this.messageParsed && !this.isModified() && this.source != null) {
            try {
                return this.source.getInputStream();
            }
            catch (IOException e) {
                throw new MessagingException("Unable to get inputstream", (Exception)e);
            }
        }
        try {
            if (!this.bodyModified && this.source != null) {
                InputStream in = this.source.getInputStream();
                new MailHeaders(in);
                return new SequenceInputStream(new InternetHeadersInputStream(this.getAllHeaderLines()), in);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.writeTo(out);
            return new ByteArrayInputStream(out.toByteArray());
        }
        catch (IOException e) {
            throw new MessagingException("Unable to get inputstream", (Exception)e);
        }
    }
}

