/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.server.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.mail.search.SearchTerm;
import org.apache.james.lifecycle.api.Disposable;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.server.core.MimeMessageSource;
import org.apache.james.server.core.MimeMessageUtil;
import org.apache.james.server.core.MimeMessageWrapper;

public class MimeMessageCopyOnWriteProxy
extends MimeMessage
implements Disposable {
    protected MessageReferenceTracker refCount;

    public MimeMessageCopyOnWriteProxy(MimeMessage original) throws MessagingException {
        this(original, false);
    }

    public MimeMessageCopyOnWriteProxy(MimeMessageSource original) throws MessagingException {
        this(new MimeMessageWrapper(original), true);
    }

    private MimeMessageCopyOnWriteProxy(MimeMessage original, boolean writeable) {
        super(Session.getDefaultInstance((Properties)System.getProperties(), null));
        this.refCount = original instanceof MimeMessageCopyOnWriteProxy ? ((MimeMessageCopyOnWriteProxy)original).refCount : new MessageReferenceTracker(original);
        if (!writeable) {
            this.refCount.incrementReferenceCount();
        }
    }

    protected synchronized MimeMessage getWrappedMessageForWriting() throws MessagingException {
        if (this.refCount.getReferenceCount() > 1) {
            this.refCount.decrementReferenceCount();
            this.refCount = new MessageReferenceTracker(new MimeMessageWrapper(this.refCount.getWrapped()));
        }
        return this.refCount.getWrapped();
    }

    public synchronized MimeMessage getWrappedMessage() {
        return this.refCount.getWrapped();
    }

    public synchronized void dispose() {
        if (this.refCount != null) {
            this.refCount.decrementReferenceCount();
            this.refCount = null;
        }
    }

    public void writeTo(OutputStream os) throws IOException, MessagingException {
        this.getWrappedMessage().writeTo(os);
    }

    public void writeTo(OutputStream os, String[] ignoreList) throws IOException, MessagingException {
        this.getWrappedMessage().writeTo(os, ignoreList);
    }

    public Address[] getFrom() throws MessagingException {
        return this.getWrappedMessage().getFrom();
    }

    public Address[] getRecipients(Message.RecipientType type) throws MessagingException {
        return this.getWrappedMessage().getRecipients(type);
    }

    public Address[] getAllRecipients() throws MessagingException {
        return this.getWrappedMessage().getAllRecipients();
    }

    public Address[] getReplyTo() throws MessagingException {
        return this.getWrappedMessage().getReplyTo();
    }

    public String getSubject() throws MessagingException {
        return this.getWrappedMessage().getSubject();
    }

    public Date getSentDate() throws MessagingException {
        return this.getWrappedMessage().getSentDate();
    }

    public Date getReceivedDate() throws MessagingException {
        return this.getWrappedMessage().getReceivedDate();
    }

    public int getSize() throws MessagingException {
        return this.getWrappedMessage().getSize();
    }

    public int getLineCount() throws MessagingException {
        return this.getWrappedMessage().getLineCount();
    }

    public String getContentType() throws MessagingException {
        return this.getWrappedMessage().getContentType();
    }

    public boolean isMimeType(String mimeType) throws MessagingException {
        return this.getWrappedMessage().isMimeType(mimeType);
    }

    public String getDisposition() throws MessagingException {
        return this.getWrappedMessage().getDisposition();
    }

    public String getEncoding() throws MessagingException {
        return this.getWrappedMessage().getEncoding();
    }

    public String getContentID() throws MessagingException {
        return this.getWrappedMessage().getContentID();
    }

    public String getContentMD5() throws MessagingException {
        return this.getWrappedMessage().getContentMD5();
    }

    public String getDescription() throws MessagingException {
        return this.getWrappedMessage().getDescription();
    }

    public String[] getContentLanguage() throws MessagingException {
        return this.getWrappedMessage().getContentLanguage();
    }

    public String getMessageID() throws MessagingException {
        return this.getWrappedMessage().getMessageID();
    }

    public String getFileName() throws MessagingException {
        return this.getWrappedMessage().getFileName();
    }

    public InputStream getInputStream() throws IOException, MessagingException {
        return this.getWrappedMessage().getInputStream();
    }

    public DataHandler getDataHandler() throws MessagingException {
        return this.getWrappedMessage().getDataHandler();
    }

    public Object getContent() throws IOException, MessagingException {
        return this.getWrappedMessage().getContent();
    }

    public String[] getHeader(String name) throws MessagingException {
        return this.getWrappedMessage().getHeader(name);
    }

    public String getHeader(String name, String delimiter) throws MessagingException {
        return this.getWrappedMessage().getHeader(name, delimiter);
    }

    public Enumeration<Header> getAllHeaders() throws MessagingException {
        return this.getWrappedMessage().getAllHeaders();
    }

    public Enumeration<Header> getMatchingHeaders(String[] names) throws MessagingException {
        return this.getWrappedMessage().getMatchingHeaders(names);
    }

    public Enumeration<Header> getNonMatchingHeaders(String[] names) throws MessagingException {
        return this.getWrappedMessage().getNonMatchingHeaders(names);
    }

    public Enumeration<String> getAllHeaderLines() throws MessagingException {
        return this.getWrappedMessage().getAllHeaderLines();
    }

    public Enumeration<String> getMatchingHeaderLines(String[] names) throws MessagingException {
        return this.getWrappedMessage().getMatchingHeaderLines(names);
    }

    public Enumeration<String> getNonMatchingHeaderLines(String[] names) throws MessagingException {
        return this.getWrappedMessage().getNonMatchingHeaderLines(names);
    }

    public Flags getFlags() throws MessagingException {
        return this.getWrappedMessage().getFlags();
    }

    public boolean isSet(Flags.Flag flag) throws MessagingException {
        return this.getWrappedMessage().isSet(flag);
    }

    public Address getSender() throws MessagingException {
        return this.getWrappedMessage().getSender();
    }

    public boolean match(SearchTerm arg0) throws MessagingException {
        return this.getWrappedMessage().match(arg0);
    }

    public InputStream getRawInputStream() throws MessagingException {
        return this.getWrappedMessage().getRawInputStream();
    }

    public Folder getFolder() {
        return this.getWrappedMessage().getFolder();
    }

    public int getMessageNumber() {
        return this.getWrappedMessage().getMessageNumber();
    }

    public boolean isExpunged() {
        return this.getWrappedMessage().isExpunged();
    }

    public boolean equals(Object arg0) {
        return this.getWrappedMessage().equals(arg0);
    }

    public int hashCode() {
        return this.getWrappedMessage().hashCode();
    }

    public String toString() {
        return this.getWrappedMessage().toString();
    }

    public void setFrom(Address address) throws MessagingException {
        this.getWrappedMessageForWriting().setFrom(address);
    }

    public void setFrom() throws MessagingException {
        this.getWrappedMessageForWriting().setFrom();
    }

    public void addFrom(Address[] addresses) throws MessagingException {
        this.getWrappedMessageForWriting().addFrom(addresses);
    }

    public void setRecipients(Message.RecipientType type, Address[] addresses) throws MessagingException {
        this.getWrappedMessageForWriting().setRecipients(type, addresses);
    }

    public void addRecipients(Message.RecipientType type, Address[] addresses) throws MessagingException {
        this.getWrappedMessageForWriting().addRecipients(type, addresses);
    }

    public void setReplyTo(Address[] addresses) throws MessagingException {
        this.getWrappedMessageForWriting().setReplyTo(addresses);
    }

    public void setSubject(String subject) throws MessagingException {
        this.getWrappedMessageForWriting().setSubject(subject);
    }

    public void setSubject(String subject, String charset) throws MessagingException {
        this.getWrappedMessageForWriting().setSubject(subject, charset);
    }

    public void setSentDate(Date d) throws MessagingException {
        this.getWrappedMessageForWriting().setSentDate(d);
    }

    public void setDisposition(String disposition) throws MessagingException {
        this.getWrappedMessageForWriting().setDisposition(disposition);
    }

    public void setContentID(String cid) throws MessagingException {
        this.getWrappedMessageForWriting().setContentID(cid);
    }

    public void setContentMD5(String md5) throws MessagingException {
        this.getWrappedMessageForWriting().setContentMD5(md5);
    }

    public void setDescription(String description) throws MessagingException {
        this.getWrappedMessageForWriting().setDescription(description);
    }

    public void setDescription(String description, String charset) throws MessagingException {
        this.getWrappedMessageForWriting().setDescription(description, charset);
    }

    public void setContentLanguage(String[] languages) throws MessagingException {
        this.getWrappedMessageForWriting().setContentLanguage(languages);
    }

    public void setFileName(String filename) throws MessagingException {
        this.getWrappedMessageForWriting().setFileName(filename);
    }

    public void setDataHandler(DataHandler dh) throws MessagingException {
        this.getWrappedMessageForWriting().setDataHandler(dh);
    }

    public void setContent(Object o, String type) throws MessagingException {
        this.getWrappedMessageForWriting().setContent(o, type);
    }

    public void setText(String text) throws MessagingException {
        this.getWrappedMessageForWriting().setText(text);
    }

    public void setText(String text, String charset) throws MessagingException {
        this.getWrappedMessageForWriting().setText(text, charset);
    }

    public void setContent(Multipart mp) throws MessagingException {
        this.getWrappedMessageForWriting().setContent(mp);
    }

    public Message reply(boolean replyToAll) throws MessagingException {
        return this.getWrappedMessage().reply(replyToAll);
    }

    public void setHeader(String name, String value) throws MessagingException {
        this.getWrappedMessageForWriting().setHeader(name, value);
    }

    public void addHeader(String name, String value) throws MessagingException {
        this.getWrappedMessageForWriting().addHeader(name, value);
    }

    public void removeHeader(String name) throws MessagingException {
        this.getWrappedMessageForWriting().removeHeader(name);
    }

    public void addHeaderLine(String line) throws MessagingException {
        this.getWrappedMessageForWriting().addHeaderLine(line);
    }

    public void setFlags(Flags flag, boolean set) throws MessagingException {
        this.getWrappedMessageForWriting().setFlags(flag, set);
    }

    public void saveChanges() throws MessagingException {
        this.getWrappedMessageForWriting().saveChanges();
    }

    public void addRecipients(Message.RecipientType type, String addresses) throws MessagingException {
        this.getWrappedMessageForWriting().addRecipients(type, addresses);
    }

    public void setRecipients(Message.RecipientType type, String addresses) throws MessagingException {
        this.getWrappedMessageForWriting().setRecipients(type, addresses);
    }

    public void setSender(Address arg0) throws MessagingException {
        this.getWrappedMessageForWriting().setSender(arg0);
    }

    public void addRecipient(MimeMessage.RecipientType arg0, Address arg1) throws MessagingException {
        this.getWrappedMessageForWriting().addRecipient((Message.RecipientType)arg0, arg1);
    }

    public void setFlag(Flags.Flag arg0, boolean arg1) throws MessagingException {
        this.getWrappedMessageForWriting().setFlag(arg0, arg1);
    }

    public long getMessageSize() throws MessagingException {
        return MimeMessageUtil.getMessageSize(this.getWrappedMessage());
    }

    public void setText(String text, String charset, String subtype) throws MessagingException {
        this.getWrappedMessage().setText(text, charset, subtype);
    }

    protected static class MessageReferenceTracker {
        private int referenceCount = 1;
        private MimeMessage wrapped = null;

        public MessageReferenceTracker(MimeMessage ref) {
            this.wrapped = ref;
        }

        protected synchronized void incrementReferenceCount() {
            ++this.referenceCount;
        }

        protected synchronized void decrementReferenceCount() {
            --this.referenceCount;
            if (this.referenceCount <= 0) {
                LifecycleUtil.dispose((Object)this.wrapped);
                this.wrapped = null;
            }
        }

        protected synchronized int getReferenceCount() {
            return this.referenceCount;
        }

        public synchronized MimeMessage getWrapped() {
            return this.wrapped;
        }
    }
}

