/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.utils;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FixedLengthInputStream
extends FilterInputStream {
    private long pos = 0L;
    private final long length;

    public FixedLengthInputStream(InputStream in, long length) {
        super(in);
        this.length = length;
    }

    @Override
    public int read() throws IOException {
        if (this.pos >= this.length) {
            return -1;
        }
        ++this.pos;
        return super.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.pos >= this.length) {
            return -1;
        }
        if (this.pos + (long)len >= this.length) {
            int readLimit = (int)this.length - (int)this.pos;
            this.pos = this.length;
            return super.read(b, off, readLimit);
        }
        int i = super.read(b, off, len);
        this.pos += (long)i;
        return i;
    }

    @Override
    public long skip(long n) throws IOException {
        throw new IOException("Not implemented");
    }

    @Override
    public int available() throws IOException {
        return (int)(this.length - this.pos);
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("mark not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

