/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor.fetch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Header;

public class MessageResultUtils {
    public static List<Header> getAll(Iterator<Header> iterator) {
        ArrayList<Header> results = new ArrayList<Header>();
        if (iterator != null) {
            while (iterator.hasNext()) {
                results.add(iterator.next());
            }
        }
        return results;
    }

    public static List<Header> getMatching(String[] names, Iterator<Header> iterator) throws MailboxException {
        ArrayList<Header> results = new ArrayList<Header>(20);
        if (iterator != null) {
            while (iterator.hasNext()) {
                Header header = iterator.next();
                String headerName = header.getName();
                if (headerName == null) continue;
                if (!Arrays.stream(names).anyMatch(headerName::equalsIgnoreCase)) continue;
                results.add(header);
            }
        }
        return results;
    }

    public static List<Header> getMatching(Collection<String> names, Iterator<Header> iterator) throws MailboxException {
        return MessageResultUtils.matching(names, iterator, false);
    }

    private static List<Header> matching(Collection<String> names, Iterator<Header> iterator, boolean not) throws MailboxException {
        ArrayList<Header> results = new ArrayList<Header>(names.size());
        if (iterator != null) {
            while (iterator.hasNext()) {
                Header header = iterator.next();
                boolean match = MessageResultUtils.contains(names, header);
                boolean add = not && !match || !not && match;
                if (!add) continue;
                results.add(header);
            }
        }
        return results;
    }

    private static boolean contains(Collection<String> names, Header header) throws MailboxException {
        String headerName = header.getName();
        if (headerName != null) {
            return names.stream().anyMatch(name -> name.equalsIgnoreCase(headerName));
        }
        return false;
    }

    public static List<Header> getNotMatching(Collection<String> names, Iterator<Header> iterator) throws MailboxException {
        return MessageResultUtils.matching(names, iterator, true);
    }

    public static Header getMatching(String name, Iterator<Header> iterator) throws MailboxException {
        Header result = null;
        if (name != null) {
            while (iterator.hasNext()) {
                Header header = iterator.next();
                String headerName = header.getName();
                if (!name.equalsIgnoreCase(headerName)) continue;
                result = header;
                break;
            }
        }
        return result;
    }

    public static List<Header> getNotMatching(String[] names, Iterator<Header> iterator) throws MailboxException {
        ArrayList<Header> results = new ArrayList<Header>(20);
        if (iterator != null) {
            while (iterator.hasNext()) {
                Header header = iterator.next();
                String headerName = header.getName();
                if (headerName == null) continue;
                boolean match = Arrays.stream(names).anyMatch(headerName::equalsIgnoreCase);
                if (match) continue;
                results.add(header);
            }
        }
        return results;
    }
}

