/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor.fetch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.mail.Flags;
import org.apache.james.imap.api.message.BodyFetchElement;
import org.apache.james.imap.api.message.FetchData;
import org.apache.james.imap.api.message.SectionType;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imap.message.response.FetchResponse;
import org.apache.james.imap.processor.fetch.ContentBodyElement;
import org.apache.james.imap.processor.fetch.EmptyContent;
import org.apache.james.imap.processor.fetch.EnvelopeBuilder;
import org.apache.james.imap.processor.fetch.HeaderBodyElement;
import org.apache.james.imap.processor.fetch.HeadersBodyElement;
import org.apache.james.imap.processor.fetch.MessageResultUtils;
import org.apache.james.imap.processor.fetch.MimeBodyElement;
import org.apache.james.imap.processor.fetch.MimeDescriptorStructure;
import org.apache.james.imap.processor.fetch.PartialFetchBodyElement;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MessageRangeException;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.Header;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mailbox.model.MimePath;

public final class FetchResponseBuilder {
    private final EnvelopeBuilder envelopeBuilder;
    private int msn;
    private MessageUid uid;
    private Flags flags;
    private Date internalDate;
    private Long size;
    private ModSeq modSeq;
    private List<FetchResponse.BodyElement> elements;
    private FetchResponse.Envelope envelope;
    private FetchResponse.Structure body;
    private FetchResponse.Structure bodystructure;

    public FetchResponseBuilder(EnvelopeBuilder envelopeBuilder) {
        this.envelopeBuilder = envelopeBuilder;
    }

    public void reset(int msn) {
        this.msn = msn;
        this.uid = null;
        this.flags = null;
        this.internalDate = null;
        this.size = null;
        this.body = null;
        this.bodystructure = null;
        this.elements = null;
        this.modSeq = null;
    }

    public void setUid(MessageUid resultUid) {
        this.uid = resultUid;
    }

    private void setModSeq(ModSeq modSeq) {
        this.modSeq = modSeq;
    }

    public void setFlags(Flags flags) {
        this.flags = flags;
    }

    public FetchResponse build() {
        return new FetchResponse(this.msn, this.flags, this.uid, this.modSeq, this.internalDate, this.size, this.envelope, this.body, this.bodystructure, this.elements);
    }

    public FetchResponse build(FetchData fetch, MessageResult result, MessageManager mailbox, ImapSession session, boolean useUids) throws MessageRangeException, MailboxException {
        MessageUid resultUid;
        SelectedMailbox selected = session.getSelected();
        int resultMsn = selected.msn(resultUid = result.getUid());
        if (resultMsn == -1) {
            throw new MessageRangeException("No such message found with uid " + resultUid);
        }
        this.reset(resultMsn);
        MailboxSession mailboxSession = session.getMailboxSession();
        boolean ensureFlagsResponse = false;
        Flags resultFlags = result.getFlags();
        if (fetch.isSetSeen() && !resultFlags.contains(Flags.Flag.SEEN)) {
            mailbox.setFlags(new Flags(Flags.Flag.SEEN), MessageManager.FlagsUpdateMode.ADD, MessageRange.one((MessageUid)resultUid), mailboxSession);
            resultFlags.add(Flags.Flag.SEEN);
            ensureFlagsResponse = true;
        }
        if (fetch.contains(FetchData.Item.FLAGS) || ensureFlagsResponse) {
            if (selected.isRecent(resultUid)) {
                resultFlags.add(Flags.Flag.RECENT);
            }
            this.setFlags(resultFlags);
        }
        if (fetch.contains(FetchData.Item.INTERNAL_DATE)) {
            this.setInternalDate(result.getInternalDate());
        }
        if (fetch.contains(FetchData.Item.SIZE)) {
            this.setSize(result.getSize());
        }
        if (fetch.contains(FetchData.Item.ENVELOPE)) {
            this.envelope = this.buildEnvelope(result);
        }
        Collection<BodyFetchElement> elements = fetch.getBodyElements();
        this.elements = new ArrayList<FetchResponse.BodyElement>();
        for (BodyFetchElement fetchElement : elements) {
            FetchResponse.BodyElement element = this.bodyFetch(result, fetchElement);
            if (element == null) continue;
            this.elements.add(element);
        }
        if (fetch.contains(FetchData.Item.BODY) || fetch.contains(FetchData.Item.BODY_STRUCTURE)) {
            if (fetch.contains(FetchData.Item.BODY) && this.elements.isEmpty()) {
                this.body = new MimeDescriptorStructure(false, result.getMimeDescriptor(), this.envelopeBuilder);
            }
            if (fetch.contains(FetchData.Item.BODY_STRUCTURE)) {
                this.bodystructure = new MimeDescriptorStructure(true, result.getMimeDescriptor(), this.envelopeBuilder);
            }
        }
        if (fetch.contains(FetchData.Item.UID)) {
            this.setUid(resultUid);
        }
        if (fetch.contains(FetchData.Item.MODSEQ)) {
            long changedSince = fetch.getChangedSince();
            if (changedSince != -1L) {
                if (changedSince < result.getModSeq().asLong()) {
                    this.setModSeq(result.getModSeq());
                }
            } else {
                this.setModSeq(result.getModSeq());
            }
        }
        return this.build();
    }

    private FetchResponse.Envelope buildEnvelope(MessageResult result) throws MailboxException {
        return this.envelopeBuilder.buildEnvelope(result.getHeaders());
    }

    private void setSize(long size) {
        this.size = size;
    }

    public void setInternalDate(Date internalDate) {
        this.internalDate = internalDate;
    }

    private FetchResponse.BodyElement bodyFetch(MessageResult messageResult, BodyFetchElement fetchElement) throws MailboxException {
        Long firstOctet = fetchElement.getFirstOctet();
        Long numberOfOctets = fetchElement.getNumberOfOctets();
        String name = fetchElement.getResponseName();
        SectionType specifier = fetchElement.getSectionType();
        int[] path = fetchElement.getPath();
        Collection<String> names = fetchElement.getFieldNames();
        boolean isBase = path == null || path.length == 0;
        FetchResponse.BodyElement fullResult = this.bodyContent(messageResult, name, specifier, path, names, isBase);
        return this.wrapIfPartialFetch(firstOctet, numberOfOctets, fullResult);
    }

    private FetchResponse.BodyElement bodyContent(MessageResult messageResult, String name, SectionType specifier, int[] path, Collection<String> names, boolean isBase) throws MailboxException {
        switch (specifier) {
            case CONTENT: {
                return this.content(messageResult, name, path, isBase);
            }
            case HEADER_FIELDS: {
                return this.fields(messageResult, name, path, names, isBase);
            }
            case HEADER_NOT_FIELDS: {
                return this.fieldsNot(messageResult, name, path, names, isBase);
            }
            case MIME: {
                return this.mimeHeaders(messageResult, name, path, isBase);
            }
            case HEADER: {
                return this.headers(messageResult, name, path, isBase);
            }
            case TEXT: {
                return this.text(messageResult, name, path, isBase);
            }
        }
        return null;
    }

    private FetchResponse.BodyElement wrapIfPartialFetch(Long firstOctet, Long numberOfOctets, FetchResponse.BodyElement fullResult) {
        FetchResponse.BodyElement result;
        if (firstOctet == null) {
            result = fullResult;
        } else {
            long numberOfOctetsAsLong = numberOfOctets == null ? Long.MAX_VALUE : numberOfOctets;
            long firstOctetAsLong = firstOctet;
            result = new PartialFetchBodyElement(fullResult, firstOctetAsLong, numberOfOctetsAsLong);
        }
        return result;
    }

    private FetchResponse.BodyElement text(MessageResult messageResult, String name, int[] path, boolean isBase) throws MailboxException {
        Content body;
        if (isBase) {
            try {
                body = messageResult.getBody();
            }
            catch (IOException e) {
                throw new MailboxException("Unable to get TEXT of body", (Throwable)e);
            }
        } else {
            MimePath mimePath = new MimePath(path);
            body = messageResult.getBody(mimePath);
        }
        if (body == null) {
            body = new EmptyContent();
        }
        ContentBodyElement result = new ContentBodyElement(name, body);
        return result;
    }

    private FetchResponse.BodyElement mimeHeaders(MessageResult messageResult, String name, int[] path, boolean isBase) throws MailboxException {
        Iterator<Header> headers = this.getMimeHeaders(messageResult, path, isBase);
        List<Header> lines = MessageResultUtils.getAll(headers);
        MimeBodyElement result = new MimeBodyElement(name, lines);
        return result;
    }

    private HeaderBodyElement headerBodyElement(MessageResult messageResult, String name, List<Header> lines, int[] path, boolean isBase) throws MailboxException {
        HeaderBodyElement result = new HeaderBodyElement(name, lines);
        if (result.size() == 2L) {
            if (isBase) {
                if (messageResult.getSize() - result.size() <= 0L) {
                    result.noBody();
                }
            } else {
                try {
                    if (this.content(messageResult, name, path, isBase).size() <= 0L) {
                        result.noBody();
                    }
                }
                catch (IOException e) {
                    throw new MailboxException("Unable to get size of header body element", (Throwable)e);
                }
            }
        }
        return result;
    }

    private FetchResponse.BodyElement headers(MessageResult messageResult, String name, int[] path, boolean isBase) throws MailboxException {
        if (isBase) {
            HeadersBodyElement element = new HeadersBodyElement(name, (Content)messageResult.getHeaders());
            try {
                if (messageResult.getSize() - element.size() <= 0L) {
                    element.noBody();
                }
            }
            catch (IOException e) {
                throw new MailboxException("Unable to get size of header body element", (Throwable)e);
            }
            return element;
        }
        Iterator<Header> headers = this.getHeaders(messageResult, path, isBase);
        List<Header> lines = MessageResultUtils.getAll(headers);
        return this.headerBodyElement(messageResult, name, lines, path, isBase);
    }

    private FetchResponse.BodyElement fieldsNot(MessageResult messageResult, String name, int[] path, Collection<String> names, boolean isBase) throws MailboxException {
        Iterator<Header> headers = this.getHeaders(messageResult, path, isBase);
        List<Header> lines = MessageResultUtils.getNotMatching(names, headers);
        return this.headerBodyElement(messageResult, name, lines, path, isBase);
    }

    private FetchResponse.BodyElement fields(MessageResult messageResult, String name, int[] path, Collection<String> names, boolean isBase) throws MailboxException {
        Iterator<Header> headers = this.getHeaders(messageResult, path, isBase);
        List<Header> lines = MessageResultUtils.getMatching(names, headers);
        return this.headerBodyElement(messageResult, name, lines, path, isBase);
    }

    private Iterator<Header> getHeaders(MessageResult messageResult, int[] path, boolean isBase) throws MailboxException {
        Iterator headers;
        if (isBase) {
            headers = messageResult.getHeaders().headers();
        } else {
            MimePath mimePath = new MimePath(path);
            headers = messageResult.iterateHeaders(mimePath);
        }
        return headers;
    }

    private Iterator<Header> getMimeHeaders(MessageResult messageResult, int[] path, boolean isBase) throws MailboxException {
        MimePath mimePath = new MimePath(path);
        return messageResult.iterateMimeHeaders(mimePath);
    }

    private FetchResponse.BodyElement content(MessageResult messageResult, String name, int[] path, boolean isBase) throws MailboxException {
        Content full;
        if (isBase) {
            try {
                full = messageResult.getFullContent();
            }
            catch (IOException e) {
                throw new MailboxException("Unable to get content", (Throwable)e);
            }
        } else {
            MimePath mimePath = new MimePath(path);
            full = messageResult.getMimeBody(mimePath);
        }
        if (full == null) {
            full = new EmptyContent();
        }
        ContentBodyElement result = new ContentBodyElement(name, full);
        return result;
    }
}

