/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor.fetch;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.FetchData;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.message.request.FetchRequest;
import org.apache.james.imap.message.response.FetchResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.EnableProcessor;
import org.apache.james.imap.processor.fetch.EnvelopeBuilder;
import org.apache.james.imap.processor.fetch.FetchDataConverter;
import org.apache.james.imap.processor.fetch.FetchResponseBuilder;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MessageRangeException;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mailbox.model.MessageResultIterator;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchProcessor
extends AbstractMailboxProcessor<FetchRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FetchProcessor.class);

    public FetchProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(FetchRequest.class, next, mailboxManager, factory, metricFactory);
    }

    @Override
    protected void processRequest(FetchRequest request, ImapSession session, ImapProcessor.Responder responder) {
        boolean useUids = request.isUseUids();
        IdRange[] idSet = request.getIdSet();
        FetchData fetch = this.computeFetchData(request, session);
        try {
            long changedSince = fetch.getChangedSince();
            MessageManager mailbox = this.getSelectedMailbox(session);
            if (mailbox == null) {
                throw new MailboxException("Session not in SELECTED state");
            }
            boolean vanished = fetch.getVanished();
            if (vanished && !EnableProcessor.getEnabledCapabilities(session).contains(ImapConstants.SUPPORTS_QRESYNC)) {
                this.taggedBad(request, responder, HumanReadableText.QRESYNC_NOT_ENABLED);
                return;
            }
            if (vanished && changedSince == -1L) {
                this.taggedBad(request, responder, HumanReadableText.QRESYNC_VANISHED_WITHOUT_CHANGEDSINCE);
                return;
            }
            MailboxSession mailboxSession = session.getMailboxSession();
            MessageManager.MetaData metaData = mailbox.getMetaData(false, mailboxSession, MessageManager.MetaData.FetchGroup.NO_COUNT);
            if (fetch.getChangedSince() != -1L || fetch.contains(FetchData.Item.MODSEQ)) {
                this.condstoreEnablingCommand(session, responder, metaData, true);
            }
            ArrayList<MessageRange> ranges = new ArrayList<MessageRange>();
            for (IdRange range : idSet) {
                MessageRange messageSet = this.messageRange(session.getSelected(), range, useUids);
                if (messageSet == null) continue;
                MessageRange normalizedMessageSet = this.normalizeMessageRange(session.getSelected(), messageSet);
                MessageRange batchedMessageSet = MessageRange.range((MessageUid)normalizedMessageSet.getUidFrom(), (MessageUid)normalizedMessageSet.getUidTo());
                ranges.add(batchedMessageSet);
            }
            if (vanished) {
                this.respondVanished(mailboxSession, mailbox, ranges, changedSince, metaData, responder);
            }
            this.processMessageRanges(session, mailbox, ranges, fetch, useUids, mailboxSession, responder);
            boolean omitExpunged = !useUids;
            this.unsolicitedResponses(session, responder, omitExpunged, useUids);
            this.okComplete(request, responder);
        }
        catch (MessageRangeException e) {
            LOGGER.debug("Fetch failed for mailbox {} because of invalid sequence-set {}", new Object[]{session.getSelected().getMailboxId(), idSet, e});
            this.taggedBad(request, responder, HumanReadableText.INVALID_MESSAGESET);
        }
        catch (MailboxException e) {
            LOGGER.error("Fetch failed for mailbox {} and sequence-set {}", new Object[]{session.getSelected().getMailboxId(), idSet, e});
            this.no(request, responder, HumanReadableText.SEARCH_FAILED);
        }
    }

    private FetchData computeFetchData(FetchRequest request, ImapSession session) {
        if (EnableProcessor.getEnabledCapabilities(session).contains(ImapConstants.SUPPORTS_QRESYNC)) {
            return FetchData.Builder.from(request.getFetch()).fetch(FetchData.Item.UID).build();
        }
        return request.getFetch();
    }

    private void processMessageRanges(ImapSession session, MessageManager mailbox, List<MessageRange> ranges, FetchData fetch, boolean useUids, MailboxSession mailboxSession, ImapProcessor.Responder responder) throws MailboxException {
        FetchResponseBuilder builder = new FetchResponseBuilder(new EnvelopeBuilder());
        FetchGroup resultToFetch = FetchDataConverter.getFetchGroup(fetch);
        for (MessageRange range : ranges) {
            MessageResultIterator messages = mailbox.getMessages(range, resultToFetch, mailboxSession);
            while (messages.hasNext()) {
                MessageResult result = (MessageResult)messages.next();
                if (fetch.contains(FetchData.Item.MODSEQ) && result.getModSeq().asLong() <= fetch.getChangedSince()) continue;
                try {
                    FetchResponse response = builder.build(fetch, result, mailbox, session, useUids);
                    responder.respond(response);
                }
                catch (MessageRangeException e) {
                    LOGGER.debug("Unable to find message with uid {}", (Object)result.getUid(), (Object)e);
                }
                catch (MailboxException e) {
                    LOGGER.error("Unable to fetch message with uid {}, so skip it", (Object)result.getUid(), (Object)e);
                }
            }
            if (messages.getException() == null) continue;
            throw messages.getException();
        }
    }

    @Override
    protected Closeable addContextToMDC(FetchRequest request) {
        return MDCBuilder.create().addContext("action", (Object)"FETCH").addContext("useUid", (Object)request.isUseUids()).addContext("idSet", (Object)IdRange.toString(request.getIdSet())).addContext("fetchedData", (Object)request.getFetch()).build();
    }
}

