/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor.fetch;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.mail.internet.MimeUtility;
import org.apache.james.imap.message.response.FetchResponse;
import org.apache.james.imap.processor.fetch.AddressImpl;
import org.apache.james.imap.processor.fetch.EnvelopeImpl;
import org.apache.james.imap.processor.fetch.MessageResultUtils;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Header;
import org.apache.james.mailbox.model.Headers;
import org.apache.james.mime4j.codec.EncoderUtil;
import org.apache.james.mime4j.dom.address.Address;
import org.apache.james.mime4j.dom.address.AddressList;
import org.apache.james.mime4j.dom.address.DomainList;
import org.apache.james.mime4j.dom.address.Group;
import org.apache.james.mime4j.dom.address.Mailbox;
import org.apache.james.mime4j.dom.address.MailboxList;
import org.apache.james.mime4j.field.address.LenientAddressParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EnvelopeBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnvelopeBuilder.class);

    public FetchResponse.Envelope buildEnvelope(Headers headers) throws MailboxException {
        String date = this.headerValue(headers, "Date");
        String subject = this.headerValue(headers, "Subject");
        FetchResponse.Envelope.Address[] fromAddresses = this.buildAddresses(headers, "From");
        FetchResponse.Envelope.Address[] senderAddresses = this.buildAddresses(headers, "Sender", fromAddresses);
        FetchResponse.Envelope.Address[] replyToAddresses = this.buildAddresses(headers, "Reply-To", fromAddresses);
        FetchResponse.Envelope.Address[] toAddresses = this.buildAddresses(headers, "To");
        FetchResponse.Envelope.Address[] ccAddresses = this.buildAddresses(headers, "Cc");
        FetchResponse.Envelope.Address[] bccAddresses = this.buildAddresses(headers, "Bcc");
        String inReplyTo = this.headerValue(headers, "In-Reply-To");
        String messageId = this.headerValue(headers, "Message-ID");
        return new EnvelopeImpl(date, subject, fromAddresses, senderAddresses, replyToAddresses, toAddresses, ccAddresses, bccAddresses, inReplyTo, messageId);
    }

    private String headerValue(Headers message, String headerName) throws MailboxException {
        String value;
        Header header = MessageResultUtils.getMatching(headerName, (Iterator<Header>)message.headers());
        String result = header == null ? null : ((value = header.getValue()) == null || "".equals(value) ? null : MimeUtility.unfold((String)value));
        return result;
    }

    private FetchResponse.Envelope.Address[] buildAddresses(Headers message, String headerName, FetchResponse.Envelope.Address[] defaults) throws MailboxException {
        FetchResponse.Envelope.Address[] addresses = this.buildAddresses(message, headerName);
        FetchResponse.Envelope.Address[] results = addresses == null ? defaults : addresses;
        return results;
    }

    private FetchResponse.Envelope.Address[] buildAddresses(Headers message, String headerName) throws MailboxException {
        FetchResponse.Envelope.Address[] results;
        Header header = MessageResultUtils.getMatching(headerName, (Iterator<Header>)message.headers());
        if (header == null) {
            results = null;
        } else {
            String value = MimeUtility.unfold((String)header.getValue());
            if ("".equals(value.trim())) {
                results = null;
            } else {
                AddressList addressList = LenientAddressParser.DEFAULT.parseAddressList((CharSequence)value);
                int size = addressList.size();
                ArrayList<FetchResponse.Envelope.Address> addresses = new ArrayList<FetchResponse.Envelope.Address>(size);
                for (Address address : addressList) {
                    if (address instanceof Group) {
                        Group group = (Group)address;
                        this.addAddresses(group, addresses);
                        continue;
                    }
                    if (address instanceof Mailbox) {
                        Mailbox mailbox = (Mailbox)address;
                        FetchResponse.Envelope.Address mailboxAddress = this.buildMailboxAddress(mailbox);
                        addresses.add(mailboxAddress);
                        continue;
                    }
                    LOGGER.warn("Unknown address type {}", address.getClass());
                }
                results = addresses.toArray(FetchResponse.Envelope.Address.EMPTY);
            }
        }
        return results;
    }

    private FetchResponse.Envelope.Address buildMailboxAddress(Mailbox mailbox) {
        String name = mailbox.getName();
        if (name != null) {
            name = EncoderUtil.encodeAddressDisplayName((String)name);
        }
        String domain = mailbox.getDomain();
        DomainList route = mailbox.getRoute();
        String atDomainList = route == null || route.size() == 0 ? null : route.toRouteString();
        String localPart = mailbox.getLocalPart();
        return this.buildMailboxAddress(name, atDomainList, localPart, domain);
    }

    private void addAddresses(Group group, List<FetchResponse.Envelope.Address> addresses) {
        String groupName = group.getName();
        FetchResponse.Envelope.Address start = this.startGroup(groupName);
        addresses.add(start);
        MailboxList mailboxList = group.getMailboxes();
        for (Mailbox mailbox : mailboxList) {
            FetchResponse.Envelope.Address address = this.buildMailboxAddress(mailbox);
            addresses.add(address);
        }
        FetchResponse.Envelope.Address end = this.endGroup();
        addresses.add(end);
    }

    private FetchResponse.Envelope.Address startGroup(String groupName) {
        return new AddressImpl(null, null, groupName, null);
    }

    private FetchResponse.Envelope.Address endGroup() {
        return new AddressImpl(null, null, null, null);
    }

    private FetchResponse.Envelope.Address buildMailboxAddress(String name, String atDomainList, String mailbox, String domain) {
        return new AddressImpl(atDomainList, domain, mailbox, name);
    }
}

