/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor.base;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import org.apache.james.mailbox.MessageUid;

public class UidMsnConverter {
    public static final int FIRST_MSN = 1;
    @VisibleForTesting
    final ArrayList<MessageUid> uids = Lists.newArrayList();

    public synchronized void addAll(List<MessageUid> addedUids) {
        TreeSet<MessageUid> tmp = new TreeSet<MessageUid>();
        tmp.addAll(this.uids);
        tmp.addAll(addedUids);
        this.uids.clear();
        this.uids.addAll(tmp);
    }

    public synchronized Optional<Integer> getMsn(MessageUid uid) {
        int position = Collections.binarySearch(this.uids, uid);
        if (position < 0) {
            return Optional.empty();
        }
        return Optional.of(position + 1);
    }

    public synchronized Optional<MessageUid> getUid(int msn) {
        if (msn <= this.uids.size() && msn > 0) {
            return Optional.of(this.uids.get(msn - 1));
        }
        return Optional.empty();
    }

    public synchronized Optional<MessageUid> getLastUid() {
        if (this.uids.isEmpty()) {
            return Optional.empty();
        }
        return this.getUid(this.getLastMsn());
    }

    public synchronized Optional<MessageUid> getFirstUid() {
        return this.getUid(1);
    }

    public synchronized int getNumMessage() {
        return this.uids.size();
    }

    public synchronized void remove(MessageUid uid) {
        this.uids.remove(uid);
    }

    public synchronized boolean isEmpty() {
        return this.uids.isEmpty();
    }

    public synchronized void clear() {
        this.uids.clear();
    }

    public synchronized void addUid(MessageUid uid) {
        if (this.uids.contains(uid)) {
            return;
        }
        if (this.isLastUid(uid)) {
            this.uids.add(uid);
        } else {
            this.uids.add(uid);
            Collections.sort(this.uids);
        }
    }

    private boolean isLastUid(MessageUid uid) {
        Optional<MessageUid> lastUid = this.getLastUid();
        return !lastUid.isPresent() || lastUid.get().compareTo(uid) < 0;
    }

    private int getLastMsn() {
        return this.getNumMessage();
    }
}

