/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.Capability;
import org.apache.james.imap.api.message.request.ImapRequest;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.message.request.EnableRequest;
import org.apache.james.imap.message.response.EnableResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.imap.processor.CapabilityProcessor;
import org.apache.james.imap.processor.PermitEnableCapabilityProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnableProcessor
extends AbstractMailboxProcessor<EnableRequest>
implements CapabilityImplementingProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnableProcessor.class);
    private static final List<PermitEnableCapabilityProcessor> capabilities = new ArrayList<PermitEnableCapabilityProcessor>();
    public static final String ENABLED_CAPABILITIES = "ENABLED_CAPABILITIES";
    private static final List<Capability> CAPS = ImmutableList.of((Object)ImapConstants.SUPPORTS_ENABLE);
    private final CapabilityProcessor capabilityProcessor;

    public EnableProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, List<PermitEnableCapabilityProcessor> capabilities, MetricFactory metricFactory, CapabilityProcessor capabilityProcessor) {
        this(next, mailboxManager, factory, metricFactory, capabilityProcessor);
        EnableProcessor.capabilities.addAll(capabilities);
    }

    public EnableProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory, CapabilityProcessor capabilityProcessor) {
        super(EnableRequest.class, next, mailboxManager, factory, metricFactory);
        this.capabilityProcessor = capabilityProcessor;
    }

    @Override
    protected void processRequest(EnableRequest request, ImapSession session, ImapProcessor.Responder responder) {
        try {
            List<Capability> caps = request.getCapabilities();
            Set<Capability> enabledCaps = this.enable(request, responder, session, caps.iterator());
            responder.respond(new EnableResponse(enabledCaps));
            this.unsolicitedResponses(session, responder, false);
            this.okComplete(request, responder);
        }
        catch (PermitEnableCapabilityProcessor.EnableException e) {
            LOGGER.info("Unable to enable extension", (Throwable)e);
            this.taggedBad(request, responder, HumanReadableText.FAILED);
        }
    }

    public Set<Capability> enable(ImapRequest request, ImapProcessor.Responder responder, ImapSession session, Iterator<Capability> caps) throws PermitEnableCapabilityProcessor.EnableException {
        HashSet<Capability> enabledCaps = new HashSet<Capability>();
        while (caps.hasNext()) {
            Capability cap = caps.next();
            if (!this.capabilityProcessor.getSupportedCapabilities(session).contains(cap)) continue;
            for (PermitEnableCapabilityProcessor enableProcessor : capabilities) {
                if (!enableProcessor.getPermitEnableCapabilities(session).contains(cap)) continue;
                enableProcessor.enable(request, responder, session, cap);
                enabledCaps.add(cap);
            }
        }
        EnableProcessor.getEnabledCapabilities(session).addAll(enabledCaps);
        return enabledCaps;
    }

    public void addProcessor(PermitEnableCapabilityProcessor implementor) {
        capabilities.add(implementor);
    }

    public static Set<Capability> getEnabledCapabilities(ImapSession session) {
        HashSet caps = (HashSet)session.getAttribute(ENABLED_CAPABILITIES);
        if (caps == null) {
            caps = new HashSet();
            session.setAttribute(ENABLED_CAPABILITIES, caps);
        }
        return caps;
    }

    @Override
    public List<Capability> getImplementedCapabilities(ImapSession session) {
        return CAPS;
    }

    @Override
    protected Closeable addContextToMDC(EnableRequest request) {
        return MDCBuilder.create().addContext("action", (Object)"ENABLE").addContext("capabilities", (Object)ImmutableList.copyOf(request.getCapabilities())).build();
    }
}

