/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.github.fge.lambdas.Throwing;
import com.github.steveash.guavate.Guavate;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.request.ImapRequest;
import org.apache.james.imap.api.message.response.StatusResponse;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imap.main.PathConverter;
import org.apache.james.imap.message.request.AbstractMessageRangeRequest;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MessageRangeException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.UidValidity;
import org.apache.james.metrics.api.MetricFactory;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public abstract class AbstractMessageRangeProcessor<R extends AbstractMessageRangeRequest>
extends AbstractMailboxProcessor<R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMessageRangeProcessor.class);

    public AbstractMessageRangeProcessor(Class<R> acceptableClass, ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(acceptableClass, next, mailboxManager, factory, metricFactory);
    }

    protected abstract List<MessageRange> process(MailboxPath var1, SelectedMailbox var2, MailboxSession var3, MessageRange var4) throws MailboxException;

    protected abstract String getOperationName();

    @Override
    protected void processRequest(R request, ImapSession session, ImapProcessor.Responder responder) {
        MailboxPath targetMailbox = PathConverter.forSession(session).buildFullPath(((AbstractMessageRangeRequest)request).getMailboxName());
        try {
            MailboxSession mailboxSession = session.getMailboxSession();
            if (!((Boolean)Mono.from((Publisher)this.getMailboxManager().mailboxExists(targetMailbox, mailboxSession)).block()).booleanValue()) {
                this.no((ImapRequest)request, responder, HumanReadableText.FAILURE_NO_SUCH_MAILBOX, StatusResponse.ResponseCode.tryCreate());
            } else {
                StatusResponse.ResponseCode code = this.handleRanges(request, session, targetMailbox, mailboxSession);
                this.unsolicitedResponses(session, responder, ((AbstractMessageRangeRequest)request).isUseUids());
                this.okComplete((ImapRequest)request, code, responder);
            }
        }
        catch (MessageRangeException e) {
            LOGGER.debug("{} failed from mailbox {} to {} for invalid sequence-set {}", new Object[]{this.getOperationName(), session.getSelected().getMailboxId(), targetMailbox, ((AbstractMessageRangeRequest)request).getIdSet(), e});
            this.taggedBad((ImapRequest)request, responder, HumanReadableText.INVALID_MESSAGESET);
        }
        catch (MailboxException e) {
            LOGGER.error("{} failed from mailbox {} to {} for sequence-set {}", new Object[]{this.getOperationName(), session.getSelected().getMailboxId(), targetMailbox, ((AbstractMessageRangeRequest)request).getIdSet(), e});
            this.no((ImapRequest)request, responder, HumanReadableText.GENERIC_FAILURE_DURING_PROCESSING);
        }
    }

    private StatusResponse.ResponseCode handleRanges(R request, ImapSession session, MailboxPath targetMailbox, MailboxSession mailboxSession) throws MailboxException {
        MessageManager mailbox = this.getMailboxManager().getMailbox(targetMailbox, mailboxSession);
        IdRange[] resultUids = IdRange.mergeRanges((List)Arrays.stream(((AbstractMessageRangeRequest)request).getIdSet()).map(Throwing.function(range -> this.messageRange(session.getSelected(), (IdRange)range, request.isUseUids())).sneakyThrow()).filter(Objects::nonNull).flatMap(Throwing.function(range -> this.process(targetMailbox, session.getSelected(), mailboxSession, (MessageRange)range).stream()).sneakyThrow()).map(IdRange::from).collect(Guavate.toImmutableList())).toArray(new IdRange[0]);
        UidValidity uidValidity = mailbox.getMailboxEntity().getUidValidity();
        return StatusResponse.ResponseCode.copyUid(uidValidity, ((AbstractMessageRangeRequest)request).getIdSet(), resultUids);
    }
}

