/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import java.io.IOException;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.encode.ImapResponseEncoder;
import org.apache.james.imap.message.response.ListRightsResponse;
import org.apache.james.mailbox.model.MailboxACL;

public class ListRightsResponseEncoder
implements ImapResponseEncoder<ListRightsResponse> {
    @Override
    public Class<ListRightsResponse> acceptableMessages() {
        return ListRightsResponse.class;
    }

    @Override
    public void encode(ListRightsResponse listRightsResponse, ImapResponseComposer composer) throws IOException {
        MailboxACL.Rfc4314Rights[] rights;
        composer.untagged();
        composer.commandName(ImapConstants.LISTRIGHTS_COMMAND);
        String mailboxName = listRightsResponse.getMailboxName();
        composer.mailbox(mailboxName == null ? "" : mailboxName);
        String identifier = listRightsResponse.getIdentifier();
        composer.quote(identifier);
        for (MailboxACL.Rfc4314Rights entry : rights = listRightsResponse.getRights()) {
            composer.quote(entry.serialize());
        }
        composer.end();
    }
}

