/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.api.process;

import java.util.Optional;
import org.apache.james.core.Username;
import org.apache.james.imap.api.ImapSessionState;
import org.apache.james.imap.api.process.ImapLineHandler;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.mailbox.MailboxSession;

public interface ImapSession {
    public static final String MAILBOX_SESSION_ATTRIBUTE_SESSION_KEY = "org.apache.james.api.imap.MAILBOX_SESSION_ATTRIBUTE_SESSION_KEY";

    public void logout();

    public ImapSessionState getState();

    public void authenticated();

    public void selected(SelectedMailbox var1);

    public void deselect();

    public SelectedMailbox getSelected();

    public Object getAttribute(String var1);

    public void setAttribute(String var1, Object var2);

    public boolean startTLS();

    public boolean isTLSActive();

    public boolean supportStartTLS();

    public boolean isCompressionActive();

    public boolean isCompressionSupported();

    public boolean startCompression();

    public void pushLineHandler(ImapLineHandler var1);

    public void popLineHandler();

    public boolean supportMultipleNamespaces();

    public boolean isPlainAuthDisallowed();

    default public void setMailboxSession(MailboxSession mailboxSession) {
        this.setAttribute(MAILBOX_SESSION_ATTRIBUTE_SESSION_KEY, mailboxSession);
    }

    default public MailboxSession getMailboxSession() {
        return (MailboxSession)this.getAttribute(MAILBOX_SESSION_ATTRIBUTE_SESSION_KEY);
    }

    default public Username getUserName() {
        return Optional.ofNullable(this.getMailboxSession()).map(MailboxSession::getUser).orElse(null);
    }
}

