/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.api.message;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.imap.api.message.SectionType;

public class BodyFetchElement {
    private static final BodyFetchElement rfc822 = new BodyFetchElement("RFC822", SectionType.CONTENT, null, null, null, null);
    private static final BodyFetchElement rfc822Header = new BodyFetchElement("RFC822.HEADER", SectionType.HEADER, null, null, null, null);
    private static final BodyFetchElement rfc822Text = new BodyFetchElement("RFC822.TEXT", SectionType.TEXT, null, null, null, null);
    private final Long firstOctet;
    private final Long numberOfOctets;
    private final String name;
    private final SectionType sectionType;
    private final int[] path;
    private final Collection<String> fieldNames;

    public static final BodyFetchElement createRFC822() {
        return rfc822;
    }

    public static final BodyFetchElement createRFC822Header() {
        return rfc822Header;
    }

    public static final BodyFetchElement createRFC822Text() {
        return rfc822Text;
    }

    public BodyFetchElement(String name, SectionType sectionType, int[] path, Collection<String> fieldNames, Long firstOctet, Long numberOfOctets) {
        this.name = name;
        this.sectionType = sectionType;
        this.fieldNames = fieldNames;
        this.path = path;
        this.firstOctet = firstOctet;
        this.numberOfOctets = numberOfOctets;
    }

    public String getResponseName() {
        return this.name;
    }

    public final Collection<String> getFieldNames() {
        return this.fieldNames;
    }

    public final int[] getPath() {
        return this.path;
    }

    public final SectionType getSectionType() {
        return this.sectionType;
    }

    public final Long getFirstOctet() {
        return this.firstOctet;
    }

    public final Long getNumberOfOctets() {
        return this.numberOfOctets;
    }

    public final boolean equals(Object o) {
        if (o instanceof BodyFetchElement) {
            BodyFetchElement that = (BodyFetchElement)o;
            return Objects.equals((Object)this.sectionType, (Object)that.sectionType) && Objects.equals(this.firstOctet, that.firstOctet) && Objects.equals(this.numberOfOctets, that.numberOfOctets) && Objects.equals(this.name, that.name) && Arrays.equals(this.path, that.path) && Objects.equals(this.fieldNames, that.fieldNames);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(new Object[]{this.firstOctet, this.numberOfOctets, this.name, this.sectionType, Arrays.hashCode(this.path), this.fieldNames});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("firstOctet", (Object)this.firstOctet).add("numberOfOctets", (Object)this.numberOfOctets).add("name", (Object)this.name).add("sectionType", (Object)this.sectionType).add("fieldNames", Optional.ofNullable(this.fieldNames).map(ImmutableList::copyOf)).toString();
    }
}

