/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.api;

import com.github.steveash.guavate.Guavate;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.james.imap.api.message.Capability;

public class ImapConfiguration {
    public static final boolean DEFAULT_ENABLE_IDLE = true;
    public static final long DEFAULT_HEARTBEAT_INTERVAL_IN_SECONDS = 120L;
    public static final TimeUnit DEFAULT_HEARTBEAT_INTERVAL_UNIT = TimeUnit.SECONDS;
    private final long idleTimeInterval;
    private final TimeUnit idleTimeIntervalUnit;
    private final ImmutableSet<Capability> disabledCaps;
    private final boolean enableIdle;
    private final boolean isCondstoreEnable;

    public static Builder builder() {
        return new Builder();
    }

    private ImapConfiguration(boolean enableIdle, long idleTimeInterval, TimeUnit idleTimeIntervalUnit, ImmutableSet<Capability> disabledCaps, boolean isCondstoreEnable) {
        this.enableIdle = enableIdle;
        this.idleTimeInterval = idleTimeInterval;
        this.idleTimeIntervalUnit = idleTimeIntervalUnit;
        this.disabledCaps = disabledCaps;
        this.isCondstoreEnable = isCondstoreEnable;
    }

    public long getIdleTimeInterval() {
        return this.idleTimeInterval;
    }

    public TimeUnit getIdleTimeIntervalUnit() {
        return this.idleTimeIntervalUnit;
    }

    public ImmutableSet<Capability> getDisabledCaps() {
        return this.disabledCaps;
    }

    public boolean isEnableIdle() {
        return this.enableIdle;
    }

    public boolean isCondstoreEnable() {
        return this.isCondstoreEnable;
    }

    public final boolean equals(Object obj) {
        if (obj instanceof ImapConfiguration) {
            ImapConfiguration that = (ImapConfiguration)obj;
            return Objects.equal((Object)that.isEnableIdle(), (Object)this.enableIdle) && Objects.equal((Object)that.getIdleTimeInterval(), (Object)this.idleTimeInterval) && Objects.equal((Object)((Object)that.getIdleTimeIntervalUnit()), (Object)((Object)this.idleTimeIntervalUnit)) && Objects.equal(that.getDisabledCaps(), this.disabledCaps) && Objects.equal((Object)that.isCondstoreEnable(), (Object)this.isCondstoreEnable);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.enableIdle, this.idleTimeInterval, this.idleTimeIntervalUnit, this.disabledCaps, this.isCondstoreEnable});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("enabledIdle", this.enableIdle).add("idleTimeInterval", this.idleTimeInterval).add("idleTimeIntervalUnit", (Object)this.idleTimeIntervalUnit).add("disabledCaps", this.disabledCaps).add("isCondstoreEnable", this.isCondstoreEnable).toString();
    }

    public static class Builder {
        private static final boolean DEFAULT_CONDSTORE_DISABLE = false;
        private Optional<Long> idleTimeInterval = Optional.empty();
        private Optional<TimeUnit> idleTimeIntervalUnit = Optional.empty();
        private Optional<Boolean> enableIdle = Optional.empty();
        private ImmutableSet<String> disabledCaps = ImmutableSet.of();
        private Optional<Boolean> isCondstoreEnable = Optional.empty();

        private static boolean noBlankString(String disableCap) {
            return !StringUtils.isBlank((CharSequence)disableCap);
        }

        private Builder() {
        }

        public Builder idleTimeInterval(long idleTimeInterval) {
            Preconditions.checkArgument((idleTimeInterval > 0L ? 1 : 0) != 0, (Object)"The interval time should not be rezo or negative");
            this.idleTimeInterval = Optional.of(idleTimeInterval);
            return this;
        }

        public Builder idleTimeIntervalUnit(TimeUnit idleTimeIntervalUnit) {
            this.idleTimeIntervalUnit = Optional.of(idleTimeIntervalUnit);
            return this;
        }

        public Builder enableIdle(Boolean enableIdle) {
            this.enableIdle = Optional.of(enableIdle);
            return this;
        }

        public Builder disabledCaps(ImmutableSet<String> disabledCaps) {
            this.disabledCaps = disabledCaps;
            return this;
        }

        public Builder disabledCaps(String ... disableCaps) {
            this.disabledCaps = ImmutableSet.copyOf((Object[])disableCaps);
            return this;
        }

        public Builder disabledCap(String disableCap) {
            this.disabledCaps = ImmutableSet.of((Object)disableCap);
            return this;
        }

        public Builder isCondstoreEnable(boolean isCondstoreEnable) {
            this.isCondstoreEnable = Optional.of(isCondstoreEnable);
            return this;
        }

        public ImapConfiguration build() {
            ImmutableSet normalizeDisableCaps = (ImmutableSet)this.disabledCaps.stream().filter(Builder::noBlankString).map(StringUtils::normalizeSpace).map(Capability::of).collect(Guavate.toImmutableSet());
            return new ImapConfiguration(this.enableIdle.orElse(true), this.idleTimeInterval.orElse(120L), this.idleTimeIntervalUnit.orElse(DEFAULT_HEARTBEAT_INTERVAL_UNIT), normalizeDisableCaps, this.isCondstoreEnable.orElse(false));
        }
    }
}

