/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.streaming;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class LimitingFileInputStream
extends FileInputStream {
    private long pos = 0L;
    private final long limit;

    public LimitingFileInputStream(File file, long limit) throws FileNotFoundException {
        super(file);
        this.limit = limit;
    }

    @Override
    public int read() throws IOException {
        if (this.pos >= this.limit) {
            return -1;
        }
        ++this.pos;
        return super.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.pos >= this.limit) {
            return -1;
        }
        int readLimit = this.pos + (long)len >= this.limit ? (int)this.limit - (int)this.pos : len;
        int i = super.read(b, off, readLimit);
        this.pos += (long)i;
        return i;
    }

    @Override
    public long skip(long n) throws IOException {
        long currentPos = this.pos;
        long i = super.skip(n);
        if (currentPos == this.pos) {
            this.pos += i;
        }
        return i;
    }

    @Override
    public int available() throws IOException {
        int i = super.available();
        if (i == -1) {
            return -1;
        }
        if ((long)i >= this.limit) {
            return (int)this.limit - (int)this.pos;
        }
        return i;
    }

    public long getLimit() {
        return this.limit;
    }

    @Override
    public FileChannel getChannel() {
        return new LimitingFileChannel(super.getChannel());
    }

    private final class LimitingFileChannel
    extends FileChannel {
        private final FileChannel channel;

        public LimitingFileChannel(FileChannel channel) {
            this.channel = channel;
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            int r;
            int left;
            int bufLimit = dst.limit();
            if (bufLimit > (left = (int)this.bytesLeft())) {
                dst.limit(left);
                r = this.channel.read(dst);
                dst.limit(bufLimit);
            } else {
                r = this.channel.read(dst);
            }
            return r;
        }

        @Override
        public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
            long r = 0L;
            for (int a = offset; a < length; ++a) {
                r += (long)this.read(dsts[a]);
            }
            return r;
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            throw new IOException("Read-Only FileChannel");
        }

        @Override
        public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
            throw new IOException("Read-Only FileChannel");
        }

        @Override
        public long position() throws IOException {
            return this.channel.position();
        }

        @Override
        public FileChannel position(long newPosition) throws IOException {
            if (newPosition <= LimitingFileInputStream.this.limit) {
                this.channel.position(newPosition);
            }
            return this;
        }

        @Override
        public long size() throws IOException {
            return LimitingFileInputStream.this.limit;
        }

        @Override
        public FileChannel truncate(long size) throws IOException {
            throw new IOException("Read-Only FileChannel");
        }

        @Override
        public void force(boolean metaData) throws IOException {
            this.channel.force(metaData);
        }

        @Override
        public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
            if (position > LimitingFileInputStream.this.limit) {
                return 0L;
            }
            long left = this.bytesLeft();
            if (count > left) {
                count = left;
            }
            return this.channel.transferTo(position, count, target);
        }

        @Override
        public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
            throw new IOException("Read-Only FileChannel");
        }

        @Override
        public int read(ByteBuffer dst, long position) throws IOException {
            int r;
            int left;
            if (position > this.size()) {
                return 0;
            }
            int bufLimit = dst.limit();
            if (bufLimit > (left = (int)this.bytesLeft())) {
                dst.limit(left);
                r = this.channel.read(dst, position);
                dst.limit(bufLimit);
            } else {
                r = this.channel.read(dst, position);
            }
            return r;
        }

        @Override
        public int write(ByteBuffer src, long position) throws IOException {
            throw new IOException("Read-Only FileChannel");
        }

        @Override
        public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
            return this.channel.map(mode, position, size);
        }

        @Override
        public FileLock lock(long position, long size, boolean shared) throws IOException {
            return this.channel.lock(position, size, shared);
        }

        @Override
        public FileLock tryLock(long position, long size, boolean shared) throws IOException {
            return this.channel.tryLock(position, size, shared);
        }

        @Override
        protected void implCloseChannel() throws IOException {
            this.channel.close();
        }

        private long bytesLeft() throws IOException {
            return LimitingFileInputStream.this.limit - this.position();
        }
    }
}

