/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.search.comparator;

import com.google.common.annotations.VisibleForTesting;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.Comparator;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.search.comparator.AbstractHeaderComparator;
import org.apache.james.util.date.ImapDateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentDateComparator
extends AbstractHeaderComparator {
    public static final Comparator<MailboxMessage> SENTDATE = new SentDateComparator();
    private static final Logger LOGGER = LoggerFactory.getLogger(SentDateComparator.class);
    private static final Pattern DATE_SANITIZING_PATTERN = Pattern.compile(" *\\(.*\\) *");

    public static Optional<ZonedDateTime> toISODate(String value) {
        try {
            return Optional.of(ZonedDateTime.parse(SentDateComparator.sanitizeDateStringHeaderValue(value), ImapDateTimeFormatter.rfc5322()));
        }
        catch (Exception e) {
            LOGGER.info("Can not parse receive date {}", (Object)value);
            return Optional.empty();
        }
    }

    @VisibleForTesting
    static String sanitizeDateStringHeaderValue(String value) {
        Matcher sanitizerMatcher = DATE_SANITIZING_PATTERN.matcher(value);
        if (sanitizerMatcher.find()) {
            return value.substring(0, sanitizerMatcher.start());
        }
        return value;
    }

    @Override
    public int compare(MailboxMessage o1, MailboxMessage o2) {
        Instant date1 = this.getSentDate(o1);
        Instant date2 = this.getSentDate(o2);
        return date1.compareTo(date2);
    }

    private Instant getSentDate(MailboxMessage message) {
        String value = this.getHeaderValue("Date", message);
        return SentDateComparator.toISODate(value).map(ChronoZonedDateTime::toInstant).orElse(message.getInternalDate().toInstant());
    }
}

