/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.search.comparator;

import com.github.steveash.guavate.Guavate;
import com.google.common.base.Preconditions;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.search.comparator.BaseSubjectComparator;
import org.apache.james.mailbox.store.search.comparator.HeaderDisplayComparator;
import org.apache.james.mailbox.store.search.comparator.HeaderMailboxComparator;
import org.apache.james.mailbox.store.search.comparator.MessageComparators;
import org.apache.james.mailbox.store.search.comparator.SentDateComparator;

public class CombinedComparator
implements Comparator<MailboxMessage> {
    private final List<Comparator<MailboxMessage>> comparators;

    public static CombinedComparator create(List<SearchQuery.Sort> sorts) {
        Preconditions.checkNotNull(sorts);
        Preconditions.checkArgument((!sorts.isEmpty() ? 1 : 0) != 0);
        return new CombinedComparator((List)sorts.stream().map(CombinedComparator.toComparator()).collect(Guavate.toImmutableList()));
    }

    private static Function<SearchQuery.Sort, Comparator<MailboxMessage>> toComparator() {
        return sort -> CombinedComparator.optionalResverse(CombinedComparator.toComparator(sort), sort.isReverse());
    }

    private static Comparator<MailboxMessage> toComparator(SearchQuery.Sort sort) {
        switch (sort.getSortClause()) {
            case Arrival: {
                return MessageComparators.INTERNAL_DATE_COMPARATOR;
            }
            case MailboxCc: {
                return HeaderMailboxComparator.CC_COMPARATOR;
            }
            case MailboxFrom: {
                return HeaderMailboxComparator.FROM_COMPARATOR;
            }
            case Size: {
                return MessageComparators.SIZE_COMPARATOR;
            }
            case BaseSubject: {
                return BaseSubjectComparator.BASESUBJECT;
            }
            case MailboxTo: {
                return HeaderMailboxComparator.TO_COMPARATOR;
            }
            case Uid: {
                return MessageComparators.UID_COMPARATOR;
            }
            case SentDate: {
                return SentDateComparator.SENTDATE;
            }
            case DisplayFrom: {
                return HeaderDisplayComparator.FROM_COMPARATOR;
            }
            case DisplayTo: {
                return HeaderDisplayComparator.TO_COMPARATOR;
            }
            case Id: {
                return MessageComparators.MESSAGE_ID_COMPARATOR;
            }
        }
        throw new NotImplementedException("Combined comparator does not support sort " + sort.getSortClause());
    }

    private static Comparator<MailboxMessage> optionalResverse(Comparator<MailboxMessage> comparator, boolean isReverse) {
        if (isReverse) {
            return comparator.reversed();
        }
        return comparator;
    }

    public List<Comparator<MailboxMessage>> getComparators() {
        return this.comparators;
    }

    private CombinedComparator(List<Comparator<MailboxMessage>> comparators) {
        this.comparators = comparators;
    }

    @Override
    public int compare(MailboxMessage o1, MailboxMessage o2) {
        return this.comparators.stream().map(comparator -> comparator.compare(o1, o2)).filter(result -> result != 0).findFirst().orElse(0);
    }
}

